/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIScreenRecipeSelector
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_recipe_selector.png");
    protected int xSize = 176;
    protected int ySize = 132;
    protected int guiLeft;
    protected int guiTop;
    protected GenericRecipes recipeSet;
    protected List<GenericRecipe> recipes = new ArrayList<GenericRecipe>();
    protected GuiTextField search;
    protected int pageIndex;
    protected int size;
    protected String selection;
    public static final String NULL_SELECTION = "null";
    protected int index;
    protected IControlReceiver tile;
    protected GuiScreen previousScreen;
    protected String installedPool;

    public static void openSelector(GenericRecipes recipeSet, IControlReceiver tile, String selection, int index, String installedPool, GuiScreen previousScreen) {
        FMLCommonHandler.instance().showGuiScreen((Object)new GUIScreenRecipeSelector(recipeSet, tile, selection, index, installedPool, previousScreen));
    }

    public GUIScreenRecipeSelector(GenericRecipes recipeSet, IControlReceiver tile, String selection, int index, String installedPool, GuiScreen previousScreen) {
        this.recipeSet = recipeSet;
        this.tile = tile;
        this.selection = selection;
        this.index = index;
        this.installedPool = installedPool;
        this.previousScreen = previousScreen;
        if (this.selection == null) {
            this.selection = NULL_SELECTION;
        }
        this.regenerateRecipes();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(this.field_146289_q, this.guiLeft + 28, this.guiTop + 111, 102, 12);
        this.search.func_146193_g(-1);
        this.search.func_146204_h(-1);
        this.search.func_146185_a(false);
        this.search.func_146203_f(32);
    }

    private void regenerateRecipes() {
        this.recipes.clear();
        for (Object o : this.recipeSet.recipeOrderedList) {
            GenericRecipe recipe = (GenericRecipe)o;
            if (recipe.isPooled() && (this.installedPool == null || !recipe.isPartOfPool(this.installedPool))) continue;
            this.recipes.add(recipe);
        }
        this.resetPaging();
    }

    private void search(String search) {
        this.recipes.clear();
        if (search.isEmpty()) {
            this.regenerateRecipes();
        } else {
            for (Object o : this.recipeSet.recipeOrderedList) {
                GenericRecipe recipe = (GenericRecipe)o;
                if (!recipe.matchesSearch(search) || recipe.isPooled() && (this.installedPool == null || !recipe.isPartOfPool(this.installedPool))) continue;
                this.recipes.add(recipe);
            }
            this.resetPaging();
        }
    }

    private void resetPaging() {
        this.pageIndex = 0;
        this.size = Math.max(0, (int)Math.ceil((double)(this.recipes.size() - 40) / 8.0));
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
        this.handleScroll();
        if (this.guiLeft + 7 <= mouseX && this.guiLeft + 7 + 144 > mouseX && this.guiTop + 17 < mouseY && this.guiTop + 17 + 90 >= mouseY) {
            for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.recipes.size(); ++i) {
                int ind = i - this.pageIndex * 8;
                int ix = 7 + 18 * (ind % 8);
                int iy = 17 + 18 * (ind / 8);
                if (this.guiLeft + ix > mouseX || this.guiLeft + ix + 18 <= mouseX || this.guiTop + iy >= mouseY || this.guiTop + iy + 18 < mouseY) continue;
                GenericRecipe recipe = this.recipes.get(i);
                this.func_146283_a(recipe.print(), 0, 900);
            }
        }
        if (this.guiLeft + 151 <= mouseX && this.guiLeft + 151 + 18 > mouseX && this.guiTop + 71 < mouseY && this.guiTop + 71 + 18 >= mouseY && this.selection != null && this.recipeSet.recipeNameMap.containsKey(this.selection)) {
            GenericRecipe recipe = (GenericRecipe)this.recipeSet.recipeNameMap.get(this.selection);
            this.func_146283_a(recipe.print(), 0, 900);
        }
        if (this.guiLeft + 152 <= mouseX && this.guiLeft + 152 + 16 > mouseX && this.guiTop + 90 < mouseY && this.guiTop + 90 + 16 >= mouseY) {
            this.func_146279_a(EnumChatFormatting.YELLOW + "Close", mouseX, mouseY);
        }
        if (this.guiLeft + 134 <= mouseX && this.guiLeft + 134 + 16 > mouseX && this.guiTop + 108 < mouseY && this.guiTop + 108 + 16 >= mouseY) {
            this.func_146279_a(EnumChatFormatting.YELLOW + "Clear search", mouseX, mouseY);
        }
        if (this.guiLeft + 8 <= mouseX && this.guiLeft + 8 + 16 > mouseX && this.guiTop + 108 < mouseY && this.guiTop + 108 + 16 >= mouseY) {
            this.func_146279_a(EnumChatFormatting.ITALIC + "Press ENTER to toggle focus", mouseX, mouseY);
        }
    }

    protected void handleScroll() {
        if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && Mouse.next()) {
            int scroll = Mouse.getEventDWheel();
            if (scroll > 0 && this.pageIndex > 0) {
                --this.pageIndex;
            }
            if (scroll < 0 && this.pageIndex < this.size) {
                ++this.pageIndex;
            }
        }
    }

    private void drawGuiContainerForegroundLayer(int x, int y) {
        this.search.func_146194_f();
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GenericRecipe recipe;
        int ind;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 26, this.guiTop + 108, 0, 132, 106, 16);
        }
        if (this.guiLeft + 152 <= mouseX && this.guiLeft + 152 + 16 > mouseX && this.guiTop + 18 < mouseY && this.guiTop + 18 + 16 >= mouseY) {
            this.func_73729_b(this.guiLeft + 152, this.guiTop + 18, 176, 0, 16, 16);
        }
        if (this.guiLeft + 152 <= mouseX && this.guiLeft + 152 + 16 > mouseX && this.guiTop + 36 < mouseY && this.guiTop + 36 + 16 >= mouseY) {
            this.func_73729_b(this.guiLeft + 152, this.guiTop + 36, 176, 16, 16, 16);
        }
        if (this.guiLeft + 152 <= mouseX && this.guiLeft + 152 + 16 > mouseX && this.guiTop + 90 < mouseY && this.guiTop + 90 + 16 >= mouseY) {
            this.func_73729_b(this.guiLeft + 152, this.guiTop + 90, 176, 32, 16, 16);
        }
        if (this.guiLeft + 134 <= mouseX && this.guiLeft + 134 + 16 > mouseX && this.guiTop + 108 < mouseY && this.guiTop + 108 + 16 >= mouseY) {
            this.func_73729_b(this.guiLeft + 134, this.guiTop + 108, 176, 48, 16, 16);
        }
        if (this.guiLeft + 8 <= mouseX && this.guiLeft + 8 + 16 > mouseX && this.guiTop + 108 < mouseY && this.guiTop + 108 + 16 >= mouseY) {
            this.func_73729_b(this.guiLeft + 8, this.guiTop + 108, 176, 64, 16, 16);
        }
        for (i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.recipes.size(); ++i) {
            ind = i - this.pageIndex * 8;
            recipe = this.recipes.get(i);
            if (!recipe.getInternalName().equals(this.selection)) continue;
            this.func_73729_b(this.guiLeft + 7 + 18 * (ind % 8), this.guiTop + 17 + 18 * (ind / 8), 192, 0, 18, 18);
        }
        for (i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.recipes.size(); ++i) {
            ind = i - this.pageIndex * 8;
            recipe = this.recipes.get(i);
            this.renderItem(recipe.getIcon(), 8 + 18 * (ind % 8), 18 + 18 * (ind / 8));
            this.field_146297_k.func_110434_K().func_110577_a(texture);
        }
        if (this.selection != null && this.recipeSet.recipeNameMap.containsKey(this.selection)) {
            GenericRecipe recipe2 = (GenericRecipe)this.recipeSet.recipeNameMap.get(this.selection);
            this.renderItem(recipe2.getIcon(), 152, 72);
        }
    }

    public void renderItem(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)32826);
        GUIScreenRecipeSelector.field_146296_j.field_77023_b = 100.0f;
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, this.guiLeft + x, this.guiTop + y);
        GUIScreenRecipeSelector.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2896);
    }

    protected void func_73864_a(int x, int y, int k) {
        super.func_73864_a(x, y, k);
        this.search.func_146192_a(x, y, k);
        if (this.guiLeft + 152 <= x && this.guiLeft + 152 + 16 > x && this.guiTop + 18 < y && this.guiTop + 18 + 16 >= y) {
            this.click();
            if (this.pageIndex > 0) {
                --this.pageIndex;
            }
            return;
        }
        if (this.guiLeft + 152 <= x && this.guiLeft + 152 + 16 > x && this.guiTop + 36 < y && this.guiTop + 36 + 16 >= y) {
            this.click();
            if (this.pageIndex < this.size) {
                ++this.pageIndex;
            }
            return;
        }
        if (this.guiLeft + 134 <= x && this.guiLeft + 134 + 16 > x && this.guiTop + 108 < y && this.guiTop + 108 + 16 >= y) {
            this.search.func_146180_a("");
            this.search("");
            this.search.func_146195_b(true);
            return;
        }
        for (int i = this.pageIndex * 8; i < this.pageIndex * 8 + 40 && i < this.recipes.size(); ++i) {
            int ind = i - this.pageIndex * 8;
            int ix = 7 + 18 * (ind % 8);
            int iy = 17 + 18 * (ind / 8);
            if (this.guiLeft + ix > x || this.guiLeft + ix + 18 <= x || this.guiTop + iy >= y || this.guiTop + iy + 18 < y) continue;
            String newSelection = this.recipes.get(i).getInternalName();
            this.selection = !newSelection.equals(this.selection) ? newSelection : NULL_SELECTION;
            this.click();
            return;
        }
        if (this.guiLeft + 151 <= x && this.guiLeft + 151 + 18 > x && this.guiTop + 71 < y && this.guiTop + 71 + 18 >= y && !NULL_SELECTION.equals(this.selection)) {
            this.selection = NULL_SELECTION;
            this.click();
            return;
        }
        if (this.guiLeft + 152 <= x && this.guiLeft + 152 + 16 > x && this.guiTop + 90 < y && this.guiTop + 90 + 16 >= y) {
            FMLCommonHandler.instance().showGuiScreen((Object)this.previousScreen);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("index", this.index);
        data.func_74778_a("selection", this.selection);
        TileEntity te = (TileEntity)this.tile;
        PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, te.field_145851_c, te.field_145848_d, te.field_145849_e));
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 28) {
            this.search.func_146195_b(!this.search.func_146206_l());
            return;
        }
        if (this.search.func_146201_a(typedChar, keyCode)) {
            this.search(this.search.func_146179_b());
            return;
        }
        if (keyCode == 200) {
            --this.pageIndex;
        }
        if (keyCode == 208) {
            ++this.pageIndex;
        }
        if (keyCode == 201) {
            this.pageIndex -= 5;
        }
        if (keyCode == 209) {
            this.pageIndex += 5;
        }
        if (keyCode == 199) {
            this.pageIndex = 0;
        }
        if (keyCode == 207) {
            this.pageIndex = this.size;
        }
        this.pageIndex = MathHelper.func_76125_a((int)this.pageIndex, (int)0, (int)this.size);
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            FMLCommonHandler.instance().showGuiScreen((Object)this.previousScreen);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void click() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }
}

