/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.items.ModItems;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.ItemDesignatorPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIScreenDesignator
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_designator.png");
    protected int xSize = 176;
    protected int ySize = 178;
    protected int guiLeft;
    protected int guiTop;
    int shownX;
    int shownZ;
    int currentPage = 0;
    List<ItemStack> stacks = new ArrayList<ItemStack>();
    List<FolderButton> buttons = new ArrayList<FolderButton>();
    private final EntityPlayer player;

    public GUIScreenDesignator(EntityPlayer player) {
        this.player = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.shownX = 0;
        this.shownZ = 0;
        ItemStack stack = this.player.func_70694_bm();
        if (stack != null && stack.func_77973_b() == ModItems.designator_manual && stack.func_77942_o()) {
            this.shownX = stack.field_77990_d.func_74762_e("xCoord");
            this.shownZ = stack.field_77990_d.func_74762_e("zCoord");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttons.clear();
        this.buttons.add(new FolderButton(this.guiLeft + 25, this.guiTop + 26, 0, 0, 0, 1, null));
        this.buttons.add(new FolderButton(this.guiLeft + 52, this.guiTop + 26, 1, 0, 0, 5, null));
        this.buttons.add(new FolderButton(this.guiLeft + 79, this.guiTop + 26, 2, 0, 0, 10, null));
        this.buttons.add(new FolderButton(this.guiLeft + 106, this.guiTop + 26, 3, 0, 0, 50, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 26, 4, 0, 0, 100, null));
        this.buttons.add(new FolderButton(this.guiLeft + 25, this.guiTop + 62, 5, 1, 0, 1, null));
        this.buttons.add(new FolderButton(this.guiLeft + 52, this.guiTop + 62, 6, 1, 0, 5, null));
        this.buttons.add(new FolderButton(this.guiLeft + 79, this.guiTop + 62, 7, 1, 0, 10, null));
        this.buttons.add(new FolderButton(this.guiLeft + 106, this.guiTop + 62, 8, 1, 0, 50, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 62, 9, 1, 0, 100, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 44, 10, 2, 0, 0, "Set coord to current X position..."));
        this.buttons.add(new FolderButton(this.guiLeft + 25, this.guiTop + 26 + 72, 0, 0, 1, 1, null));
        this.buttons.add(new FolderButton(this.guiLeft + 52, this.guiTop + 26 + 72, 1, 0, 1, 5, null));
        this.buttons.add(new FolderButton(this.guiLeft + 79, this.guiTop + 26 + 72, 2, 0, 1, 10, null));
        this.buttons.add(new FolderButton(this.guiLeft + 106, this.guiTop + 26 + 72, 3, 0, 1, 50, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 26 + 72, 4, 0, 1, 100, null));
        this.buttons.add(new FolderButton(this.guiLeft + 25, this.guiTop + 62 + 72, 5, 1, 1, 1, null));
        this.buttons.add(new FolderButton(this.guiLeft + 52, this.guiTop + 62 + 72, 6, 1, 1, 5, null));
        this.buttons.add(new FolderButton(this.guiLeft + 79, this.guiTop + 62 + 72, 7, 1, 1, 10, null));
        this.buttons.add(new FolderButton(this.guiLeft + 106, this.guiTop + 62 + 72, 8, 1, 1, 50, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 62 + 72, 9, 1, 1, 100, null));
        this.buttons.add(new FolderButton(this.guiLeft + 133, this.guiTop + 44 + 72, 10, 2, 1, 0, "Set coord to current Z position..."));
    }

    protected void func_73864_a(int i, int j, int k) {
        try {
            for (FolderButton b : this.buttons) {
                if (!b.isMouseOnButton(i, j)) continue;
                b.executeAction();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        for (FolderButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
        String x = String.valueOf(this.shownX);
        String z = String.valueOf(this.shownZ);
        this.field_146289_q.func_78276_b("X: " + x, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a("X: " + x) / 2, this.guiTop + 50, 0x404040);
        this.field_146289_q.func_78276_b("Z: " + z, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a("Z: " + z) / 2, this.guiTop + 50 + 72, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (FolderButton b : this.buttons) {
            b.drawButton(b.isMouseOnButton(i, j));
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73876_c() {
        if (this.player.func_70694_bm() == null || this.player.func_70694_bm().func_77973_b() != ModItems.designator_manual) {
            this.player.func_71053_j();
        }
    }

    class FolderButton {
        int xPos;
        int yPos;
        int type;
        int operator;
        int value;
        int reference;
        String info;

        public FolderButton(int x, int y, int t, int o, int r, int v, String i) {
            this.xPos = x;
            this.yPos = y;
            this.type = t;
            this.operator = o;
            this.value = v;
            this.reference = r;
            this.info = i;
        }

        public void updateButton(int mouseX, int mouseY) {
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton(boolean b) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GUIScreenDesignator.this.func_73729_b(this.xPos, this.yPos, b ? 194 : 176, this.type * 18, 18, 18);
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            String s = this.info;
            GUIScreenDesignator.this.func_146283_a(Arrays.asList(s), x, y);
        }

        public void executeAction() {
            GUIScreenDesignator.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            PacketDispatcher.wrapper.sendToServer(new ItemDesignatorPacket(this.operator, this.value, this.reference));
            int result = 0;
            if (this.operator == 0) {
                result += this.value;
            }
            if (this.operator == 1) {
                result -= this.value;
            }
            if (this.operator == 2) {
                if (this.reference == 0) {
                    GUIScreenDesignator.this.shownX = (int)Math.round(((GUIScreenDesignator)GUIScreenDesignator.this).player.field_70165_t);
                } else {
                    GUIScreenDesignator.this.shownZ = (int)Math.round(((GUIScreenDesignator)GUIScreenDesignator.this).player.field_70161_v);
                }
                return;
            }
            if (this.reference == 0) {
                GUIScreenDesignator.this.shownX += result;
            } else {
                GUIScreenDesignator.this.shownZ += result;
            }
        }
    }
}

