/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.interfaces;

import com.google.common.annotations.Beta;
import com.hbm.interfaces.Spaghetti;
import com.hbm.main.MainRegistry;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.apache.logging.log4j.Level;

@Beta
@Spaghetti(value="AAAAAAAA")
public interface ICustomWarhead {
    public static final String KEY_ANTHRAX = "warheadFuel.ANTHRAX";
    public static final String KEY_MKU = "warheadFuel.MKU";
    public static final String KEY_CAUSTIC = "warheadFuel.ACID";
    public static final String KEY_NERVE = "warheadFuel.NERVE";
    public static final String KEY_TOX = "warheadFuel.TOX";
    public static final String NBT_GROUP = "NTM_NUKE_INFO";
    public static final String NBT_YIELD = "YIELD";
    public static final String NBT_ALTITUDE = "ALTITUDE";
    public static final String NBT_MASS = "MASS";
    public static final String NBT_SPECIAL = "SPECIAL_FIELD";
    public static final String NBT_WARHEAD = "WARHEAD";
    public static final String NBT_TYPE = "WARHEAD_TYPE";
    public static final String NBT_TRAIT = "WARHEAD_TRAIT";
    public static final DecimalFormat df = new DecimalFormat("#.00");

    public static EnumChatFormatting getColorFromWarhead(EnumCustomWarhead warhead) {
        switch (warhead) {
            case AMAT: {
                return EnumChatFormatting.DARK_RED;
            }
            case BF: {
                return EnumChatFormatting.GREEN;
            }
            case BIO: {
                return EnumChatFormatting.GOLD;
            }
            case CHEM: {
                return EnumChatFormatting.YELLOW;
            }
            case FUSION: {
                return EnumChatFormatting.BLUE;
            }
            case GRAV: {
                return EnumChatFormatting.DARK_GRAY;
            }
            case HE: {
                return EnumChatFormatting.RED;
            }
            case NUCLEAR: {
                return EnumChatFormatting.DARK_GREEN;
            }
            case SCHRAB: {
                return EnumChatFormatting.AQUA;
            }
            case TX: {
                return EnumChatFormatting.DARK_PURPLE;
            }
            case ZPE: {
                return System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.DARK_AQUA : EnumChatFormatting.LIGHT_PURPLE;
            }
        }
        return EnumChatFormatting.WHITE;
    }

    default public float getYield() {
        return 0.0f;
    }

    default public EnumCustomWarhead getWarheadType(NBTTagCompound data) {
        return EnumCustomWarhead.valueOf(data.func_74779_i(NBT_WARHEAD));
    }

    default public EnumWeaponType getWeaponType(NBTTagCompound data) {
        return EnumWeaponType.valueOf(data.func_74779_i(NBT_TYPE));
    }

    default public EnumCustomWarheadTrait getWeaponTrait(NBTTagCompound data) {
        return EnumCustomWarheadTrait.valueOf(data.func_74779_i(NBT_TRAIT));
    }

    public ItemStack constructNew();

    public ICustomWarhead getInstance();

    default public Item getItem() {
        return (Item)this;
    }

    public static ItemStack addData(NBTTagCompound data, Item item) {
        ItemStack stackOut = new ItemStack(item);
        stackOut.field_77990_d = new NBTTagCompound();
        stackOut.field_77990_d.func_74782_a(NBT_GROUP, (NBTBase)data);
        return stackOut.func_77946_l();
    }

    default public NBTTagCompound getWarheadData(ItemStack stack) {
        return stack.func_77978_p().func_74775_l(NBT_GROUP);
    }

    default public ItemStack addFuel(ItemStack stack, Enum<?> fuel, float amount) {
        if (stack != null && stack.func_77973_b() instanceof ICustomWarhead) {
            NBTTagCompound data = this.getWarheadData(stack);
            data.func_74776_a(fuel.toString(), amount);
            data.func_74776_a(NBT_MASS, data.func_74760_g(NBT_MASS) + amount);
        }
        return stack;
    }

    default public ItemStack addData(ItemStack stack, String key, String value) {
        if (stack != null && stack.func_77973_b() instanceof ICustomWarhead) {
            this.getWarheadData(stack).func_74778_a(key, value);
        }
        return stack;
    }

    default public void addCompositionalInfo(NBTTagCompound data, List<String> tooltip, List<Enum<?>> combinedFuels) {
        for (Enum<?> f : combinedFuels) {
            if (!(data.func_74760_g(f.toString()) > 0.0f)) continue;
            tooltip.add(String.format(Locale.US, "%s: %skg (%s)", I18nUtil.resolveKey("warheadFuel.".concat(f.toString()), new Object[0]), df.format(data.func_74760_g(f.toString())), BobMathUtil.toPercentage(data.func_74760_g(f.toString()), data.func_74760_g(NBT_MASS))));
        }
    }

    default public void addTooltip(ItemStack stack, List<String> tooltip) {
        try {
            NBTTagCompound data = this.getWarheadData(stack);
            ArrayList combinedFuels = new ArrayList();
            combinedFuels.addAll(Arrays.asList(FissileFuel.values()));
            combinedFuels.addAll(Arrays.asList(FusionFuel.values()));
            combinedFuels.addAll(Arrays.asList(SaltedFuel.values()));
            combinedFuels.addAll(Arrays.asList(EnumCustomWarhead.values()));
            switch (this.getWarheadType(data)) {
                case HE: 
                case NUCLEAR: 
                case TX: {
                    tooltip.add("Composition:");
                    this.addCompositionalInfo(data, tooltip, combinedFuels);
                    break;
                }
            }
            EnumCustomWarhead warhead = this.getWarheadType(data);
            tooltip.add(data.func_74760_g(NBT_MASS) + "kg total");
            tooltip.add("");
            switch (warhead) {
                case BIO: 
                case CHEM: {
                    tooltip.add("Type: " + ICustomWarhead.getColorFromWarhead(warhead) + I18nUtil.resolveKey("warhead.".concat(warhead.toString()), I18nUtil.resolveKey(data.func_74779_i(NBT_SPECIAL), new Object[0])));
                    break;
                }
                default: {
                    tooltip.add("Type: " + ICustomWarhead.getColorFromWarhead(warhead) + warhead.getLoc());
                }
            }
            tooltip.add("Function: " + this.getWeaponType(data).getLoc());
            switch (warhead) {
                case AMAT: 
                case BF: 
                case FUSION: 
                case GRAV: 
                case HE: 
                case NUCLEAR: 
                case TX: {
                    tooltip.add("Yield: " + BobMathUtil.getShortNumber(data.func_74762_e(NBT_YIELD)) + "T");
                    break;
                }
                case BIO: 
                case CHEM: 
                case SCHRAB: {
                    tooltip.add("Radius: " + BobMathUtil.getShortNumber(data.func_74762_e(NBT_YIELD)) + "M");
                    break;
                }
            }
            tooltip.add("Trait: " + this.getWeaponTrait(data).getLoc());
        }
        catch (Exception e) {
            MainRegistry.logger.catching(Level.ERROR, (Throwable)e);
        }
    }

    public static enum SaltedFuel {
        Co59(1.11765f, 5, HalfLifeType.MEDIUM, 8.86f),
        Co60(1.4902f, 5, HalfLifeType.MEDIUM, 8.86f),
        Sr90(0.546f, 28, HalfLifeType.MEDIUM, 2.64f),
        Cs137(1.1737f, 30, HalfLifeType.MEDIUM, 1.93f),
        Ta181(0.39f, 114, HalfLifeType.SHORT, 16.65f),
        Ta182(0.52f, 114, HalfLifeType.SHORT, 16.654f),
        Au197(1.030125f, 2, HalfLifeType.SHORT, 19.32f),
        Au198(1.3735f, 2, HalfLifeType.SHORT, 19.32f),
        Pu240(5.25575f, 65, HalfLifeType.LONG, 19.86f),
        Sa327(0.5f, 100, HalfLifeType.LONG, 39.7f);

        public final float decayEnergy;
        public final int halfLife;
        public final HalfLifeType type;
        private final float mass;

        private SaltedFuel(float decayEnergy, int halfLife, HalfLifeType type, float mass) {
            this.decayEnergy = decayEnergy;
            this.halfLife = halfLife;
            this.type = type;
            this.mass = mass;
        }

        public float getBlockMass() {
            return this.mass * 100.0f;
        }

        public float getIngotMass() {
            return this.getBlockMass() / 9.0f;
        }

        public float getNuggetMass() {
            return this.getIngotMass() / 9.0f;
        }

        public static enum HalfLifeType {
            SHORT,
            MEDIUM,
            LONG;

        }
    }

    public static enum FusionFuel {
        DEUT,
        TRIT,
        Li,
        LiDEUT;


        public String getLoc() {
            return I18nUtil.resolveKey("warheadFuel".concat(this.toString()), new Object[0]);
        }
    }

    public static enum FissileFuel {
        U233(15.0f, 197.5f, 5.0f, 19.05f),
        U235(52.0f, 202.5f, 1.0f, 19.05f),
        Np237(60.0f, 202.5f, 2.5f, 20.45f),
        Pu239(10.0f, 207.1f, 5.0f, 19.86f),
        Pu241(12.0f, 210.0f, 25.0f, 19.86f),
        Am241(66.0f, 210.0f, 8.5f, 13.67f),
        Am242m(11.0f, 212.0f, 9.5f, 13.67f),
        Sa326(1.0f, 250.0f, 15.0f, 39.7f);

        public final float criticalMass;
        public final float energyReleased;
        public final float radioactivity;
        private final float mass;

        private FissileFuel(float criticalMass, float energyReleased, float radioactivity, float mass) {
            this.criticalMass = criticalMass;
            this.energyReleased = energyReleased;
            this.radioactivity = radioactivity;
            this.mass = mass;
        }

        public float getBlockMass() {
            return this.mass * 100.0f;
        }

        public float getIngotMass() {
            return this.getBlockMass() / 9.0f;
        }

        public float getNuggetMass() {
            return this.getIngotMass() / 9.0f;
        }

        public String getLoc() {
            return I18nUtil.resolveKey("warheadFuel.".concat(this.toString()), new Object[0]);
        }
    }

    public static enum EnumWeaponType {
        DENIAL,
        STRATEGIC,
        TACTICAL,
        WMD;


        public String getLoc() {
            return I18nUtil.resolveKey("warheadType.".concat(this.toString()), new Object[0]);
        }
    }

    public static enum EnumCustomWarheadTrait {
        CLEAN,
        CLEANISH,
        DIRTY,
        RAD,
        SALT;


        public String getLoc() {
            return I18nUtil.resolveKey("warheadTrait.".concat(this.toString()), new Object[0]);
        }
    }

    public static enum EnumCustomWarhead {
        AMAT,
        BF,
        BIO,
        CHEM,
        FUSION,
        GRAV,
        HE,
        NUCLEAR,
        TX,
        SCHRAB,
        ZPE;


        public String getLoc() {
            return I18nUtil.resolveKey("warhead.".concat(this.toString()), new Object[0]);
        }

        public static enum EnumBioType {
            ANTHRAX,
            MKU;


            public String getLoc() {
                return I18nUtil.resolveKey("warhead.BIO.".concat(this.toString()), new Object[0]);
            }
        }

        public static enum EnumChemicalType {
            ACID,
            CHLORINE,
            NERVE,
            TOX;


            public String getLoc() {
                return I18nUtil.resolveKey("warhead.CHEM.".concat(this.toString()), new Object[0]);
            }
        }
    }
}

