/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.config.RadiationConfig;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.handler.radiation.ChunkRadiationHandlerSimple;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationManager {
    public static ChunkRadiationHandler proxy = new ChunkRadiationHandlerSimple();
    int eggTimer = 0;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (RadiationConfig.enableChunkRads) {
            proxy.receiveWorldLoad(event);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (RadiationConfig.enableChunkRads) {
            proxy.receiveWorldUnload(event);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (RadiationConfig.enableChunkRads) {
            proxy.receiveChunkLoad(event);
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        if (RadiationConfig.enableChunkRads) {
            proxy.receiveChunkSave(event);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (RadiationConfig.enableChunkRads) {
            proxy.receiveChunkUnload(event);
        }
    }

    @SubscribeEvent
    public void updateSystem(TickEvent.ServerTickEvent event) {
        if (RadiationConfig.enableChunkRads && event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            ++this.eggTimer;
            if (this.eggTimer >= 20) {
                proxy.updateSystem();
                this.eggTimer = 0;
            }
            if (RadiationConfig.worldRadEffects) {
                proxy.handleWorldDestruction();
            }
            proxy.receiveWorldTick(event);
        }
    }
}

