/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.neutron;

import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.handler.neutron.NeutronNode;
import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.handler.neutron.NeutronStream;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKOutgasser;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRodReaSim;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RBMKNeutronHandler {
    static double moderatorEfficiency;
    static double reflectorEfficiency;
    static double absorberEfficiency;
    static int columnHeight;
    static int fluxRange;

    private static TileEntity blockPosToTE(World worldObj, BlockPos pos) {
        return Compat.getTileStandard(worldObj, pos.getX(), pos.getY(), pos.getZ());
    }

    public static RBMKNeutronNode makeNode(NeutronNodeWorld.StreamWorld streamWorld, TileEntityRBMKBase tile) {
        BlockPos pos = new BlockPos(tile);
        RBMKNeutronNode node = (RBMKNeutronNode)streamWorld.getNode(pos);
        return node != null ? node : new RBMKNeutronNode(tile, tile.getRBMKType(), tile.hasLid());
    }

    public static class RBMKNeutronStream
    extends NeutronStream {
        public RBMKNeutronStream(NeutronNode origin, Vec3 vector) {
            super(origin, vector);
        }

        public RBMKNeutronStream(NeutronNode origin, Vec3 vector, double flux, double ratio) {
            super(origin, vector, flux, ratio, NeutronStream.NeutronType.RBMK);
        }

        public NeutronNode[] getNodes(NeutronNodeWorld.StreamWorld streamWorld, boolean addNode) {
            NeutronNode[] positions = new RBMKNeutronNode[fluxRange];
            BlockPos pos = new BlockPos(this.origin.tile);
            World world = this.origin.tile.func_145831_w();
            for (int i = 1; i <= fluxRange; ++i) {
                TileEntity te;
                int x = (int)Math.floor(0.5 + this.vector.field_72450_a * (double)i);
                int z = (int)Math.floor(0.5 + this.vector.field_72449_c * (double)i);
                pos.mutate(this.origin.tile.field_145851_c + x, this.origin.tile.field_145848_d, this.origin.tile.field_145849_e + z);
                NeutronNode node = streamWorld.getNode(pos);
                if (node instanceof RBMKNeutronNode) {
                    positions[i - 1] = node;
                    continue;
                }
                if (!(this.origin.tile.func_145838_q() instanceof RBMKBase) || !((te = RBMKNeutronHandler.blockPosToTE(world, pos)) instanceof TileEntityRBMKBase)) continue;
                TileEntityRBMKBase rbmkBase = (TileEntityRBMKBase)te;
                positions[i - 1] = node = RBMKNeutronHandler.makeNode(streamWorld, rbmkBase);
                if (!addNode) continue;
                streamWorld.addNode(node);
            }
            return positions;
        }

        @Override
        public void runStreamInteraction(World worldObj, NeutronNodeWorld.StreamWorld streamWorld) {
            TileEntityRBMKControl rod;
            TileEntityRBMKBase originTE;
            if (this.fluxQuantity == 0.0) {
                return;
            }
            BlockPos pos = new BlockPos(this.origin.tile);
            NeutronNode node = streamWorld.getNode(pos);
            if (node != null) {
                originTE = (TileEntityRBMKBase)node.tile;
            } else {
                originTE = (TileEntityRBMKBase)RBMKNeutronHandler.blockPosToTE(worldObj, pos);
                if (originTE == null) {
                    return;
                }
                streamWorld.addNode(new RBMKNeutronNode(originTE, originTE.getRBMKType(), originTE.hasLid()));
            }
            int moderatedCount = 0;
            Iterator<BlockPos> iterator = this.getBlocks(fluxRange);
            while (iterator.hasNext()) {
                RBMKType type;
                BlockPos targetPos = iterator.next();
                if (this.fluxQuantity == 0.0) {
                    return;
                }
                NeutronNode targetNode = streamWorld.getNode(targetPos);
                if (targetNode == null) {
                    TileEntity te = RBMKNeutronHandler.blockPosToTE(worldObj, targetPos);
                    if (te instanceof TileEntityRBMKBase) {
                        targetNode = RBMKNeutronHandler.makeNode(streamWorld, (TileEntityRBMKBase)te);
                        streamWorld.addNode(targetNode);
                    } else {
                        int hits = this.getHits(targetPos);
                        if (hits == columnHeight) {
                            return;
                        }
                        if (hits > 0) {
                            this.irradiateFromFlux(pos, hits);
                            this.fluxQuantity *= 1.0 - (double)hits / (double)columnHeight;
                            continue;
                        }
                        this.irradiateFromFlux(pos, 0);
                        continue;
                    }
                }
                if ((type = (RBMKType)((Object)targetNode.data.get("type"))) == RBMKType.OTHER || type == null) continue;
                TileEntityRBMKBase nodeTE = (TileEntityRBMKBase)targetNode.tile;
                if (!((Boolean)targetNode.data.get("hasLid")).booleanValue()) {
                    ChunkRadiationManager.proxy.incrementRad(worldObj, targetPos.getX(), targetPos.getY(), targetPos.getZ(), (float)(this.fluxQuantity * (double)0.05f));
                }
                if (type == RBMKType.MODERATOR || nodeTE.isModerated()) {
                    ++moderatedCount;
                    this.moderateStream();
                }
                if (nodeTE instanceof IRBMKFluxReceiver) {
                    TileEntityRBMKOutgasser outgasser;
                    IRBMKFluxReceiver column = (IRBMKFluxReceiver)((Object)nodeTE);
                    if (type == RBMKType.ROD) {
                        TileEntityRBMKRod rod2 = (TileEntityRBMKRod)column;
                        if (!rod2.hasRod) continue;
                        rod2.receiveFlux(this);
                        return;
                    }
                    if (type != RBMKType.OUTGASSER || !(outgasser = (TileEntityRBMKOutgasser)column).canProcess()) continue;
                    column.receiveFlux(this);
                    return;
                }
                if (type == RBMKType.CONTROL_ROD) {
                    TileEntityRBMKControl rod3 = (TileEntityRBMKControl)nodeTE;
                    if (rod3.level > 0.0) {
                        this.fluxQuantity *= rod3.getMult();
                        continue;
                    }
                    return;
                }
                if (type == RBMKType.REFLECTOR) {
                    if (((TileEntityRBMKBase)this.origin.tile).isModerated()) {
                        ++moderatedCount;
                    }
                    if (this.fluxRatio > 0.0 && moderatedCount > 0) {
                        for (int i = 0; i < moderatedCount; ++i) {
                            this.moderateStream();
                        }
                    }
                    if (reflectorEfficiency != 1.0) {
                        this.fluxQuantity *= reflectorEfficiency;
                        continue;
                    }
                    ((TileEntityRBMKRod)originTE).receiveFlux(this);
                    return;
                }
                if (type != RBMKType.ABSORBER) continue;
                if (absorberEfficiency == 1.0) {
                    return;
                }
                this.fluxQuantity *= absorberEfficiency;
            }
            NeutronNode[] nodes = this.getNodes(streamWorld, true);
            NeutronNode lastNode = nodes[nodes.length - 1];
            if (lastNode == null) {
                this.irradiateFromFlux(new BlockPos((double)this.origin.tile.field_145851_c + this.vector.field_72450_a, (double)this.origin.tile.field_145848_d, (double)this.origin.tile.field_145849_e + this.vector.field_72449_c));
                return;
            }
            RBMKType lastNodeType = (RBMKType)((Object)lastNode.data.get("type"));
            if (lastNodeType == RBMKType.CONTROL_ROD && (rod = (TileEntityRBMKControl)lastNode.tile).getMult() > 0.0) {
                this.fluxQuantity *= rod.getMult();
                BlockPos posAfter = new BlockPos((double)lastNode.tile.field_145851_c + this.vector.field_72450_a, (double)lastNode.tile.field_145848_d, (double)lastNode.tile.field_145849_e + this.vector.field_72449_c);
                if (NeutronNodeWorld.getNode(worldObj, pos) == null) {
                    TileEntity te = RBMKNeutronHandler.blockPosToTE(worldObj, posAfter);
                    if (te instanceof TileEntityRBMKBase) {
                        RBMKNeutronNode nodeAfter = RBMKNeutronHandler.makeNode(NeutronNodeWorld.getOrAddWorld(worldObj), (TileEntityRBMKBase)te);
                        NeutronNodeWorld.getOrAddWorld(worldObj).addNode(nodeAfter);
                    } else {
                        this.irradiateFromFlux(posAfter);
                    }
                }
            }
        }

        public int getHits(BlockPos pos) {
            int hits = 0;
            for (int h = 0; h < columnHeight; ++h) {
                Block block = this.origin.tile.func_145831_w().func_147439_a(pos.getX(), pos.getY() + h, pos.getZ());
                if (!block.func_149662_c()) continue;
                ++hits;
            }
            return hits;
        }

        public void irradiateFromFlux(BlockPos pos) {
            ChunkRadiationManager.proxy.incrementRad(this.origin.tile.func_145831_w(), pos.getX(), pos.getY(), pos.getZ(), (float)(this.fluxQuantity * (double)0.05f * (1.0 - (double)this.getHits(pos) / (double)columnHeight)));
        }

        public void irradiateFromFlux(BlockPos pos, int hits) {
            ChunkRadiationManager.proxy.incrementRad(this.origin.tile.func_145831_w(), pos.getX(), pos.getY(), pos.getZ(), (float)(this.fluxQuantity * (double)0.05f * (1.0 - (double)hits / (double)columnHeight)));
        }

        public void moderateStream() {
            this.fluxRatio *= 1.0 - moderatorEfficiency;
        }
    }

    public static class RBMKNeutronNode
    extends NeutronNode {
        protected BlockPos posInstance;
        private int x;
        private int z;

        public RBMKNeutronNode(TileEntityRBMKBase tile, RBMKType type, boolean hasLid) {
            super(tile, NeutronStream.NeutronType.RBMK);
            this.data.put("hasLid", hasLid);
            this.data.put("type", type);
            this.posInstance = new BlockPos(tile);
        }

        public void addLid() {
            this.data.replace("hasLid", true);
        }

        public void removeLid() {
            this.data.replace("hasLid", false);
        }

        public Iterator<BlockPos> getReaSimNodes() {
            this.x = -fluxRange;
            this.z = -fluxRange;
            return new Iterator<BlockPos>(){

                @Override
                public boolean hasNext() {
                    return (fluxRange + x) * (fluxRange * 2 + 1) + z + fluxRange + 1 < (fluxRange * 2 + 1) * (fluxRange * 2 + 1);
                }

                @Override
                public BlockPos next() {
                    if (Math.pow(x, 2.0) + Math.pow(z, 2.0) <= (double)(fluxRange * fluxRange)) {
                        z++;
                        if (z > fluxRange) {
                            z = -fluxRange;
                            x++;
                        }
                        return posInstance.mutate(tile.field_145851_c + x, tile.field_145848_d, tile.field_145849_e + z);
                    }
                    z++;
                    if (z > fluxRange) {
                        z = -fluxRange;
                        x++;
                    }
                    return null;
                }
            };
        }

        public List<BlockPos> checkNode(NeutronNodeWorld.StreamWorld streamWorld) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            BlockPos pos = new BlockPos(this.tile);
            RBMKNeutronStream[] streams = new RBMKNeutronStream[TileEntityRBMKRod.fluxDirs.length];
            ForgeDirection[] fluxDirs = TileEntityRBMKRod.fluxDirs;
            for (int i = 0; i < fluxDirs.length; ++i) {
                streams[i] = new RBMKNeutronStream(this, Vec3.func_72443_a((double)fluxDirs[i].offsetX, (double)0.0, (double)fluxDirs[i].offsetZ));
            }
            if (this.tile instanceof TileEntityRBMKRod && !(this.tile instanceof TileEntityRBMKRodReaSim)) {
                TileEntityRBMKRod rod = (TileEntityRBMKRod)this.tile;
                if (!rod.hasRod || rod.lastFluxQuantity == 0.0) {
                    for (RBMKNeutronStream stream : streams) {
                        for (NeutronNode node : stream.getNodes(streamWorld, false)) {
                            if (node == null) continue;
                            list.add(new BlockPos(node.tile));
                        }
                    }
                    return list;
                }
            }
            Iterator<BlockPos> reaSimNodes = this.getReaSimNodes();
            if (this.tile instanceof TileEntityRBMKRodReaSim) {
                TileEntityRBMKRodReaSim rod = (TileEntityRBMKRodReaSim)this.tile;
                if (!rod.hasRod || rod.lastFluxQuantity == 0.0) {
                    reaSimNodes.forEachRemaining(a -> {
                        if (a != null) {
                            list.add(a.clone());
                        }
                    });
                    return list;
                }
            }
            reaSimNodes = this.getReaSimNodes();
            boolean hasRod = false;
            while (reaSimNodes.hasNext()) {
                NeutronNode node;
                BlockPos nodePos = reaSimNodes.next();
                if (nodePos == null || (node = streamWorld.getNode(nodePos)) == null || !(node.tile instanceof TileEntityRBMKRod)) continue;
                TileEntityRBMKRod rod = (TileEntityRBMKRod)node.tile;
                if (!rod.hasRod || !(rod.lastFluxQuantity > 0.0)) continue;
                hasRod = true;
                break;
            }
            if (!hasRod) {
                list.add(pos);
                return list;
            }
            for (RBMKNeutronStream stream : streams) {
                NeutronNode[] nodes;
                for (NeutronNode node : nodes = stream.getNodes(streamWorld, false)) {
                    if (node == null || !(node.tile instanceof TileEntityRBMKRod)) continue;
                    return list;
                }
            }
            list.add(pos);
            return list;
        }
    }

    public static enum RBMKType {
        ROD,
        MODERATOR,
        CONTROL_ROD,
        REFLECTOR,
        ABSORBER,
        OUTGASSER,
        OTHER;

    }
}

