/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ae2;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import com.hbm.tileentity.machine.storage.TileEntityMassStorage;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.common.Optional;
import net.minecraft.item.ItemStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.storage.IMEInventory", modid="appliedenergistics2")})
public class MassStorageMEInventory
implements IMEInventory<IAEItemStack> {
    private TileEntityMassStorage tile;

    public MassStorageMEInventory(TileEntityMassStorage tile) {
        this.tile = tile;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        ItemStack typeStack = this.tile.getType();
        if (typeStack == null || !ItemStackUtil.areStacksCompatible(input.getItemStack(), typeStack)) {
            return input;
        }
        int remaining = this.tile.increaseTotalStockpile((int)input.getStackSize(), type == Actionable.MODULATE);
        if (remaining == 0) {
            return null;
        }
        return (IAEItemStack)AEApi.instance().storage().createItemStack(typeStack).setStackSize((long)remaining);
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        ItemStack typeStack = this.tile.getType();
        if (typeStack == null || !ItemStackUtil.areStacksCompatible(request.getItemStack(), typeStack)) {
            return null;
        }
        int missing = this.tile.decreaseTotalStockpile((int)request.getStackSize(), mode == Actionable.MODULATE);
        long fulfilled = request.getStackSize() - (long)missing;
        if (fulfilled == 0L) {
            return null;
        }
        return (IAEItemStack)AEApi.instance().storage().createItemStack(typeStack).setStackSize(fulfilled);
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        ItemStack typeStack = this.tile.getType();
        if (typeStack != null) {
            out.add(AEApi.instance().storage().createItemStack(typeStack).setStackSize((long)this.tile.getTotalStockpile()));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

