/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.config.ToolConfig;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.items.tool.ItemToolAbility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public interface IToolAreaAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 0;
    public static final IToolAreaAbility NONE = new IToolAreaAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 0;
        }

        @Override
        public boolean onDig(int level, World world, int x, int y, int z, EntityPlayer player, ItemToolAbility tool) {
            return false;
        }
    };
    public static final IToolAreaAbility RECURSION = new IToolAreaAbility(){
        public final int[] radiusAtLevel = new int[]{3, 4, 5, 6, 7, 9, 10};
        private Set<ThreeInts> pos = new HashSet<ThreeInts>();
        private final List<ThreeInts> offsets = new ArrayList<ThreeInts>(26){
            {
                super(x0);
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            if (dx == 0 && dy == 0 && dz == 0) continue;
                            this.add(new ThreeInts(dx, dy, dz));
                        }
                    }
                }
            }
        };

        @Override
        public String getName() {
            return "tool.ability.recursion";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityVein;
        }

        @Override
        public int levels() {
            return this.radiusAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.radiusAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 1;
        }

        @Override
        public boolean onDig(int level, World world, int x, int y, int z, EntityPlayer player, ItemToolAbility tool) {
            Block b = world.func_147439_a(x, y, z);
            if (b == Blocks.field_150348_b && !ToolConfig.recursiveStone) {
                return false;
            }
            if (b == Blocks.field_150424_aL && !ToolConfig.recursiveNetherrack) {
                return false;
            }
            this.pos.clear();
            this.recurse(world, x, y, z, x, y, z, player, tool, 0, this.radiusAtLevel[level]);
            return false;
        }

        private void recurse(World world, int x, int y, int z, int refX, int refY, int refZ, EntityPlayer player, ItemToolAbility tool, int depth, int radius) {
            ArrayList<ThreeInts> shuffledOffsets = new ArrayList<ThreeInts>(this.offsets);
            Collections.shuffle(shuffledOffsets);
            for (ThreeInts offset : shuffledOffsets) {
                this.breakExtra(world, x + offset.x, y + offset.y, z + offset.z, refX, refY, refZ, player, tool, depth, radius);
            }
        }

        private void breakExtra(World world, int x, int y, int z, int refX, int refY, int refZ, EntityPlayer player, ItemToolAbility tool, int depth, int radius) {
            if (this.pos.contains(new ThreeInts(x, y, z))) {
                return;
            }
            if (++depth > ToolConfig.recursionDepth) {
                return;
            }
            this.pos.add(new ThreeInts(x, y, z));
            if (x == refX && y == refY && z == refZ) {
                return;
            }
            if (Vec3.func_72443_a((double)(x - refX), (double)(y - refY), (double)(z - refZ)).func_72433_c() > (double)radius) {
                return;
            }
            Block b = world.func_147439_a(x, y, z);
            Block ref = world.func_147439_a(refX, refY, refZ);
            int meta = world.func_72805_g(x, y, z);
            int refMeta = world.func_72805_g(refX, refY, refZ);
            if (!this.isSameBlock(b, ref)) {
                return;
            }
            if (meta != refMeta) {
                return;
            }
            if (player.func_70694_bm() == null) {
                return;
            }
            tool.breakExtraBlock(world, x, y, z, player, refX, refY, refZ);
            this.recurse(world, x, y, z, refX, refY, refZ, player, tool, depth, radius);
        }

        private boolean isSameBlock(Block b1, Block b2) {
            if (b1 == b2) {
                return true;
            }
            return b1 == Blocks.field_150450_ax && b2 == Blocks.field_150439_ay || b1 == Blocks.field_150439_ay && b2 == Blocks.field_150450_ax;
        }
    };
    public static final IToolAreaAbility HAMMER = new IToolAreaAbility(){
        public final int[] rangeAtLevel = new int[]{1, 2, 3, 4};

        @Override
        public String getName() {
            return "tool.ability.hammer";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityHammer;
        }

        @Override
        public int levels() {
            return this.rangeAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.rangeAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 2;
        }

        @Override
        public boolean onDig(int level, World world, int x, int y, int z, EntityPlayer player, ItemToolAbility tool) {
            int range = this.rangeAtLevel[level];
            for (int a = x - range; a <= x + range; ++a) {
                for (int b = y - range; b <= y + range; ++b) {
                    for (int c = z - range; c <= z + range; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(world, a, b, c, player, x, y, z);
                    }
                }
            }
            return false;
        }
    };
    public static final IToolAreaAbility HAMMER_FLAT = new IToolAreaAbility(){
        public final int[] rangeAtLevel = new int[]{1, 2, 3, 4};

        @Override
        public String getName() {
            return "tool.ability.hammer_flat";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityHammer;
        }

        @Override
        public int levels() {
            return this.rangeAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.rangeAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 3;
        }

        @Override
        public boolean onDig(int level, World world, int x, int y, int z, EntityPlayer player, ItemToolAbility tool) {
            int range = this.rangeAtLevel[level];
            MovingObjectPosition hit = this.raytraceFromEntity(world, player, false, 4.5);
            if (hit == null) {
                return true;
            }
            int sideHit = hit.field_72310_e;
            int xRange = range;
            int yRange = range;
            int zRange = 0;
            switch (sideHit) {
                case 0: 
                case 1: {
                    yRange = 0;
                    zRange = range;
                    break;
                }
                case 2: 
                case 3: {
                    xRange = range;
                    zRange = 0;
                    break;
                }
                case 4: 
                case 5: {
                    xRange = 0;
                    zRange = range;
                }
            }
            for (int a = x - xRange; a <= x + xRange; ++a) {
                for (int b = y - yRange; b <= y + yRange; ++b) {
                    for (int c = z - zRange; c <= z + zRange; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(world, a, b, c, player, x, y, z);
                    }
                }
            }
            return false;
        }

        private MovingObjectPosition raytraceFromEntity(World world, EntityPlayer player, boolean par3, double range) {
            float f = 1.0f;
            float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
            float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
            double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
            double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62;
            double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
            Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = range;
            if (player instanceof EntityPlayerMP) {
                d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
            }
            Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            return world.func_147447_a(vec3, vec31, par3, !par3, par3);
        }
    };
    public static final IToolAreaAbility EXPLOSION = new IToolAreaAbility(){
        public final float[] strengthAtLevel = new float[]{2.5f, 5.0f, 10.0f, 15.0f};

        @Override
        public String getName() {
            return "tool.ability.explosion";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityExplosion;
        }

        @Override
        public int levels() {
            return this.strengthAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.strengthAtLevel[level] + ")";
        }

        @Override
        public boolean allowsHarvest(int level) {
            return false;
        }

        @Override
        public int sortOrder() {
            return 4;
        }

        @Override
        public boolean onDig(int level, World world, int x, int y, int z, EntityPlayer player, ItemToolAbility tool) {
            float strength = this.strengthAtLevel[level];
            ExplosionNT ex = new ExplosionNT(player.field_70170_p, (Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, strength);
            ex.addAttrib(ExplosionNT.ExAttrib.ALLDROP);
            ex.addAttrib(ExplosionNT.ExAttrib.NOHURT);
            ex.addAttrib(ExplosionNT.ExAttrib.NOPARTICLE);
            ex.func_77278_a();
            ex.func_77279_a(false);
            player.field_70170_p.func_72876_a((Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.1f, false);
            return true;
        }
    };
    public static final IToolAreaAbility[] abilities = new IToolAreaAbility[]{NONE, RECURSION, HAMMER, HAMMER_FLAT, EXPLOSION};

    public boolean onDig(int var1, World var2, int var3, int var4, int var5, EntityPlayer var6, ItemToolAbility var7);

    default public boolean allowsHarvest(int level) {
        return true;
    }

    public static IToolAreaAbility getByName(String name) {
        for (IToolAreaAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

