/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.extprop;

import com.hbm.config.RadiationConfig;
import com.hbm.entity.mob.EntityDuck;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.packet.toclient.PlayerInformPacket;
import com.hbm.util.ChatBuilder;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class HbmLivingProps
implements IExtendedEntityProperties {
    public static final String key = "NTM_EXT_LIVING";
    public static final UUID digamma_UUID = UUID.fromString("2a3d8aec-5ab9-4218-9b8b-ca812bdf378b");
    public EntityLivingBase entity;
    private float radiation;
    private float digamma;
    private int asbestos;
    public static final int maxAsbestos = 72000;
    private int blacklung;
    public static final int maxBlacklung = 144000;
    private float radEnv;
    private float radBuf;
    private int bombTimer;
    private int contagion;
    private int oil;
    public int fire;
    public int phosphorus;
    public int balefire;
    public int blackFire;
    private List<ContaminationEffect> contamination = new ArrayList<ContaminationEffect>();

    public HbmLivingProps(EntityLivingBase entity) {
        this.entity = entity;
    }

    public static HbmLivingProps registerData(EntityLivingBase entity) {
        entity.registerExtendedProperties(key, (IExtendedEntityProperties)new HbmLivingProps(entity));
        return (HbmLivingProps)entity.getExtendedProperties(key);
    }

    public static HbmLivingProps getData(EntityLivingBase entity) {
        HbmLivingProps props = (HbmLivingProps)entity.getExtendedProperties(key);
        return props != null ? props : HbmLivingProps.registerData(entity);
    }

    public static float getRadiation(EntityLivingBase entity) {
        if (!RadiationConfig.enableContamination) {
            return 0.0f;
        }
        return HbmLivingProps.getData((EntityLivingBase)entity).radiation;
    }

    public static void setRadiation(EntityLivingBase entity, float rad) {
        if (RadiationConfig.enableContamination) {
            HbmLivingProps.getData((EntityLivingBase)entity).radiation = rad;
        }
    }

    public static void incrementRadiation(EntityLivingBase entity, float rad) {
        if (!RadiationConfig.enableContamination) {
            return;
        }
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float radiation = HbmLivingProps.getData((EntityLivingBase)entity).radiation + rad;
        if (radiation > 2500.0f) {
            radiation = 2500.0f;
        }
        if (radiation < 0.0f) {
            radiation = 0.0f;
        }
        HbmLivingProps.setRadiation(entity, radiation);
    }

    public static float getRadEnv(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).radEnv;
    }

    public static void setRadEnv(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData((EntityLivingBase)entity).radEnv = rad;
    }

    public static float getRadBuf(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).radBuf;
    }

    public static void setRadBuf(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData((EntityLivingBase)entity).radBuf = rad;
    }

    public static List<ContaminationEffect> getCont(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).contamination;
    }

    public static void addCont(EntityLivingBase entity, ContaminationEffect cont) {
        HbmLivingProps.getData((EntityLivingBase)entity).contamination.add(cont);
    }

    public static float getDigamma(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).digamma;
    }

    public static void setDigamma(EntityLivingBase entity, float digamma) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityDuck) {
            digamma = 0.0f;
        }
        HbmLivingProps.getData((EntityLivingBase)entity).digamma = digamma;
        float healthMod = (float)Math.pow(0.5, digamma) - 1.0f;
        IAttributeInstance attributeinstance = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        try {
            attributeinstance.func_111124_b(attributeinstance.func_111127_a(digamma_UUID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        attributeinstance.func_111121_a(new AttributeModifier(digamma_UUID, "digamma", (double)healthMod, 2));
        if (entity.func_110143_aJ() > entity.func_110138_aP() && entity.func_110138_aP() > 0.0f) {
            entity.func_70606_j(entity.func_110138_aP());
        }
        if ((entity.func_110138_aP() <= 0.0f || digamma >= 10.0f) && entity.func_70089_S()) {
            entity.func_110149_m(0.0f);
            entity.func_70097_a(ModDamageSource.digamma, 500.0f);
            entity.func_70606_j(0.0f);
            entity.func_70645_a(ModDamageSource.digamma);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "sweat");
            data.func_74768_a("count", 50);
            data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
            data.func_74768_a("entity", entity.func_145782_y());
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
        }
        if (entity instanceof EntityPlayer) {
            float di = HbmLivingProps.getData((EntityLivingBase)entity).digamma;
            if (di > 0.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaSee);
            }
            if (di >= 2.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaFeel);
            }
            if (di >= 10.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaKnow);
            }
        }
    }

    public static void incrementDigamma(EntityLivingBase entity, float digamma) {
        if (entity instanceof EntityDuck) {
            digamma = 0.0f;
        }
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float dRad = HbmLivingProps.getDigamma(entity) + digamma;
        if (dRad > 10.0f) {
            dRad = 10.0f;
        }
        if (dRad < 0.0f) {
            dRad = 0.0f;
        }
        HbmLivingProps.setDigamma(entity, dRad);
    }

    public static int getAsbestos(EntityLivingBase entity) {
        if (RadiationConfig.disableAsbestos) {
            return 0;
        }
        return HbmLivingProps.getData((EntityLivingBase)entity).asbestos;
    }

    public static void setAsbestos(EntityLivingBase entity, int asbestos) {
        if (RadiationConfig.disableAsbestos) {
            return;
        }
        HbmLivingProps.getData((EntityLivingBase)entity).asbestos = asbestos;
        if (asbestos >= 72000) {
            HbmLivingProps.getData((EntityLivingBase)entity).asbestos = 0;
            entity.func_70097_a(ModDamageSource.asbestos, 1000.0f);
        }
    }

    public static void incrementAsbestos(EntityLivingBase entity, int asbestos) {
        if (RadiationConfig.disableAsbestos) {
            return;
        }
        HbmLivingProps.setAsbestos(entity, HbmLivingProps.getAsbestos(entity) + asbestos);
        if (entity instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo(new PlayerInformPacket((IChatComponent)ChatBuilder.start("").nextTranslation("info.asbestos", new Object[0]).color(EnumChatFormatting.RED).flush(), 12, 3000), (EntityPlayerMP)entity);
        }
    }

    public static int getBlackLung(EntityLivingBase entity) {
        if (RadiationConfig.disableCoal) {
            return 0;
        }
        return HbmLivingProps.getData((EntityLivingBase)entity).blacklung;
    }

    public static void setBlackLung(EntityLivingBase entity, int blacklung) {
        if (RadiationConfig.disableCoal) {
            return;
        }
        HbmLivingProps.getData((EntityLivingBase)entity).blacklung = blacklung;
        if (blacklung >= 144000) {
            HbmLivingProps.getData((EntityLivingBase)entity).blacklung = 0;
            entity.func_70097_a(ModDamageSource.blacklung, 1000.0f);
        }
    }

    public static void incrementBlackLung(EntityLivingBase entity, int blacklung) {
        if (RadiationConfig.disableCoal) {
            return;
        }
        HbmLivingProps.setBlackLung(entity, HbmLivingProps.getBlackLung(entity) + blacklung);
        if (entity instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo(new PlayerInformPacket((IChatComponent)ChatBuilder.start("").nextTranslation("info.coaldust", new Object[0]).color(EnumChatFormatting.RED).flush(), 12, 3000), (EntityPlayerMP)entity);
        }
    }

    public static int getTimer(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).bombTimer;
    }

    public static void setTimer(EntityLivingBase entity, int bombTimer) {
        HbmLivingProps.getData((EntityLivingBase)entity).bombTimer = bombTimer;
    }

    public static int getContagion(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).contagion;
    }

    public static void setContagion(EntityLivingBase entity, int contageon) {
        HbmLivingProps.getData((EntityLivingBase)entity).contagion = contageon;
    }

    public static int getOil(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).oil;
    }

    public static void setOil(EntityLivingBase entity, int oil) {
        HbmLivingProps.getData((EntityLivingBase)entity).oil = oil;
    }

    public void init(Entity entity, World world) {
    }

    public void serialize(ByteBuf buf) {
        buf.writeFloat(this.radiation);
        buf.writeFloat(this.digamma);
        buf.writeInt(this.asbestos);
        buf.writeInt(this.bombTimer);
        buf.writeInt(this.contagion);
        buf.writeInt(this.blacklung);
        buf.writeInt(this.oil);
        buf.writeInt(this.contamination.size());
        for (ContaminationEffect contaminationEffect : this.contamination) {
            contaminationEffect.serialize(buf);
        }
    }

    public void deserialize(ByteBuf buf) {
        if (buf.readableBytes() > 0) {
            this.radiation = buf.readFloat();
            this.digamma = buf.readFloat();
            this.asbestos = buf.readInt();
            this.bombTimer = buf.readInt();
            this.contagion = buf.readInt();
            this.blacklung = buf.readInt();
            this.oil = buf.readInt();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.contamination.add(ContaminationEffect.deserialize(buf));
            }
        }
    }

    @Deprecated
    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound props = new NBTTagCompound();
        props.func_74776_a("hfr_radiation", this.radiation);
        props.func_74776_a("hfr_digamma", this.digamma);
        props.func_74768_a("hfr_asbestos", this.asbestos);
        props.func_74768_a("hfr_bomb", this.bombTimer);
        props.func_74768_a("hfr_contagion", this.contagion);
        props.func_74768_a("hfr_blacklung", this.blacklung);
        props.func_74768_a("hfr_oil", this.oil);
        props.func_74768_a("hfr_fire", this.fire);
        props.func_74768_a("hfr_phosphorus", this.phosphorus);
        props.func_74768_a("hfr_balefire", this.balefire);
        props.func_74768_a("hfr_blackfire", this.blackFire);
        props.func_74768_a("hfr_cont_count", this.contamination.size());
        for (int i = 0; i < this.contamination.size(); ++i) {
            this.contamination.get(i).save(props, i);
        }
        nbt.func_74782_a("HbmLivingProps", (NBTBase)props);
    }

    @Deprecated
    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound props = (NBTTagCompound)nbt.func_74781_a("HbmLivingProps");
        if (props != null) {
            this.radiation = props.func_74760_g("hfr_radiation");
            this.digamma = props.func_74760_g("hfr_digamma");
            this.asbestos = props.func_74762_e("hfr_asbestos");
            this.bombTimer = props.func_74762_e("hfr_bomb");
            this.contagion = props.func_74762_e("hfr_contagion");
            this.blacklung = props.func_74762_e("hfr_blacklung");
            this.oil = props.func_74762_e("hfr_oil");
            this.fire = props.func_74762_e("hfr_fire");
            this.phosphorus = props.func_74762_e("hfr_phosphorus");
            this.balefire = props.func_74762_e("hfr_balefire");
            this.blackFire = props.func_74762_e("hfr_blackfire");
            int cont = props.func_74762_e("hfr_cont_count");
            for (int i = 0; i < cont; ++i) {
                this.contamination.add(ContaminationEffect.load(props, i));
            }
        }
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public void serialize(ByteBuf buf) {
            buf.writeFloat(this.maxRad);
            buf.writeInt(this.maxTime);
            buf.writeInt(this.time);
            buf.writeBoolean(this.ignoreArmor);
        }

        public static ContaminationEffect deserialize(ByteBuf buf) {
            float maxRad = buf.readFloat();
            int maxTime = buf.readInt();
            int time = buf.readInt();
            boolean ignoreArmor = buf.readBoolean();
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }

        public void save(NBTTagCompound nbt, int index) {
            NBTTagCompound me = new NBTTagCompound();
            me.func_74776_a("maxRad", this.maxRad);
            me.func_74768_a("maxTime", this.maxTime);
            me.func_74768_a("time", this.time);
            me.func_74757_a("ignoreArmor", this.ignoreArmor);
            nbt.func_74782_a("cont_" + index, (NBTBase)me);
        }

        public static ContaminationEffect load(NBTTagCompound nbt, int index) {
            NBTTagCompound me = (NBTTagCompound)nbt.func_74781_a("cont_" + index);
            float maxRad = me.func_74760_g("maxRad");
            int maxTime = nbt.func_74762_e("maxTime");
            int time = nbt.func_74762_e("time");
            boolean ignoreArmor = nbt.func_74767_n("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

