/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.glyphid;

import api.hbm.entity.IResistanceProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MobConfig;
import com.hbm.entity.logic.EntityWaypoint;
import com.hbm.entity.mob.EntityParasiteMaggot;
import com.hbm.entity.mob.glyphid.EntityGlyphidScout;
import com.hbm.entity.mob.glyphid.GlyphidStats;
import com.hbm.entity.pathfinder.PathFinderUtils;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorGlyphidDig;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.ResourceManager;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.util.DamageResistanceHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGlyphid
extends EntityMob
implements IResistanceProvider {
    public boolean hasHome = false;
    public int homeX;
    public int homeY;
    public int homeZ;
    protected int currentTask = 0;
    protected int previousTask;
    protected EntityWaypoint previousWaypoint;
    public int taskX;
    public int taskY;
    public int taskZ;
    public int blastSize = Math.min((int)(3.0 * this.getScale()) / 2, 5);
    public int blastResToDig = Math.min((int)(50.0 * (this.getScale() * 2.0)), 150);
    public boolean shouldDig;
    public static final int TASK_IDLE = 0;
    public static final int TASK_RETREAT_FOR_REINFORCEMENTS = 1;
    public static final int TASK_BUILD_HIVE = 2;
    public static final int TASK_INITIATE_RETREAT = 3;
    public static final int TASK_FOLLOW = 4;
    public static final int TASK_TERRAFORM = 5;
    public static final int TASK_DIG = 6;
    protected boolean hasWaypoint = false;
    protected EntityWaypoint taskWaypoint = null;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_INFECTED = 1;
    public static final int TYPE_RADIOACTIVE = 2;
    public static final int DW_WALL = 16;
    public static final int DW_ARMOR = 17;
    public static final int DW_SUBTYPE = 18;

    public EntityGlyphid(World world) {
        super(world);
        this.func_70105_a(1.75f, 1.0f);
    }

    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_tex;
    }

    public double getScale() {
        return 1.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Byte(31));
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        byte variant = this.field_70180_af.func_75683_a(18);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(GlyphidStats.getStats().getGrunt().health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(GlyphidStats.getStats().getGrunt().speed * (variant == 2 ? 2.0 : 1.0));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(GlyphidStats.getStats().getGrunt().damage * (variant == 2 ? 5.0 : 1.0));
    }

    public GlyphidStats.StatBundle getStats() {
        return GlyphidStats.getStats().statsGrunt;
    }

    @Override
    public float[] getCurrentDTDR(DamageSource damage, float amount, float pierceDT, float pierce) {
        if (damage.func_151517_h() || damage.func_76363_c()) {
            return new float[]{0.0f, 0.0f};
        }
        GlyphidStats.StatBundle stats = this.getStats();
        float threshold = stats.thresholdMultForArmor * (float)this.getGlyphidArmor() / 5.0f;
        if (damage == ModDamageSource.nuclearBlast) {
            return new float[]{threshold * 0.25f, 0.0f};
        }
        if (damage.field_76373_n.equals(DamageResistanceHandler.DamageClass.LASER.name().toLowerCase(Locale.US))) {
            return new float[]{threshold * 0.5f, stats.resistanceMult * 0.5f};
        }
        if (damage.field_76373_n.equals(DamageResistanceHandler.DamageClass.ELECTRIC.name().toLowerCase(Locale.US))) {
            return new float[]{threshold * 0.25f, stats.resistanceMult * 0.25f};
        }
        if (damage.field_76373_n.equals(DamageResistanceHandler.DamageClass.SUBATOMIC.name().toLowerCase(Locale.US))) {
            return new float[]{0.0f, stats.resistanceMult * 0.1f};
        }
        if (damage.func_76347_k()) {
            return new float[]{0.0f, stats.resistanceMult * 0.2f};
        }
        if (damage.func_94541_c()) {
            return new float[]{threshold * 0.5f, stats.resistanceMult * 0.35f};
        }
        return new float[]{threshold, stats.resistanceMult};
    }

    @Override
    public void onDamageDealt(DamageSource damage, float amount) {
        if (this.isArmorBroken(amount)) {
            this.breakOffArmor();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.hasHome) {
                this.homeX = (int)this.field_70165_t;
                this.homeY = (int)this.field_70163_u;
                this.homeZ = (int)this.field_70161_v;
                this.hasHome = true;
            }
            if (this.func_70644_a(Potion.field_76440_q)) {
                this.onBlinded();
            }
            if (this.getCurrentTask() == 4) {
                if (this.isAtDestination() && !this.hasWaypoint) {
                    this.setCurrentTask(0, null);
                }
            } else if (this.getCurrentTask() == 6 && this.field_70173_aa % 20 == 0 && this.isAtDestination()) {
                this.func_71038_i();
                ExplosionVNT vnt = new ExplosionVNT(this.field_70170_p, this.taskX, this.taskY + 2, this.taskZ, this.blastSize, (Entity)this);
                vnt.setBlockAllocator(new BlockAllocatorGlyphidDig(this.blastResToDig));
                vnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop());
                vnt.setEntityProcessor(null);
                vnt.setPlayerProcessor(null);
                vnt.explode();
                this.setCurrentTask(this.previousTask, this.previousWaypoint);
            }
            this.setBesideClimbableBlock(this.field_70123_F);
            if (this.field_70173_aa % 100 == 0) {
                this.func_71038_i();
            }
        }
    }

    protected void func_70628_a(boolean byPlayer, int looting) {
        Item drop;
        super.func_70628_a(byPlayer, looting);
        Item item = drop = this.func_70027_ad() ? ModItems.glyphid_meat_grilled : ModItems.glyphid_meat;
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_70099_a(new ItemStack(drop, (int)this.getScale() * 2 + looting), 0.0f);
        }
    }

    protected Entity func_70782_k() {
        if (this.func_70644_a(Potion.field_76440_q)) {
            return null;
        }
        return this.field_70170_p.func_72856_b((Entity)this, this.useExtendedTargeting() ? 128.0 : 16.0);
    }

    protected void func_70779_j() {
        if (this.getCurrentTask() == 0) {
            super.func_70779_j();
        }
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (!this.func_70644_a(Potion.field_76440_q) && !this.func_70781_l()) {
            if (this.useExtendedTargeting() && this.field_70789_a != null) {
                this.func_70778_a(PathFinderUtils.getPathEntityToEntityPartial(this.field_70170_p, (Entity)this, this.field_70789_a, 16.0f, true, false, true, true));
            } else if (this.getCurrentTask() != 0) {
                this.field_70170_p.field_72984_F.func_76320_a("stroll");
                if (!this.isAtDestination()) {
                    if (this.taskWaypoint != null) {
                        this.taskX = (int)this.taskWaypoint.field_70165_t;
                        this.taskY = (int)this.taskWaypoint.field_70163_u;
                        this.taskZ = (int)this.taskWaypoint.field_70161_v;
                        if (this.taskWaypoint.highPriority) {
                            this.func_70784_b(this.taskWaypoint);
                        }
                    }
                    if (this.hasWaypoint) {
                        if (this.canDig()) {
                            MovingObjectPosition obstacle = this.findWaypointObstruction();
                            if (this.getScale() >= 1.0 && this.getCurrentTask() != 6 && obstacle != null) {
                                this.digToWaypoint(obstacle);
                            } else {
                                Vec3 vec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                                int maxDist = (int)(Math.sqrt(vec.func_72445_d((double)this.taskX, (double)this.taskY, (double)this.taskZ)) * 1.2);
                                this.func_70778_a(PathFinderUtils.getPathEntityToCoordPartial(this.field_70170_p, (Entity)this, this.taskX, this.taskY, this.taskZ, maxDist, true, false, true, true));
                            }
                        } else {
                            Vec3 vec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                            int maxDist = (int)(Math.sqrt(vec.func_72445_d((double)this.taskX, (double)this.taskY, (double)this.taskZ)) * 1.2);
                            this.func_70778_a(PathFinderUtils.getPathEntityToCoordPartial(this.field_70170_p, (Entity)this, this.taskX, this.taskY, this.taskZ, maxDist, true, false, true, true));
                        }
                    }
                }
                this.field_70170_p.field_72984_F.func_76319_b();
            }
        }
    }

    protected boolean canDig() {
        return MobConfig.rampantDig;
    }

    public void onBlinded() {
        this.field_70789_a = null;
        this.func_70778_a(null);
        this.field_70788_c = 80;
        if (this.getScale() >= 1.25 && this.field_70173_aa % 20 == 0) {
            for (int i = 0; i < 16; ++i) {
                Block block;
                float angle = (float)Math.toRadians(22.5 * (double)i);
                Vec3 rot = Vec3.func_72443_a((double)0.0, (double)0.0, (double)4.0);
                rot.func_72442_b(angle);
                Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 1.0), (double)this.field_70161_v);
                Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + rot.field_72450_a), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + rot.field_72449_c));
                MovingObjectPosition mop = this.field_70170_p.func_72933_a(pos, nextPos);
                if (mop == null) continue;
                MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
                if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || (block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) != ModBlocks.lantern) continue;
                this.field_70177_z = 22.5f * (float)i;
                this.func_71038_i();
                this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
            }
        }
    }

    public boolean useExtendedTargeting() {
        return MobConfig.rampantExtendedTargetting || (double)PollutionHandler.getPollution(this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), PollutionHandler.PollutionType.SOOT) >= MobConfig.targetingThreshold;
    }

    protected boolean func_70692_ba() {
        return this.field_70789_a == null && this.getCurrentTask() == 0 && this.field_70173_aa > 100;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K && this.doesInfectedSpawnMaggots() && this.field_70180_af.func_75683_a(18) == 1) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * 0.5f;
                float f1 = ((float)(k / 2) - 0.5f) * 0.5f;
                EntityParasiteMaggot maggot = new EntityParasiteMaggot(this.field_70170_p);
                maggot.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                maggot.field_70159_w = f;
                maggot.field_70179_y = f1;
                maggot.field_70133_I = true;
                this.field_70170_p.func_72838_d((Entity)maggot);
            }
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.zombie.woodbreak", 2.0f, 0.95f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f);
            NBTTagCompound vdat = new NBTTagCompound();
            vdat.func_74778_a("type", "giblets");
            vdat.func_74768_a("ent", this.func_145782_y());
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(vdat, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, 150.0));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityGlyphid) {
            return false;
        }
        boolean wasAttacked = GlyphidStats.getStats().handleAttack(this, source, amount);
        return wasAttacked;
    }

    public boolean attackSuperclass(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public boolean doesInfectedSpawnMaggots() {
        return true;
    }

    public boolean isArmorBroken(float amount) {
        return (double)this.field_70146_Z.nextInt(100) <= Math.min(Math.pow((double)amount * 0.6, 2.0), 100.0);
    }

    public void breakOffArmor() {
        byte armor = this.field_70180_af.func_75683_a(17);
        List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4);
        Collections.shuffle(indices);
        for (Integer i : indices) {
            byte bit = (byte)(1 << i);
            if ((armor & bit) <= 0) continue;
            armor = (byte)(armor & ~bit);
            armor = (byte)(armor & 0x1F);
            this.field_70180_af.func_75692_b(17, (Object)armor);
            this.field_70170_p.func_72956_a((Entity)this, "mob.zombie.woodbreak", 1.0f, 1.25f);
            break;
        }
    }

    public int getGlyphidArmor() {
        int total = 0;
        byte armor = this.field_70180_af.func_75683_a(17);
        List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4);
        for (Integer i : indices) {
            total += (armor & 1 << i) != 0 ? 1 : 0;
        }
        return total;
    }

    protected void func_82168_bl() {
        int i = this.swingDuration();
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    public int swingDuration() {
        return 15;
    }

    public void func_70110_aj() {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbable) {
        byte watchable = this.field_70180_af.func_75683_a(16);
        watchable = climbable ? (byte)(watchable | 1) : (byte)(watchable & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)watchable);
    }

    public boolean func_70652_k(Entity victim) {
        if (this.field_82175_bq) {
            return false;
        }
        this.func_71038_i();
        if (this.field_70180_af.func_75683_a(18) == 1 && victim instanceof EntityLivingBase) {
            ((EntityLivingBase)victim).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 2));
            ((EntityLivingBase)victim).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
        }
        return super.func_70652_k(victim);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public EntityWaypoint getWaypoint() {
        return this.taskWaypoint;
    }

    public void setCurrentTask(int task, @Nullable EntityWaypoint waypoint) {
        this.currentTask = task;
        this.taskWaypoint = waypoint;
        boolean bl = this.hasWaypoint = waypoint != null;
        if (this.taskWaypoint != null) {
            this.taskX = (int)this.taskWaypoint.field_70165_t;
            this.taskY = (int)this.taskWaypoint.field_70163_u;
            this.taskZ = (int)this.taskWaypoint.field_70161_v;
            if (this.taskWaypoint.highPriority) {
                this.field_70789_a = null;
                this.func_70778_a(null);
            }
        }
        this.carryOutTask();
    }

    public void carryOutTask() {
        int task = this.getCurrentTask();
        switch (task) {
            case 1: {
                if (this.taskWaypoint == null) break;
                this.communicate(4, this.taskWaypoint);
                this.setCurrentTask(4, this.taskWaypoint);
                break;
            }
            case 3: {
                if (this.field_70170_p.field_72995_K || this.taskWaypoint != null) break;
                EntityWaypoint additional = new EntityWaypoint(this.field_70170_p);
                additional.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                EntityWaypoint home = new EntityWaypoint(this.field_70170_p);
                home.setWaypointType(1);
                home.setAdditionalWaypoint(additional);
                home.setHighPriority();
                home.func_70012_b(this.homeX, this.homeY, this.homeZ, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)home);
                this.taskWaypoint = home;
                this.communicate(4, home);
                this.setCurrentTask(4, this.taskWaypoint);
                break;
            }
            case 6: {
                this.shouldDig = true;
                break;
            }
        }
    }

    public void communicate(int task, @Nullable EntityWaypoint waypoint) {
        int radius = waypoint != null ? waypoint.radius : 4;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b((double)radius, (double)radius, (double)radius);
        List bugs = this.field_70170_p.func_72839_b((Entity)this, bb);
        for (Entity e : bugs) {
            if (!(e instanceof EntityGlyphid) || e instanceof EntityGlyphidScout || ((EntityGlyphid)e).getCurrentTask() == task) continue;
            ((EntityGlyphid)e).setCurrentTask(task, waypoint);
        }
    }

    public boolean expandHive() {
        return false;
    }

    public boolean isAtDestination() {
        int destinationRadius = this.taskWaypoint != null ? (int)Math.pow(this.taskWaypoint.radius, 2.0) : 25;
        return this.func_70092_e(this.taskX, this.taskY, this.taskZ) <= (double)destinationRadius;
    }

    public MovingObjectPosition findWaypointObstruction() {
        Block blockHit;
        Vec3 waypointVec;
        Vec3 bugVec = Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + (double)this.func_70047_e()), (double)this.field_70161_v);
        MovingObjectPosition obstruction = this.field_70170_p.func_147447_a(bugVec, waypointVec = Vec3.func_72443_a((double)this.taskX, (double)this.taskY, (double)this.taskZ), false, true, false);
        if (obstruction != null && (blockHit = this.field_70170_p.func_147439_a(obstruction.field_72311_b, obstruction.field_72312_c, obstruction.field_72309_d)).func_149638_a(null) <= (float)this.blastResToDig) {
            return obstruction;
        }
        return null;
    }

    public void digToWaypoint(MovingObjectPosition obstacle) {
        EntityWaypoint target = new EntityWaypoint(this.field_70170_p);
        target.func_70012_b(obstacle.field_72311_b, obstacle.field_72312_c, obstacle.field_72309_d, 0.0f, 0.0f);
        target.radius = 5;
        this.field_70170_p.func_72838_d((Entity)target);
        this.previousTask = this.getCurrentTask();
        this.previousWaypoint = this.getWaypoint();
        this.setCurrentTask(6, target);
        Vec3 vec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        int maxDist = (int)(Math.sqrt(vec.func_72445_d((double)this.taskX, (double)this.taskY, (double)this.taskZ)) * 1.2);
        this.func_70778_a(PathFinderUtils.getPathEntityToCoordPartial(this.field_70170_p, (Entity)this, this.taskX, this.taskY, this.taskZ, maxDist, true, false, true, true));
        this.communicate(6, target);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("armor", this.field_70180_af.func_75683_a(17));
        nbt.func_74774_a("subtype", this.field_70180_af.func_75683_a(18));
        nbt.func_74757_a("hasHome", this.hasHome);
        nbt.func_74768_a("homeX", this.homeX);
        nbt.func_74768_a("homeY", this.homeY);
        nbt.func_74768_a("homeZ", this.homeZ);
        nbt.func_74757_a("hasWaypoint", this.hasWaypoint);
        nbt.func_74768_a("taskX", this.taskX);
        nbt.func_74768_a("taskY", this.taskY);
        nbt.func_74768_a("taskZ", this.taskZ);
        nbt.func_74768_a("task", this.currentTask);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(17, (Object)nbt.func_74771_c("armor"));
        this.field_70180_af.func_75692_b(18, (Object)nbt.func_74771_c("subtype"));
        this.hasHome = nbt.func_74767_n("hasHome");
        this.homeX = nbt.func_74762_e("homeX");
        this.homeY = nbt.func_74762_e("homeY");
        this.homeZ = nbt.func_74762_e("homeZ");
        this.hasWaypoint = nbt.func_74767_n("hasWaypoint");
        this.taskX = nbt.func_74762_e("taskX");
        this.taskY = nbt.func_74762_e("taskY");
        this.taskZ = nbt.func_74762_e("taskZ");
        this.currentTask = nbt.func_74762_e("task");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }
}

