/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.config.RunningConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public abstract class CommandReloadConfig
extends CommandBase {
    public boolean func_71519_b(ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public abstract void help(ICommandSender var1, String[] var2);

    public abstract HashMap<String, RunningConfig.ConfigWrapper> getConfigMap();

    public abstract void refresh();

    public abstract void reload();

    public abstract String getTitle();

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String operator = args[0];
        if ("help".equals(operator)) {
            this.help(sender, args);
            return;
        }
        if ("list".equals(operator)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + this.getTitle()));
            for (Map.Entry<String, RunningConfig.ConfigWrapper> line : this.getConfigMap().entrySet()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("  " + EnumChatFormatting.GOLD + line.getKey() + ": " + EnumChatFormatting.YELLOW + line.getValue().value));
            }
            return;
        }
        if ("reload".equals(operator)) {
            this.reload();
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Variables loaded from config file."));
            return;
        }
        if (args.length < 2) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String key = args[1];
        if ("get".equals(operator)) {
            RunningConfig.ConfigWrapper wrapper = this.getConfigMap().get(key);
            if (wrapper == null) {
                throw new CommandException("Key does not exist.", new Object[0]);
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + key + ": " + EnumChatFormatting.YELLOW + wrapper.value));
            return;
        }
        if (args.length < 3) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String value = args[2];
        if ("set".equals(operator)) {
            RunningConfig.ConfigWrapper wrapper = this.getConfigMap().get(key);
            if (wrapper == null) {
                throw new CommandException("Key does not exist.", new Object[0]);
            }
            try {
                wrapper.update(value);
                this.refresh();
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Value updated."));
            }
            catch (Exception ex) {
                throw new CommandException("Error parsing type for " + wrapper.value.getClass().getSimpleName() + ": " + ex.getLocalizedMessage(), new Object[0]);
            }
            return;
        }
        throw new CommandException(this.func_71518_a(sender), new Object[0]);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            return Collections.emptyList();
        }
        if (args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandReloadConfig.func_71530_a((String[])args, (String[])new String[]{"list", "reload", "get", "set"});
        }
        String operator = args[0];
        if (args.length == 2 && ("get".equals(operator) || "set".equals(operator))) {
            return CommandReloadConfig.func_71531_a((String[])args, (Iterable)this.getConfigMap().keySet().stream().map(String::valueOf).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }
}

