/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.main.MainRegistry;
import com.hbm.util.BobMathUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandPacketInfo
extends CommandBase {
    public String func_71517_b() {
        return "ntmpackets";
    }

    public String func_71518_a(ICommandSender sender) {
        return EnumChatFormatting.RED + "/ntmpackets [info/resetState/toggleThreadingStatus/forceLock/forceUnlock]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            switch (args[0]) {
                case "resetState": {
                    PacketThreading.hasTriggered = false;
                    PacketThreading.clearCnt = 0;
                    return;
                }
                case "toggleThreadingStatus": {
                    GeneralConfig.enablePacketThreading = !GeneralConfig.enablePacketThreading;
                    PacketThreading.init();
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Packet sending status toggled to " + GeneralConfig.enablePacketThreading + "."));
                    return;
                }
                case "forceLock": {
                    PacketThreading.lock.lock();
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Packet thread lock acquired, this may freeze the main thread!"));
                    MainRegistry.logger.error("Packet thread lock acquired by {}, this may freeze the main thread!", new Object[]{sender.func_70005_c_()});
                    return;
                }
                case "forceUnlock": {
                    PacketThreading.lock.unlock();
                    MainRegistry.logger.warn("Packet thread lock released by {}.", new Object[]{sender.func_70005_c_()});
                    return;
                }
                case "info": {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "NTM Packet Debugger v1.2"));
                    if (PacketThreading.isTriggered() && GeneralConfig.enablePacketThreading) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Packet Threading Errored, check log."));
                    } else if (GeneralConfig.enablePacketThreading) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Packet Threading Active"));
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Packet Threading Inactive"));
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Thread Pool Info"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "# Threads (total): " + PacketThreading.threadPool.getPoolSize()));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "# Threads (core): " + PacketThreading.threadPool.getCorePoolSize()));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "# Threads (idle): " + (PacketThreading.threadPool.getPoolSize() - PacketThreading.threadPool.getActiveCount())));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "# Threads (maximum): " + PacketThreading.threadPool.getMaximumPoolSize()));
                    for (ThreadInfo thread : ManagementFactory.getThreadMXBean().dumpAllThreads(false, false)) {
                        if (!thread.getThreadName().startsWith("NTM-Packet-Thread-")) continue;
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Thread Name: " + thread.getThreadName()));
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Thread ID: " + thread.getThreadId()));
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Thread state: " + (Object)((Object)thread.getThreadState())));
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Locked by: " + (thread.getLockOwnerName() == null ? "None" : thread.getLockName())));
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Packet Info: "));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Amount total: " + PacketThreading.totalCnt));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Amount remaining: " + PacketThreading.threadPool.getQueue().size()));
                    if (PacketThreading.totalCnt != 0) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "% Remaining to process: " + BobMathUtil.roundDecimal((double)PacketThreading.threadPool.getQueue().size() / (double)PacketThreading.totalCnt * 100.0, 2) + "%"));
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Time spent waiting on thread(s) last tick: " + BobMathUtil.roundDecimal(TimeUnit.MILLISECONDS.convert(PacketThreading.nanoTimeWaited, TimeUnit.NANOSECONDS), 4) + "ms"));
                    return;
                }
            }
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a(sender)));
    }
}

