/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.world.feature.HugeMush;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMush
extends Block
implements IGrowable,
IPlantable {
    private static final Set<Block> canGrowOn = new HashSet<Block>();

    public BlockMush(Material p_i45394_1_) {
        super(p_i45394_1_);
        float f = 0.2f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149675_a(true);
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block.func_149730_j();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (y >= 0 && y < 256) {
            Block block = world.func_147439_a(x, y - 1, z);
            return block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this) || this.canMushGrowHere(world, x, y, z);
        }
        return false;
    }

    public boolean canMushGrowHere(World world, int x, int y, int z) {
        if (canGrowOn.isEmpty()) {
            canGrowOn.add(ModBlocks.waste_earth);
            canGrowOn.add(ModBlocks.waste_mycelium);
            canGrowOn.add(ModBlocks.waste_trinitite);
            canGrowOn.add(ModBlocks.waste_trinitite_red);
            canGrowOn.add(ModBlocks.block_waste);
            canGrowOn.add(ModBlocks.block_waste_painted);
            canGrowOn.add(ModBlocks.block_waste_vitrified);
        }
        Block block = world.func_147439_a(x, y - 1, z);
        return canGrowOn.contains(block);
    }

    public boolean growHuge(World world, int x, int y, int z, Random rand) {
        world.func_72805_g(x, y, z);
        world.func_147468_f(x, y, z);
        new HugeMush().func_76484_a(world, rand, x, y, z);
        return true;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean b) {
        return this.func_149718_j(world, x, y, z);
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_2_.nextFloat() < 0.4;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.growHuge(world, x, y, z, rand);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
        if (GeneralConfig.enableMycelium && world.func_147439_a(x, y - 1, z) == ModBlocks.waste_earth && rand.nextInt(5) == 0) {
            world.func_147449_b(x, y - 1, z, ModBlocks.waste_mycelium);
        }
        if (rand.nextInt(25) == 0) {
            int iz;
            int iy;
            int ix;
            int range = 4;
            int maxShroom = 3;
            for (ix = x - range; ix <= x + range; ++ix) {
                for (iy = y - range; iy <= y + range; ++iy) {
                    for (iz = z - 1; iz <= z + 1; ++iz) {
                        if (world.func_147439_a(ix, iz, iy) != this || --maxShroom > 0) continue;
                        return;
                    }
                }
            }
            ix = x + rand.nextInt(5) - 2;
            iy = z + rand.nextInt(2) - rand.nextInt(2);
            iz = y + rand.nextInt(5) - 2;
            for (int l1 = 0; l1 < 4; ++l1) {
                if (world.func_147437_c(ix, iy, iz) && this.canMushGrowHere(world, ix, iy, iz)) {
                    x = ix;
                    z = iy;
                    y = iz;
                }
                ix = x + rand.nextInt(5) - 2;
                iy = z + rand.nextInt(2) - rand.nextInt(2);
                iz = y + rand.nextInt(5) - 2;
            }
            if (world.func_147437_c(ix, iy, iz) && this.canMushGrowHere(world, ix, iy, iz)) {
                world.func_147465_d(ix, iy, iz, (Block)this, 0, 2);
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }
}

