/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.IBlockMulti;
import com.hbm.config.MobConfig;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.mob.glyphid.EntityGlyphidBehemoth;
import com.hbm.entity.mob.glyphid.EntityGlyphidBlaster;
import com.hbm.entity.mob.glyphid.EntityGlyphidBombardier;
import com.hbm.entity.mob.glyphid.EntityGlyphidBrawler;
import com.hbm.entity.mob.glyphid.EntityGlyphidBrenda;
import com.hbm.entity.mob.glyphid.EntityGlyphidDigger;
import com.hbm.entity.mob.glyphid.EntityGlyphidNuclear;
import com.hbm.entity.mob.glyphid.EntityGlyphidScout;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class BlockGlyphidSpawner
extends BlockContainer
implements IBlockMulti {
    public IIcon[] icons = new IIcon[3];
    private static final ArrayList<Tuple.Pair<Function<World, EntityGlyphid>, int[]>> spawnMap = new ArrayList();

    public BlockGlyphidSpawner(Material mat) {
        super(mat);
        this.func_149647_a(MainRegistry.blockTab);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return ModItems.egg_glyphid;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % this.icons.length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons[0] = reg.func_94245_a("hbm:glyphid_eggs_alt");
        this.icons[1] = reg.func_94245_a("hbm:glyphid_eggs_infested");
        this.icons[2] = reg.func_94245_a("hbm:glyphid_eggs_rad");
    }

    @Override
    public int getSubCount() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getSubCount(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        return 1 + rand.nextInt(3) + fortune;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGlpyhidSpawner();
    }

    static {
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphid::new, MobConfig.glyphidChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidBombardier::new, MobConfig.bombardierChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidBrawler::new, MobConfig.brawlerChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidDigger::new, MobConfig.diggerChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidBlaster::new, MobConfig.blasterChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidBehemoth::new, MobConfig.behemothChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidBrenda::new, MobConfig.brendaChance));
        spawnMap.add(new Tuple.Pair<Function<World, EntityGlyphid>, int[]>(EntityGlyphidNuclear::new, MobConfig.johnsonChance));
    }

    public static class TileEntityGlpyhidSpawner
    extends TileEntity {
        boolean initialSpawn = true;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73013_u != EnumDifficulty.PEACEFUL && (this.initialSpawn || this.field_145850_b.func_82737_E() % (long)MobConfig.swarmCooldown == 0L)) {
                this.initialSpawn = false;
                int count = 0;
                for (Object e : this.field_145850_b.field_72996_f) {
                    if (!(e instanceof EntityGlyphid) || !((double)(++count) >= MobConfig.spawnMax)) continue;
                    return;
                }
                List list = this.field_145850_b.func_72872_a(EntityGlyphid.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)(this.field_145848_d + 1), (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 6)));
                float soot = PollutionHandler.getPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT);
                int subtype = this.func_145832_p();
                if (list.size() <= 3 || subtype == 2) {
                    ArrayList<EntityGlyphid> currentSwarm = this.createSwarm(soot, subtype);
                    for (EntityGlyphid glyphid : currentSwarm) {
                        this.trySpawnEntity(glyphid);
                    }
                    if (!this.initialSpawn && this.field_145850_b.field_73012_v.nextInt(MobConfig.scoutSwarmSpawnChance + 1) == 0 && (double)soot >= MobConfig.scoutThreshold && subtype != 2) {
                        EntityGlyphidScout scout = new EntityGlyphidScout(this.field_145850_b);
                        if (this.func_145832_p() == 1) {
                            scout.func_70096_w().func_75692_b(18, (Object)1);
                        }
                        this.trySpawnEntity(scout);
                    }
                }
            }
        }

        public void trySpawnEntity(EntityGlyphid glyphid) {
            double offsetX = glyphid.func_70681_au().nextGaussian() * 3.0;
            double offsetZ = glyphid.func_70681_au().nextGaussian() * 3.0;
            for (int i = 0; i < 7; ++i) {
                glyphid.func_70012_b((double)this.field_145851_c + 0.5 + offsetX, this.field_145848_d - 2 + i, (double)this.field_145849_e + 0.5 + offsetZ, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!glyphid.func_70601_bi()) continue;
                this.field_145850_b.func_72838_d((Entity)glyphid);
                return;
            }
        }

        public ArrayList<EntityGlyphid> createSwarm(float soot, int meta) {
            Random rand = new Random();
            ArrayList<EntityGlyphid> currentSpawns = new ArrayList<EntityGlyphid>();
            int swarmAmount = (int)Math.min((double)MobConfig.baseSwarmSize * Math.max(MobConfig.swarmScalingMult * (double)(soot / (float)MobConfig.sootStep), 1.0), 10.0);
            for (int cap = 100; currentSpawns.size() <= swarmAmount && cap >= 0; --cap) {
                for (Tuple.Pair glyphid : spawnMap) {
                    int[] chance = (int[])glyphid.getValue();
                    int adjustedChance = (int)((float)chance[0] + ((float)chance[1] - (float)chance[1] / Math.max((soot + 1.0f) / 3.0f, 1.0f)));
                    if (!(soot >= (float)chance[2]) || rand.nextInt(100) > adjustedChance) continue;
                    EntityGlyphid entity = (EntityGlyphid)((Function)glyphid.getKey()).apply(this.field_145850_b);
                    if (meta == 1) {
                        entity.func_70096_w().func_75692_b(18, (Object)1);
                    }
                    if (meta == 2) {
                        entity.func_70096_w().func_75692_b(18, (Object)2);
                    }
                    currentSpawns.add(entity);
                }
            }
            return currentSpawns;
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74757_a("initialSpawn", this.initialSpawn);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.initialSpawn = nbt.func_74767_n("initialSpawn");
        }
    }
}

