import 'dart:math';

const List prefixes = [
  '月光',
  '星云',
  '量子',
  '琉璃',
  '蒸汽',
  '镜像',
  '蜂巢',
  '极光',
  '云端',
  '琥珀',
  '棱镜',
  '螺旋',
  '黄昏',
  '黎光',
  '数据',
  '像素',
  '立方',
  '穹顶',
  '虫洞',
  ' fractal',
  '相位',
  '回声',
  '虚像',
  '纳米',
  '拓扑',
  '弦月',
  '翡翠',
  '静滞',
  '折叠',
  '观星',
  '粒子',
  '相位',
  '虹膜',
  '熵减',
  '拓扑',
  '全息',
  '磁浮',
  '反物质',
  '曲速',
  '克莱因',
];

const List middles = [
  '会议室',
  '作战室',
  '温室',
  '档案馆',
  '核心',
  '回廊',
  '枢纽',
  '大厅',
  '观测台',
  '实验室',
  '咖啡角',
  '舰桥',
  '冥想间',
  '工坊',
  '沙盘',
  '剧场',
  '花房',
  '终端',
  '矩阵',
  '蜂巢',
  '图书馆',
  '发射井',
  '熔炉',
  '停机坪',
  '禁闭室',
  '培养舱',
  '画廊',
  '反应堆',
  '棱镜',
  '暗房',
  '跃迁舱',
  '服务器',
  '投影间',
  '解压舱',
  '温室',
  '指挥台',
  '孵化器',
  '天井',
  '祭坛',
  '回响室',
];
// 创建一个随机数生成器实例
final Random _random = Random();

/// 生成一个随机名称，由一个前缀和一个中间部分组成
String RandomName() {
  // 随机选择一个前缀
  final String prefix = prefixes[_random.nextInt(prefixes.length)];
  // 随机选择一个中间部分
  final String middle = middles[_random.nextInt(middles.length)];

  // 组合并返回名称
  return '$prefix$middle';
}
