#ifndef CodePointSetData_H
#define CodePointSetData_H

#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include "diplomat_runtime.h"

#include "CodePointRangeIterator.d.h"
#include "DataError.d.h"
#include "DataProvider.d.h"
#include "GeneralCategoryGroup.d.h"

#include "CodePointSetData.d.h"






bool icu4x_CodePointSetData_contains_mv1(const CodePointSetData* self, char32_t cp);

CodePointRangeIterator* icu4x_CodePointSetData_iter_ranges_mv1(const CodePointSetData* self);

CodePointRangeIterator* icu4x_CodePointSetData_iter_ranges_complemented_mv1(const CodePointSetData* self);

CodePointSetData* icu4x_CodePointSetData_create_general_category_group_mv1(GeneralCategoryGroup group);

typedef struct icu4x_CodePointSetData_create_general_category_group_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_general_category_group_with_provider_mv1_result;
icu4x_CodePointSetData_create_general_category_group_with_provider_mv1_result icu4x_CodePointSetData_create_general_category_group_with_provider_mv1(const DataProvider* provider, uint32_t group);

bool icu4x_CodePointSetData_ascii_hex_digit_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_ascii_hex_digit_mv1(void);

typedef struct icu4x_CodePointSetData_create_ascii_hex_digit_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_ascii_hex_digit_with_provider_mv1_result;
icu4x_CodePointSetData_create_ascii_hex_digit_with_provider_mv1_result icu4x_CodePointSetData_create_ascii_hex_digit_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_alnum_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_alnum_mv1(void);

typedef struct icu4x_CodePointSetData_create_alnum_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_alnum_with_provider_mv1_result;
icu4x_CodePointSetData_create_alnum_with_provider_mv1_result icu4x_CodePointSetData_create_alnum_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_alphabetic_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_alphabetic_mv1(void);

typedef struct icu4x_CodePointSetData_create_alphabetic_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_alphabetic_with_provider_mv1_result;
icu4x_CodePointSetData_create_alphabetic_with_provider_mv1_result icu4x_CodePointSetData_create_alphabetic_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_bidi_control_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_bidi_control_mv1(void);

typedef struct icu4x_CodePointSetData_create_bidi_control_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_bidi_control_with_provider_mv1_result;
icu4x_CodePointSetData_create_bidi_control_with_provider_mv1_result icu4x_CodePointSetData_create_bidi_control_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_bidi_mirrored_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_bidi_mirrored_mv1(void);

typedef struct icu4x_CodePointSetData_create_bidi_mirrored_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_bidi_mirrored_with_provider_mv1_result;
icu4x_CodePointSetData_create_bidi_mirrored_with_provider_mv1_result icu4x_CodePointSetData_create_bidi_mirrored_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_blank_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_blank_mv1(void);

typedef struct icu4x_CodePointSetData_create_blank_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_blank_with_provider_mv1_result;
icu4x_CodePointSetData_create_blank_with_provider_mv1_result icu4x_CodePointSetData_create_blank_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_cased_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_cased_mv1(void);

typedef struct icu4x_CodePointSetData_create_cased_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_cased_with_provider_mv1_result;
icu4x_CodePointSetData_create_cased_with_provider_mv1_result icu4x_CodePointSetData_create_cased_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_case_ignorable_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_case_ignorable_mv1(void);

typedef struct icu4x_CodePointSetData_create_case_ignorable_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_case_ignorable_with_provider_mv1_result;
icu4x_CodePointSetData_create_case_ignorable_with_provider_mv1_result icu4x_CodePointSetData_create_case_ignorable_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_full_composition_exclusion_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_full_composition_exclusion_mv1(void);

typedef struct icu4x_CodePointSetData_create_full_composition_exclusion_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_full_composition_exclusion_with_provider_mv1_result;
icu4x_CodePointSetData_create_full_composition_exclusion_with_provider_mv1_result icu4x_CodePointSetData_create_full_composition_exclusion_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_casefolded_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_casefolded_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_casefolded_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_casefolded_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_casefolded_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_casefolded_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_casemapped_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_casemapped_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_casemapped_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_casemapped_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_casemapped_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_casemapped_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_nfkc_casefolded_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_nfkc_casefolded_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_nfkc_casefolded_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_nfkc_casefolded_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_nfkc_casefolded_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_nfkc_casefolded_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_lowercased_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_lowercased_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_lowercased_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_lowercased_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_lowercased_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_lowercased_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_titlecased_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_titlecased_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_titlecased_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_titlecased_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_titlecased_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_titlecased_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_changes_when_uppercased_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_changes_when_uppercased_mv1(void);

typedef struct icu4x_CodePointSetData_create_changes_when_uppercased_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_changes_when_uppercased_with_provider_mv1_result;
icu4x_CodePointSetData_create_changes_when_uppercased_with_provider_mv1_result icu4x_CodePointSetData_create_changes_when_uppercased_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_dash_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_dash_mv1(void);

typedef struct icu4x_CodePointSetData_create_dash_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_dash_with_provider_mv1_result;
icu4x_CodePointSetData_create_dash_with_provider_mv1_result icu4x_CodePointSetData_create_dash_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_deprecated_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_deprecated_mv1(void);

typedef struct icu4x_CodePointSetData_create_deprecated_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_deprecated_with_provider_mv1_result;
icu4x_CodePointSetData_create_deprecated_with_provider_mv1_result icu4x_CodePointSetData_create_deprecated_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_default_ignorable_code_point_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_default_ignorable_code_point_mv1(void);

typedef struct icu4x_CodePointSetData_create_default_ignorable_code_point_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_default_ignorable_code_point_with_provider_mv1_result;
icu4x_CodePointSetData_create_default_ignorable_code_point_with_provider_mv1_result icu4x_CodePointSetData_create_default_ignorable_code_point_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_diacritic_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_diacritic_mv1(void);

typedef struct icu4x_CodePointSetData_create_diacritic_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_diacritic_with_provider_mv1_result;
icu4x_CodePointSetData_create_diacritic_with_provider_mv1_result icu4x_CodePointSetData_create_diacritic_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_emoji_modifier_base_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_emoji_modifier_base_mv1(void);

typedef struct icu4x_CodePointSetData_create_emoji_modifier_base_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_emoji_modifier_base_with_provider_mv1_result;
icu4x_CodePointSetData_create_emoji_modifier_base_with_provider_mv1_result icu4x_CodePointSetData_create_emoji_modifier_base_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_emoji_component_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_emoji_component_mv1(void);

typedef struct icu4x_CodePointSetData_create_emoji_component_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_emoji_component_with_provider_mv1_result;
icu4x_CodePointSetData_create_emoji_component_with_provider_mv1_result icu4x_CodePointSetData_create_emoji_component_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_emoji_modifier_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_emoji_modifier_mv1(void);

typedef struct icu4x_CodePointSetData_create_emoji_modifier_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_emoji_modifier_with_provider_mv1_result;
icu4x_CodePointSetData_create_emoji_modifier_with_provider_mv1_result icu4x_CodePointSetData_create_emoji_modifier_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_emoji_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_emoji_mv1(void);

typedef struct icu4x_CodePointSetData_create_emoji_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_emoji_with_provider_mv1_result;
icu4x_CodePointSetData_create_emoji_with_provider_mv1_result icu4x_CodePointSetData_create_emoji_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_emoji_presentation_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_emoji_presentation_mv1(void);

typedef struct icu4x_CodePointSetData_create_emoji_presentation_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_emoji_presentation_with_provider_mv1_result;
icu4x_CodePointSetData_create_emoji_presentation_with_provider_mv1_result icu4x_CodePointSetData_create_emoji_presentation_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_extender_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_extender_mv1(void);

typedef struct icu4x_CodePointSetData_create_extender_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_extender_with_provider_mv1_result;
icu4x_CodePointSetData_create_extender_with_provider_mv1_result icu4x_CodePointSetData_create_extender_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_extended_pictographic_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_extended_pictographic_mv1(void);

typedef struct icu4x_CodePointSetData_create_extended_pictographic_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_extended_pictographic_with_provider_mv1_result;
icu4x_CodePointSetData_create_extended_pictographic_with_provider_mv1_result icu4x_CodePointSetData_create_extended_pictographic_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_graph_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_graph_mv1(void);

typedef struct icu4x_CodePointSetData_create_graph_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_graph_with_provider_mv1_result;
icu4x_CodePointSetData_create_graph_with_provider_mv1_result icu4x_CodePointSetData_create_graph_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_grapheme_base_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_grapheme_base_mv1(void);

typedef struct icu4x_CodePointSetData_create_grapheme_base_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_grapheme_base_with_provider_mv1_result;
icu4x_CodePointSetData_create_grapheme_base_with_provider_mv1_result icu4x_CodePointSetData_create_grapheme_base_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_grapheme_extend_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_grapheme_extend_mv1(void);

typedef struct icu4x_CodePointSetData_create_grapheme_extend_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_grapheme_extend_with_provider_mv1_result;
icu4x_CodePointSetData_create_grapheme_extend_with_provider_mv1_result icu4x_CodePointSetData_create_grapheme_extend_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_grapheme_link_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_grapheme_link_mv1(void);

typedef struct icu4x_CodePointSetData_create_grapheme_link_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_grapheme_link_with_provider_mv1_result;
icu4x_CodePointSetData_create_grapheme_link_with_provider_mv1_result icu4x_CodePointSetData_create_grapheme_link_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_hex_digit_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_hex_digit_mv1(void);

typedef struct icu4x_CodePointSetData_create_hex_digit_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_hex_digit_with_provider_mv1_result;
icu4x_CodePointSetData_create_hex_digit_with_provider_mv1_result icu4x_CodePointSetData_create_hex_digit_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_hyphen_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_hyphen_mv1(void);

typedef struct icu4x_CodePointSetData_create_hyphen_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_hyphen_with_provider_mv1_result;
icu4x_CodePointSetData_create_hyphen_with_provider_mv1_result icu4x_CodePointSetData_create_hyphen_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_id_continue_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_id_continue_mv1(void);

typedef struct icu4x_CodePointSetData_create_id_continue_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_id_continue_with_provider_mv1_result;
icu4x_CodePointSetData_create_id_continue_with_provider_mv1_result icu4x_CodePointSetData_create_id_continue_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_ideographic_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_ideographic_mv1(void);

typedef struct icu4x_CodePointSetData_create_ideographic_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_ideographic_with_provider_mv1_result;
icu4x_CodePointSetData_create_ideographic_with_provider_mv1_result icu4x_CodePointSetData_create_ideographic_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_id_start_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_id_start_mv1(void);

typedef struct icu4x_CodePointSetData_create_id_start_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_id_start_with_provider_mv1_result;
icu4x_CodePointSetData_create_id_start_with_provider_mv1_result icu4x_CodePointSetData_create_id_start_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_ids_binary_operator_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_ids_binary_operator_mv1(void);

typedef struct icu4x_CodePointSetData_create_ids_binary_operator_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_ids_binary_operator_with_provider_mv1_result;
icu4x_CodePointSetData_create_ids_binary_operator_with_provider_mv1_result icu4x_CodePointSetData_create_ids_binary_operator_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_ids_trinary_operator_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_ids_trinary_operator_mv1(void);

typedef struct icu4x_CodePointSetData_create_ids_trinary_operator_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_ids_trinary_operator_with_provider_mv1_result;
icu4x_CodePointSetData_create_ids_trinary_operator_with_provider_mv1_result icu4x_CodePointSetData_create_ids_trinary_operator_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_join_control_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_join_control_mv1(void);

typedef struct icu4x_CodePointSetData_create_join_control_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_join_control_with_provider_mv1_result;
icu4x_CodePointSetData_create_join_control_with_provider_mv1_result icu4x_CodePointSetData_create_join_control_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_logical_order_exception_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_logical_order_exception_mv1(void);

typedef struct icu4x_CodePointSetData_create_logical_order_exception_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_logical_order_exception_with_provider_mv1_result;
icu4x_CodePointSetData_create_logical_order_exception_with_provider_mv1_result icu4x_CodePointSetData_create_logical_order_exception_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_lowercase_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_lowercase_mv1(void);

typedef struct icu4x_CodePointSetData_create_lowercase_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_lowercase_with_provider_mv1_result;
icu4x_CodePointSetData_create_lowercase_with_provider_mv1_result icu4x_CodePointSetData_create_lowercase_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_math_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_math_mv1(void);

typedef struct icu4x_CodePointSetData_create_math_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_math_with_provider_mv1_result;
icu4x_CodePointSetData_create_math_with_provider_mv1_result icu4x_CodePointSetData_create_math_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_noncharacter_code_point_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_noncharacter_code_point_mv1(void);

typedef struct icu4x_CodePointSetData_create_noncharacter_code_point_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_noncharacter_code_point_with_provider_mv1_result;
icu4x_CodePointSetData_create_noncharacter_code_point_with_provider_mv1_result icu4x_CodePointSetData_create_noncharacter_code_point_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_nfc_inert_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_nfc_inert_mv1(void);

typedef struct icu4x_CodePointSetData_create_nfc_inert_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_nfc_inert_with_provider_mv1_result;
icu4x_CodePointSetData_create_nfc_inert_with_provider_mv1_result icu4x_CodePointSetData_create_nfc_inert_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_nfd_inert_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_nfd_inert_mv1(void);

typedef struct icu4x_CodePointSetData_create_nfd_inert_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_nfd_inert_with_provider_mv1_result;
icu4x_CodePointSetData_create_nfd_inert_with_provider_mv1_result icu4x_CodePointSetData_create_nfd_inert_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_nfkc_inert_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_nfkc_inert_mv1(void);

typedef struct icu4x_CodePointSetData_create_nfkc_inert_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_nfkc_inert_with_provider_mv1_result;
icu4x_CodePointSetData_create_nfkc_inert_with_provider_mv1_result icu4x_CodePointSetData_create_nfkc_inert_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_nfkd_inert_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_nfkd_inert_mv1(void);

typedef struct icu4x_CodePointSetData_create_nfkd_inert_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_nfkd_inert_with_provider_mv1_result;
icu4x_CodePointSetData_create_nfkd_inert_with_provider_mv1_result icu4x_CodePointSetData_create_nfkd_inert_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_pattern_syntax_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_pattern_syntax_mv1(void);

typedef struct icu4x_CodePointSetData_create_pattern_syntax_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_pattern_syntax_with_provider_mv1_result;
icu4x_CodePointSetData_create_pattern_syntax_with_provider_mv1_result icu4x_CodePointSetData_create_pattern_syntax_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_pattern_white_space_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_pattern_white_space_mv1(void);

typedef struct icu4x_CodePointSetData_create_pattern_white_space_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_pattern_white_space_with_provider_mv1_result;
icu4x_CodePointSetData_create_pattern_white_space_with_provider_mv1_result icu4x_CodePointSetData_create_pattern_white_space_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_prepended_concatenation_mark_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_prepended_concatenation_mark_mv1(void);

typedef struct icu4x_CodePointSetData_create_prepended_concatenation_mark_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_prepended_concatenation_mark_with_provider_mv1_result;
icu4x_CodePointSetData_create_prepended_concatenation_mark_with_provider_mv1_result icu4x_CodePointSetData_create_prepended_concatenation_mark_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_print_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_print_mv1(void);

typedef struct icu4x_CodePointSetData_create_print_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_print_with_provider_mv1_result;
icu4x_CodePointSetData_create_print_with_provider_mv1_result icu4x_CodePointSetData_create_print_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_quotation_mark_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_quotation_mark_mv1(void);

typedef struct icu4x_CodePointSetData_create_quotation_mark_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_quotation_mark_with_provider_mv1_result;
icu4x_CodePointSetData_create_quotation_mark_with_provider_mv1_result icu4x_CodePointSetData_create_quotation_mark_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_radical_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_radical_mv1(void);

typedef struct icu4x_CodePointSetData_create_radical_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_radical_with_provider_mv1_result;
icu4x_CodePointSetData_create_radical_with_provider_mv1_result icu4x_CodePointSetData_create_radical_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_regional_indicator_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_regional_indicator_mv1(void);

typedef struct icu4x_CodePointSetData_create_regional_indicator_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_regional_indicator_with_provider_mv1_result;
icu4x_CodePointSetData_create_regional_indicator_with_provider_mv1_result icu4x_CodePointSetData_create_regional_indicator_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_soft_dotted_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_soft_dotted_mv1(void);

typedef struct icu4x_CodePointSetData_create_soft_dotted_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_soft_dotted_with_provider_mv1_result;
icu4x_CodePointSetData_create_soft_dotted_with_provider_mv1_result icu4x_CodePointSetData_create_soft_dotted_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_segment_starter_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_segment_starter_mv1(void);

typedef struct icu4x_CodePointSetData_create_segment_starter_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_segment_starter_with_provider_mv1_result;
icu4x_CodePointSetData_create_segment_starter_with_provider_mv1_result icu4x_CodePointSetData_create_segment_starter_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_case_sensitive_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_case_sensitive_mv1(void);

typedef struct icu4x_CodePointSetData_create_case_sensitive_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_case_sensitive_with_provider_mv1_result;
icu4x_CodePointSetData_create_case_sensitive_with_provider_mv1_result icu4x_CodePointSetData_create_case_sensitive_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_sentence_terminal_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_sentence_terminal_mv1(void);

typedef struct icu4x_CodePointSetData_create_sentence_terminal_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_sentence_terminal_with_provider_mv1_result;
icu4x_CodePointSetData_create_sentence_terminal_with_provider_mv1_result icu4x_CodePointSetData_create_sentence_terminal_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_terminal_punctuation_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_terminal_punctuation_mv1(void);

typedef struct icu4x_CodePointSetData_create_terminal_punctuation_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_terminal_punctuation_with_provider_mv1_result;
icu4x_CodePointSetData_create_terminal_punctuation_with_provider_mv1_result icu4x_CodePointSetData_create_terminal_punctuation_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_unified_ideograph_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_unified_ideograph_mv1(void);

typedef struct icu4x_CodePointSetData_create_unified_ideograph_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_unified_ideograph_with_provider_mv1_result;
icu4x_CodePointSetData_create_unified_ideograph_with_provider_mv1_result icu4x_CodePointSetData_create_unified_ideograph_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_uppercase_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_uppercase_mv1(void);

typedef struct icu4x_CodePointSetData_create_uppercase_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_uppercase_with_provider_mv1_result;
icu4x_CodePointSetData_create_uppercase_with_provider_mv1_result icu4x_CodePointSetData_create_uppercase_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_variation_selector_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_variation_selector_mv1(void);

typedef struct icu4x_CodePointSetData_create_variation_selector_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_variation_selector_with_provider_mv1_result;
icu4x_CodePointSetData_create_variation_selector_with_provider_mv1_result icu4x_CodePointSetData_create_variation_selector_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_white_space_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_white_space_mv1(void);

typedef struct icu4x_CodePointSetData_create_white_space_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_white_space_with_provider_mv1_result;
icu4x_CodePointSetData_create_white_space_with_provider_mv1_result icu4x_CodePointSetData_create_white_space_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_xdigit_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_xdigit_mv1(void);

typedef struct icu4x_CodePointSetData_create_xdigit_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_xdigit_with_provider_mv1_result;
icu4x_CodePointSetData_create_xdigit_with_provider_mv1_result icu4x_CodePointSetData_create_xdigit_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_xid_continue_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_xid_continue_mv1(void);

typedef struct icu4x_CodePointSetData_create_xid_continue_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_xid_continue_with_provider_mv1_result;
icu4x_CodePointSetData_create_xid_continue_with_provider_mv1_result icu4x_CodePointSetData_create_xid_continue_with_provider_mv1(const DataProvider* provider);

bool icu4x_CodePointSetData_xid_start_for_char_mv1(char32_t ch);

CodePointSetData* icu4x_CodePointSetData_create_xid_start_mv1(void);

typedef struct icu4x_CodePointSetData_create_xid_start_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_xid_start_with_provider_mv1_result;
icu4x_CodePointSetData_create_xid_start_with_provider_mv1_result icu4x_CodePointSetData_create_xid_start_with_provider_mv1(const DataProvider* provider);

typedef struct icu4x_CodePointSetData_create_for_ecma262_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_for_ecma262_mv1_result;
icu4x_CodePointSetData_create_for_ecma262_mv1_result icu4x_CodePointSetData_create_for_ecma262_mv1(DiplomatStringView property_name);

typedef struct icu4x_CodePointSetData_create_for_ecma262_with_provider_mv1_result {union {CodePointSetData* ok; DataError err;}; bool is_ok;} icu4x_CodePointSetData_create_for_ecma262_with_provider_mv1_result;
icu4x_CodePointSetData_create_for_ecma262_with_provider_mv1_result icu4x_CodePointSetData_create_for_ecma262_with_provider_mv1(const DataProvider* provider, DiplomatStringView property_name);


void icu4x_CodePointSetData_destroy_mv1(CodePointSetData* self);





#endif // CodePointSetData_H
