
//<<>-<>>---------------------------------------------------------------------()
/*
	Debug
									      */
//()-------------------------------------------------------------------<<>-<>>//

#ifndef _DEBUG_INCLUDE
#define _DEBUG_INCLUDE


// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤ Définitions							  ¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //

#define	DEBUG_MAXTRACE		32
#define DEBUG_NAMELEN		256

enum {
	DEBUG_LOG_INFO = 1,
	DEBUG_LOG_WARNING,
	DEBUG_LOG_ERROR,
};


// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤ Structures							  ¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //

typedef struct DEBUGHELP {
	HANDLE		hProcess;
	SYMBOL_INFO*	pInfo;
	WCHAR*		pszFormat;
	WCHAR*		pszMessage;
	DWORD_PTR	pArgs[2+DEBUG_MAXTRACE*3];
	void*		pBackTrace[DEBUG_MAXTRACE];
	WCHAR		pszNames[DEBUG_MAXTRACE][DEBUG_NAMELEN];
} DEBUGHELP;

typedef struct DEBUGTYPE {
	UINT		uType;
	WCHAR*		pszType;
} DEBUGTYPE;


// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤ Prototypes							  ¤¤¤ //
// ¤¤¤									  ¤¤¤ //
// ¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤¤ //

LONG WINAPI		Debug_ExceptionHandler(EXCEPTION_POINTERS *);
int			Debug_Printf(WCHAR *,WCHAR *,DWORD_PTR []);
void			Debug_Log(UINT,WCHAR *, ...);
void			Debug_LogSystemError(void);

#endif
