# Web Application Attacks - Datasets

The objective of this repository is to collect different datasets related to Web Application Attacks. Each dataset, is also presented in different formats and partitions in order to validate and comparediferent models to tackle the problem of identify web application attacks.

In order to identify attacks to web application, not only the request line is needed, but also the request body. For example, in case of a POST request the parameters in the body are needed to be analyzed.

As far as we know, there are only two public datasets which include the whole request (request headers and request body).

## ECML/PKDD 2007 Challenge
In 2007 the 18th European Conference on Machine Learning (ECML) and the 11th European Conference on Principles and Practice of Knowledge Discovery in Databases (PKDD), put forward a challenge on Analyzing Web Traffic. The challenge goal was to construct an algorithm based on machine learning techniques to perform multi-class and contextual classification and isolation of the attack patterns. As part of the challenge it was provided a dataset which contained valid traffic and requests classified in seven different types of attacks. The dataset contains 35.006 requests classified as normal and 15.110 requests classified as attacks. The ECML/PKDD2007 dataset was generated by recording real traffic which was then processed to sanitize the information. This masking process consisted in renaming ev- ery url, parameters names and values with randomly generated strings.

The description of the challenge and the specification of dataset content could be found in the [challenge web page](http://www.lirmm.fr/pkdd2007-challenge/index.html "Attack Challenge - ECML/PKDD Workshop") 

The results of description and the results of the challenge could also be found in the following article:
[Web Analyzing Traffic Challenge: Description and Results.](https://hal-lirmm.ccsd.cnrs.fr/lirmm-00168955) Raissi C., Brissaud J., Dray G., Poncelet P., Roche M., Teisseire M. In proceedings of ECML/PKDD'2007 Discovery Challenge, p.47-52, Warsaw, Poland, 2007. 

## CSIC 2010 Dataset  
The Spanish Research National Council (CSIC) developed in 2010 a dataset to test web application attack protection systems. The dataset is tagged in Normal Traffic and Anomalous Traffic. It was developed automatically based on real request to an e-commerce application. The dataset contains 36000 valid requests for training, other 36000 request for testing and 25000 requests of anomalous traffic. To generate the anomalous traffic there were used tools such as Paros (which later became OWASP Zed Attack Proxy (ZAP)) and w3af. In addition to that, some valid requests were modified with typos errors in parameters. Unfortunately, we do not know how real attacks and anomalous traffic distribute in this dataset. 

The specification of dataset content could be found in the [CSIC web page](http://www.isi.csic.es/dataset/ "HTTP DATASET CSIC 2010").


## Cloned from

https://gitlab.fing.edu.uy/gsi/web-application-attacks-datasets/tree/master/csic_2010