/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Statusc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.world.meta.StatValues;

public class EnergyFieldAbility
extends Ability {
    private static final Seq<Healthc> all = new Seq();
    public float damage = 1.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public Effect healEffect = Fx.heal;
    public Effect hitEffect = Fx.hitLaserBlast;
    public Effect damageEffect = Fx.chainLightning;
    public StatusEffect status = StatusEffects.electrified;
    public Sound shootSound = Sounds.spark;
    public float statusDuration = 360.0f;
    public float x;
    public float y;
    public boolean targetGround = true;
    public boolean targetAir = true;
    public boolean hitBuildings = true;
    public boolean hitUnits = true;
    public int maxTargets = 25;
    public float healPercent = 3.0f;
    public float sameTypeHealMult = 1.0f;
    public boolean displayHeal = true;
    public float layer = 99.999f;
    public float blinkScl = 20.0f;
    public float blinkSize = 0.1f;
    public float effectRadius = 5.0f;
    public float sectorRad = 0.14f;
    public float rotateSpeed = 0.5f;
    public int sectors = 5;
    public Color color = Pal.heal;
    public boolean useAmmo = true;
    protected float timer;
    protected float curStroke;
    protected boolean anyNearby = false;

    EnergyFieldAbility() {
    }

    public EnergyFieldAbility(float damage, float reload, float range) {
        this.damage = damage;
        this.reload = reload;
        this.range = range;
    }

    @Override
    public void addStats(Table t) {
        if (this.displayHeal) {
            t.add(Core.bundle.get(this.getBundle() + ".healdescription")).wrap().width(350.0f);
        } else {
            t.add(Core.bundle.get(this.getBundle() + ".description")).wrap().width(350.0f);
        }
        t.row();
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.range / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("firingrate", Strings.autoFixed(60.0f / this.reload, 2)));
        t.row();
        t.add(this.abilityStat("maxtargets", this.maxTargets));
        t.row();
        t.add(Core.bundle.format("bullet.damage", Float.valueOf(this.damage)));
        if (this.status != StatusEffects.none) {
            t.row();
            t.add((this.status.hasEmoji() ? this.status.emoji() : "") + "[stat]" + this.status.localizedName).with(l -> StatValues.withTooltip(l, this.status));
        }
        if (this.displayHeal) {
            t.row();
            t.add(Core.bundle.format("bullet.healpercent", Strings.autoFixed(this.healPercent, 2)));
            t.row();
            t.add(this.abilityStat("sametypehealmultiplier", (this.sameTypeHealMult < 1.0f ? "[negstat]" : "") + Strings.autoFixed(this.sameTypeHealMult * 100.0f, 2)));
        }
    }

    @Override
    public void draw(Unit unit) {
        float rot;
        int i;
        super.draw(unit);
        Draw.z(this.layer);
        Draw.color(this.color);
        Tmp.v1.trns(unit.rotation - 90.0f, this.x, this.y).add(unit.x, unit.y);
        float rx = Tmp.v1.x;
        float ry = Tmp.v1.y;
        float orbRadius = this.effectRadius * (1.0f + Mathf.absin(this.blinkScl, this.blinkSize));
        Fill.circle(rx, ry, orbRadius);
        Draw.color();
        Fill.circle(rx, ry, orbRadius / 2.0f);
        Lines.stroke(0.7f + Mathf.absin(this.blinkScl, 0.7f), this.color);
        for (i = 0; i < this.sectors; ++i) {
            rot = unit.rotation + (float)i * 360.0f / (float)this.sectors - Time.time * this.rotateSpeed;
            Lines.arc(rx, ry, orbRadius + 3.0f, this.sectorRad, rot);
        }
        Lines.stroke(Lines.getStroke() * this.curStroke);
        if (this.curStroke > 0.0f) {
            for (i = 0; i < this.sectors; ++i) {
                rot = unit.rotation + (float)i * 360.0f / (float)this.sectors + Time.time * this.rotateSpeed;
                Lines.arc(rx, ry, this.range, this.sectorRad, rot);
            }
        }
        Drawf.light(rx, ry, this.range * 1.5f, this.color, this.curStroke * 0.8f);
        Draw.reset();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(Unit unit) {
        block11: {
            this.curStroke = Mathf.lerpDelta(this.curStroke, this.anyNearby != false ? 1.0f : 0.0f, 0.09f);
            this.timer += Time.delta;
            if (!(v0 >= this.reload) || this.useAmmo && !(unit.ammo > 0.0f) && Vars.state.rules.unitAmmo) break block11;
            Tmp.v1.trns(unit.rotation - 90.0f, this.x, this.y).add(unit.x, unit.y);
            rx = Tmp.v1.x;
            ry = Tmp.v1.y;
            this.anyNearby = false;
            EnergyFieldAbility.all.clear();
            if (this.hitUnits) {
                Units.nearby(null, rx, ry, this.range, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$update$1(mindustry.gen.Unit mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((EnergyFieldAbility)this, (Unit)unit));
            }
            if (this.hitBuildings && this.targetGround) {
                Units.nearbyBuildings(rx, ry, this.range, (Cons<Building>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$update$2(mindustry.gen.Unit mindustry.gen.Building ), (Lmindustry/gen/Building;)V)((Unit)unit));
            }
            EnergyFieldAbility.all.sort((Floatf<Healthc>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)F, lambda$update$3(float float mindustry.gen.Healthc ), (Lmindustry/gen/Healthc;)F)((float)rx, (float)ry));
            len = Math.min(EnergyFieldAbility.all.size, this.maxTargets);
            for (i = 0; i < len; ++i) {
                block12: {
                    other = EnergyFieldAbility.all.get(i);
                    absorber = Damage.findAbsorber(unit.team, rx, ry, other.getX(), other.getY());
                    if (absorber != null) {
                        other = absorber;
                    }
                    if (((Teamc)other).team() != unit.team) break block12;
                    if (!other.damaged()) continue;
                    this.anyNearby = true;
                    if (!(other instanceof Unit)) ** GOTO lbl-1000
                    u = (Unit)other;
                    if (u.type == unit.type) {
                        v1 = this.sameTypeHealMult;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = 1.0f;
                    }
                    healMult = v1;
                    other.heal(this.healPercent / 100.0f * other.maxHealth() * healMult);
                    this.healEffect.at(other);
                    this.damageEffect.at(rx, ry, 0.0f, this.color, other);
                    this.hitEffect.at(rx, ry, unit.angleTo(other), this.color);
                    if (!(other instanceof Building)) continue;
                    b = (Building)other;
                    Fx.healBlockFull.at(b.x, b.y, 0.0f, this.color, b.block);
                    continue;
                }
                this.anyNearby = true;
                if (other instanceof Building) {
                    b = (Building)other;
                    b.damage(unit.team, this.damage * Vars.state.rules.unitDamage(unit.team));
                } else {
                    other.damage(this.damage * Vars.state.rules.unitDamage(unit.team));
                }
                if (other instanceof Statusc) {
                    s = (Statusc)other;
                    s.apply(this.status, this.statusDuration);
                }
                this.hitEffect.at(other.x(), other.y(), unit.angleTo(other), this.color);
                this.damageEffect.at(rx, ry, 0.0f, this.color, other);
                this.hitEffect.at(rx, ry, unit.angleTo(other), this.color);
            }
            if (this.anyNearby) {
                this.shootSound.at(unit);
                if (this.useAmmo && Vars.state.rules.unitAmmo) {
                    unit.ammo -= 1.0f;
                }
            }
            this.timer = 0.0f;
        }
    }

    private static /* synthetic */ float lambda$update$3(float rx, float ry, Healthc h) {
        return h.dst2(rx, ry);
    }

    private static /* synthetic */ void lambda$update$2(Unit unit, Building b) {
        if ((b.team != Team.derelict || Vars.state.rules.coreCapture) && (b.team != unit.team && b.block.targetable || b.damaged()) && !b.block.privileged) {
            all.add(b);
        }
    }

    private /* synthetic */ void lambda$update$1(Unit unit, Unit other) {
        if (other != unit && other.checkTarget(this.targetAir, this.targetGround) && other.targetable(unit.team) && (other.team != unit.team || other.damaged())) {
            all.add(other);
        }
    }
}

