/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class FlatChunkGenerator
extends ChunkGenerator {
    public static final Codec<FlatChunkGenerator> field_236069_d_ = FlatGenerationSettings.field_236932_a_.fieldOf("settings").xmap(FlatChunkGenerator::new, FlatChunkGenerator::func_236073_g_).codec();
    private final FlatGenerationSettings field_236070_e_;

    public FlatChunkGenerator(FlatGenerationSettings p_i231902_1_) {
        super(new SingleBiomeProvider(p_i231902_1_.func_236942_c_()), new SingleBiomeProvider(p_i231902_1_.getBiome()), p_i231902_1_.func_236943_d_(), 0L);
        this.field_236070_e_ = p_i231902_1_;
    }

    @Override
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return field_236069_d_;
    }

    @Override
    public ChunkGenerator func_230349_a_(long p_230349_1_) {
        return this;
    }

    public FlatGenerationSettings func_236073_g_() {
        return this.field_236070_e_;
    }

    @Override
    public void generateSurface(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
    }

    @Override
    public int getGroundHeight() {
        BlockState[] ablockstate = this.field_236070_e_.getStates();
        for (int i = 0; i < ablockstate.length; ++i) {
            BlockState blockstate;
            BlockState blockState = blockstate = ablockstate[i] == null ? Blocks.AIR.getDefaultState() : ablockstate[i];
            if (Heightmap.Type.MOTION_BLOCKING.getHeightLimitPredicate().test(blockstate)) continue;
            return i - 1;
        }
        return ablockstate.length;
    }

    @Override
    public void func_230352_b_(IWorld p_230352_1_, StructureManager p_230352_2_, IChunk p_230352_3_) {
        BlockState[] ablockstate = this.field_236070_e_.getStates();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Heightmap heightmap = p_230352_3_.getHeightmap(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_230352_3_.getHeightmap(Heightmap.Type.WORLD_SURFACE_WG);
        for (int i = 0; i < ablockstate.length; ++i) {
            BlockState blockstate = ablockstate[i];
            if (blockstate == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    p_230352_3_.setBlockState(blockpos$mutable.setPos(j, i, k), blockstate, false);
                    heightmap.update(j, i, k, blockstate);
                    heightmap1.update(j, i, k, blockstate);
                }
            }
        }
    }

    @Override
    public int getHeight(int x, int z, Heightmap.Type heightmapType) {
        BlockState[] ablockstate = this.field_236070_e_.getStates();
        for (int i = ablockstate.length - 1; i >= 0; --i) {
            BlockState blockstate = ablockstate[i];
            if (blockstate == null || !heightmapType.getHeightLimitPredicate().test(blockstate)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return new Blockreader((BlockState[])Arrays.stream(this.field_236070_e_.getStates()).map(p_236072_0_ -> p_236072_0_ == null ? Blocks.AIR.getDefaultState() : p_236072_0_).toArray(BlockState[]::new));
    }
}

