/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DynamicRegistries {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<RegistryKey<? extends Registry<?>>, CodecHolder<?>> registryCodecMap = (Map)Util.make(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DynamicRegistries.put(builder, Registry.DIMENSION_TYPE_KEY, DimensionType.CODEC, DimensionType.CODEC);
        DynamicRegistries.put(builder, Registry.BIOME_KEY, Biome.CODEC, Biome.PACKET_CODEC);
        DynamicRegistries.put(builder, Registry.CONFIGURED_SURFACE_BUILDER_KEY, ConfiguredSurfaceBuilder.field_237168_a_);
        DynamicRegistries.put(builder, Registry.CONFIGURED_CARVER_KEY, ConfiguredCarver.field_236235_a_);
        DynamicRegistries.put(builder, Registry.CONFIGURED_FEATURE_KEY, ConfiguredFeature.field_242763_a);
        DynamicRegistries.put(builder, Registry.CONFIGURED_STRUCTURE_FEATURE_KEY, StructureFeature.field_236267_a_);
        DynamicRegistries.put(builder, Registry.STRUCTURE_PROCESSOR_LIST_KEY, IStructureProcessorType.field_242921_l);
        DynamicRegistries.put(builder, Registry.JIGSAW_POOL_KEY, JigsawPattern.field_236852_a_);
        DynamicRegistries.put(builder, Registry.NOISE_SETTINGS_KEY, DimensionSettings.field_236097_a_);
        return builder.build();
    });
    private static final Impl registries = Util.make(() -> {
        Impl dynamicregistries$impl = new Impl();
        DimensionType.registerTypes(dynamicregistries$impl);
        registryCodecMap.keySet().stream().filter(registryKey -> !registryKey.equals(Registry.DIMENSION_TYPE_KEY)).forEach(registerKey -> DynamicRegistries.getWorldGenRegistry(dynamicregistries$impl, registerKey));
        return dynamicregistries$impl;
    });

    public abstract <E> Optional<MutableRegistry<E>> func_230521_a_(RegistryKey<? extends Registry<E>> var1);

    public <E> MutableRegistry<E> getRegistry(RegistryKey<? extends Registry<E>> registryKey) {
        return this.func_230521_a_(registryKey).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(registryKey)));
    }

    public Registry<DimensionType> func_230520_a_() {
        return this.getRegistry(Registry.DIMENSION_TYPE_KEY);
    }

    private static <E> void put(ImmutableMap.Builder<RegistryKey<? extends Registry<?>>, CodecHolder<?>> codecHolder, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec) {
        codecHolder.put(registryKey, new CodecHolder<E>(registryKey, codec, null));
    }

    private static <E> void put(ImmutableMap.Builder<RegistryKey<? extends Registry<?>>, CodecHolder<?>> codecHolder, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec, Codec<E> codec2) {
        codecHolder.put(registryKey, new CodecHolder<E>(registryKey, codec, codec2));
    }

    public static Impl func_239770_b_() {
        Impl dynamicregistries$impl = new Impl();
        WorldSettingsImport.IResourceAccess.RegistryAccess worldsettingsimport$iresourceaccess$registryaccess = new WorldSettingsImport.IResourceAccess.RegistryAccess();
        for (CodecHolder<?> codecholder : registryCodecMap.values()) {
            DynamicRegistries.registerRegistry(dynamicregistries$impl, worldsettingsimport$iresourceaccess$registryaccess, codecholder);
        }
        WorldSettingsImport.create(JsonOps.INSTANCE, worldsettingsimport$iresourceaccess$registryaccess, dynamicregistries$impl);
        return dynamicregistries$impl;
    }

    private static <E> void registerRegistry(Impl dynamicRegistries, WorldSettingsImport.IResourceAccess.RegistryAccess registryAccess, CodecHolder<E> codecHolder) {
        RegistryKey<Registry<E>> registrykey = codecHolder.getRegistryKey();
        boolean flag = !registrykey.equals(Registry.NOISE_SETTINGS_KEY) && !registrykey.equals(Registry.DIMENSION_TYPE_KEY);
        MutableRegistry<E> registry = registries.getRegistry(registrykey);
        MutableRegistry<E> mutableregistry = dynamicRegistries.getRegistry(registrykey);
        for (Map.Entry entry : registry.getEntries()) {
            Object e = entry.getValue();
            if (flag) {
                registryAccess.encode(registries, entry.getKey(), codecHolder.getRegistryCodec(), registry.getId(e), e, registry.getLifecycleByRegistry(e));
                continue;
            }
            mutableregistry.register(registry.getId(e), entry.getKey(), e, registry.getLifecycleByRegistry(e));
        }
    }

    private static <R extends Registry<?>> void getWorldGenRegistry(Impl dynamicRegistries, RegistryKey<R> key) {
        Registry<Registry<?>> registry = WorldGenRegistries.ROOT_REGISTRIES;
        Registry<?> registry1 = registry.getValueForKey(key);
        if (registry1 == null) {
            throw new IllegalStateException("Missing builtin registry: " + String.valueOf(key));
        }
        DynamicRegistries.registerRegistry(dynamicRegistries, registry1);
    }

    private static <E> void registerRegistry(Impl dynamicRegistries, Registry<E> registry) {
        MutableRegistry<E> mutableregistry = dynamicRegistries.func_230521_a_(registry.getRegistryKey()).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(registry.getRegistryKey())));
        for (Map.Entry<RegistryKey<E>, E> entry : registry.getEntries()) {
            E e = entry.getValue();
            mutableregistry.register(registry.getId(e), entry.getKey(), e, registry.getLifecycleByRegistry(e));
        }
    }

    public static void loadRegistryData(Impl dynamicRegistries, WorldSettingsImport<?> settingsImport) {
        for (CodecHolder<?> codecholder : registryCodecMap.values()) {
            DynamicRegistries.loadRegistryData(settingsImport, dynamicRegistries, codecholder);
        }
    }

    private static <E> void loadRegistryData(WorldSettingsImport<?> settingsImport, Impl dynamicRegistries, CodecHolder<E> codecHolder) {
        RegistryKey registrykey = codecHolder.getRegistryKey();
        SimpleRegistry simpleregistry = Optional.ofNullable(dynamicRegistries.keyToSimpleRegistryMap.get(registrykey)).map(simpleRegistry -> simpleRegistry).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(registrykey)));
        DataResult<SimpleRegistry<E>> dataresult = settingsImport.decode(simpleregistry, codecHolder.getRegistryKey(), codecHolder.getRegistryCodec());
        dataresult.error().ifPresent(result -> LOGGER.error("Error loading registry data: {}", (Object)result.message()));
    }

    static final class CodecHolder<E> {
        private final RegistryKey<? extends Registry<E>> registryKey;
        private final Codec<E> registryCodec;
        @Nullable
        private final Codec<E> packetCodec;

        public CodecHolder(RegistryKey<? extends Registry<E>> registryKey, Codec<E> registryCodec, @Nullable Codec<E> packetCodec) {
            this.registryKey = registryKey;
            this.registryCodec = registryCodec;
            this.packetCodec = packetCodec;
        }

        public RegistryKey<? extends Registry<E>> getRegistryKey() {
            return this.registryKey;
        }

        public Codec<E> getRegistryCodec() {
            return this.registryCodec;
        }

        @Nullable
        public Codec<E> getPacketCodec() {
            return this.packetCodec;
        }

        public boolean hasPacketCodec() {
            return this.packetCodec != null;
        }
    }

    public static final class Impl
    extends DynamicRegistries {
        public static final Codec<Impl> registryCodec = Impl.getCodec();
        private final Map<? extends RegistryKey<? extends Registry<?>>, ? extends SimpleRegistry<?>> keyToSimpleRegistryMap;

        private static <E> Codec<Impl> getCodec() {
            Codec codec = ResourceLocation.CODEC.xmap(RegistryKey::getOrCreateRootKey, RegistryKey::getLocation);
            Codec codec1 = codec.partialDispatch("type", simpleRegistry -> DataResult.success(simpleRegistry.getRegistryKey()), registryKey -> Impl.serializeRegistry(registryKey).map(codec2 -> SimpleRegistry.createSimpleRegistryCodec(registryKey, Lifecycle.experimental(), codec2)));
            UnboundedMapCodec unboundedmapcodec = Codec.unboundedMap((Codec)codec, (Codec)codec1);
            return Impl.getSerializableCodec(unboundedmapcodec);
        }

        private static <K extends RegistryKey<? extends Registry<?>>, V extends SimpleRegistry<?>> Codec<Impl> getSerializableCodec(UnboundedMapCodec<K, V> unboundedCodec) {
            return unboundedCodec.xmap(Impl::new, dynamicRegistries -> (Map)dynamicRegistries.keyToSimpleRegistryMap.entrySet().stream().filter(entry -> registryCodecMap.get(entry.getKey()).hasPacketCodec()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static <E> DataResult<? extends Codec<E>> serializeRegistry(RegistryKey<? extends Registry<E>> registryKey) {
            return Optional.ofNullable(registryCodecMap.get(registryKey)).map(codecHolder -> codecHolder.getPacketCodec()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + String.valueOf(registryKey))));
        }

        public Impl() {
            this(registryCodecMap.keySet().stream().collect(Collectors.toMap(Function.identity(), Impl::createStableRegistry)));
        }

        private Impl(Map<? extends RegistryKey<? extends Registry<?>>, ? extends SimpleRegistry<?>> keyToSimpleRegistryMap) {
            this.keyToSimpleRegistryMap = keyToSimpleRegistryMap;
        }

        private static <E> SimpleRegistry<?> createStableRegistry(RegistryKey<? extends Registry<?>> registerKey) {
            return new SimpleRegistry(registerKey, Lifecycle.stable());
        }

        @Override
        public <E> Optional<MutableRegistry<E>> func_230521_a_(RegistryKey<? extends Registry<E>> p_230521_1_) {
            return Optional.ofNullable((MutableRegistry)this.keyToSimpleRegistryMap.get(p_230521_1_)).map(mutable -> mutable);
        }
    }
}

