/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.TypeReferences;

public class SpawnerEntityTypes
extends DataFix {
    public SpawnerEntityTypes(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private Dynamic<?> fix(Dynamic<?> p_209659_1_) {
        Optional optional1;
        if (!"MobSpawner".equals(p_209659_1_.get("id").asString(""))) {
            return p_209659_1_;
        }
        Optional optional = p_209659_1_.get("EntityId").asString().result();
        if (optional.isPresent()) {
            Dynamic dynamic = (Dynamic)DataFixUtils.orElse((Optional)p_209659_1_.get("SpawnData").result(), (Object)p_209659_1_.emptyMap());
            dynamic = dynamic.set("id", dynamic.createString(((String)optional.get()).isEmpty() ? "Pig" : (String)optional.get()));
            p_209659_1_ = p_209659_1_.set("SpawnData", dynamic);
            p_209659_1_ = p_209659_1_.remove("EntityId");
        }
        if ((optional1 = p_209659_1_.get("SpawnPotentials").asStreamOpt().result()).isPresent()) {
            p_209659_1_ = p_209659_1_.set("SpawnPotentials", p_209659_1_.createList(((Stream)optional1.get()).map(p_209657_0_ -> {
                Optional optional2 = p_209657_0_.get("Type").asString().result();
                if (optional2.isPresent()) {
                    Dynamic dynamic1 = ((Dynamic)DataFixUtils.orElse((Optional)p_209657_0_.get("Properties").result(), (Object)p_209657_0_.emptyMap())).set("id", p_209657_0_.createString((String)optional2.get()));
                    return p_209657_0_.set("Entity", dynamic1).remove("Type").remove("Properties");
                }
                return p_209657_0_;
            })));
        }
        return p_209659_1_;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(TypeReferences.UNTAGGED_SPAWNER);
        return this.fixTypeEverywhereTyped("MobSpawnerEntityIdentifiersFix", this.getInputSchema().getType(TypeReferences.UNTAGGED_SPAWNER), type, p_206369_2_ -> {
            Dynamic dynamic = (Dynamic)p_206369_2_.get(DSL.remainderFinder());
            DataResult dataresult = type.readTyped(this.fix(dynamic = dynamic.set("id", dynamic.createString("MobSpawner"))));
            return !dataresult.result().isPresent() ? p_206369_2_ : (Typed)((Pair)dataresult.result().get()).getFirst();
        });
    }
}

