/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.newdawn.slick.TrueTypeFont;

public class StringUtils {
    private static final Pattern PATTERN_CONTROL_CODE = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static String stripControlCodes(String text) {
        return PATTERN_CONTROL_CODE.matcher(text).replaceAll("");
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)string);
    }

    public static String[] wrapText(String text, int maxWidth, TrueTypeFont font) {
        String[] words = text.split(" ");
        HashMap<Integer, Object> lines = new HashMap<Integer, Object>();
        int lineIndex = 0;
        for (String word : words) {
            boolean wordExceedsWidth;
            String currentLine = lines.getOrDefault(lineIndex, "");
            boolean isNewLine = !lines.containsKey(lineIndex);
            boolean fitsInLine = font.getWidth(currentLine) + font.getWidth(word) <= maxWidth;
            boolean bl = wordExceedsWidth = font.getWidth(word) >= maxWidth;
            if (!fitsInLine && !wordExceedsWidth) {
                currentLine = lines.getOrDefault(++lineIndex, "");
                isNewLine = !lines.containsKey(lineIndex);
                fitsInLine = font.getWidth(currentLine) + font.getWidth(word) <= maxWidth;
                boolean bl2 = wordExceedsWidth = font.getWidth(word) >= maxWidth;
            }
            if (fitsInLine) {
                lines.put(lineIndex, isNewLine ? word : currentLine + " " + word);
                continue;
            }
            if (!wordExceedsWidth) continue;
            while (wordExceedsWidth && !fitsInLine) {
                for (int trimIndex = 0; trimIndex <= word.length(); ++trimIndex) {
                    String trimmedWord = word.substring(0, word.length() - trimIndex);
                    if (font.getWidth(trimmedWord) > maxWidth) {
                        continue;
                    }
                    lines.put(++lineIndex, trimmedWord);
                    word = word.substring(word.length() - trimIndex);
                    break;
                }
                fitsInLine = font.getWidth(currentLine = lines.getOrDefault(lineIndex, "")) + font.getWidth(word) <= maxWidth;
                wordExceedsWidth = font.getWidth(word) >= maxWidth;
                isNewLine = !lines.containsKey(lineIndex);
            }
            if (!fitsInLine) {
                ++lineIndex;
            }
            lines.put(lineIndex, word);
        }
        return lines.values().toArray(new String[0]);
    }
}

