/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.DispenserContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DispenserTileEntity
extends LockableLootTileEntity {
    private static final Random RNG = new Random();
    private NonNullList<ItemStack> stacks = NonNullList.withSize(9, ItemStack.EMPTY);

    protected DispenserTileEntity(TileEntityType<?> p_i48286_1_) {
        super(p_i48286_1_);
    }

    public DispenserTileEntity() {
        this(TileEntityType.DISPENSER);
    }

    @Override
    public int getSizeInventory() {
        return 9;
    }

    public int getDispenseSlot() {
        this.fillWithLoot(null);
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.stacks.size(); ++k) {
            if (this.stacks.get(k).isEmpty() || RNG.nextInt(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    public int addItemStack(ItemStack stack) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (!this.stacks.get(i).isEmpty()) continue;
            this.setInventorySlotContents(i, stack);
            return i;
        }
        return -1;
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.dispenser");
    }

    @Override
    public void read(BlockState state, CompoundNBT nbt) {
        super.read(state, nbt);
        this.stacks = NonNullList.withSize(this.getSizeInventory(), ItemStack.EMPTY);
        if (!this.checkLootAndRead(nbt)) {
            ItemStackHelper.loadAllItems(nbt, this.stacks);
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        super.write(compound);
        if (!this.checkLootAndWrite(compound)) {
            ItemStackHelper.saveAllItems(compound, this.stacks);
        }
        return compound;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.stacks = itemsIn;
    }

    @Override
    protected Container createMenu(int id, PlayerInventory player) {
        return new DispenserContainer(id, player, this);
    }
}

