/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEula {
    private static final Logger LOG = LogManager.getLogger();
    private final Path eulaFile;
    private final boolean acceptedEULA;

    public ServerEula(Path file) {
        this.eulaFile = file;
        this.acceptedEULA = SharedConstants.developmentMode || this.loadEulaStatus();
    }

    private boolean loadEulaStatus() {
        boolean bl;
        block8: {
            InputStream inputstream = Files.newInputStream(this.eulaFile, new OpenOption[0]);
            try {
                Properties properties = new Properties();
                properties.load(inputstream);
                bl = Boolean.parseBoolean(properties.getProperty("eula", "false"));
                if (inputstream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOG.warn("Failed to load {}", (Object)this.eulaFile);
                    this.createEULAFile();
                    return false;
                }
            }
            inputstream.close();
        }
        return bl;
    }

    public boolean hasAcceptedEULA() {
        return this.acceptedEULA;
    }

    private void createEULAFile() {
        if (!SharedConstants.developmentMode) {
            try (OutputStream outputstream = Files.newOutputStream(this.eulaFile, new OpenOption[0]);){
                Properties properties = new Properties();
                properties.setProperty("eula", "false");
                properties.store(outputstream, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).");
            }
            catch (Exception exception) {
                LOG.warn("Failed to save {}", (Object)this.eulaFile, (Object)exception);
            }
        }
    }
}

