/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public abstract class Container {
    private final NonNullList<ItemStack> inventoryItemStacks = NonNullList.create();
    public final List<Slot> inventorySlots = Lists.newArrayList();
    private final List<IntReferenceHolder> trackedIntReferences = Lists.newArrayList();
    @Nullable
    private final ContainerType<?> containerType;
    public final int windowId;
    private short transactionID;
    private int dragMode = -1;
    private int dragEvent;
    private final Set<Slot> dragSlots = Sets.newHashSet();
    private final List<IContainerListener> listeners = Lists.newArrayList();
    private final Set<PlayerEntity> playerList = Sets.newHashSet();

    protected Container(@Nullable ContainerType<?> type, int id) {
        this.containerType = type;
        this.windowId = id;
    }

    protected static boolean isWithinUsableDistance(IWorldPosCallable worldPos, PlayerEntity playerIn, Block targetBlock) {
        return worldPos.applyOrElse((p_216960_2_, p_216960_3_) -> !p_216960_2_.getBlockState((BlockPos)p_216960_3_).isIn(targetBlock) ? false : playerIn.getDistanceSq((double)p_216960_3_.getX() + 0.5, (double)p_216960_3_.getY() + 0.5, (double)p_216960_3_.getZ() + 0.5) <= 64.0, true);
    }

    public ContainerType<?> getType() {
        if (this.containerType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.containerType;
    }

    protected static void assertInventorySize(IInventory inventoryIn, int minSize) {
        int i = inventoryIn.getSizeInventory();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }

    protected static void assertIntArraySize(IIntArray intArrayIn, int minSize) {
        int i = intArrayIn.size();
        if (i < minSize) {
            throw new IllegalArgumentException("Container data count " + i + " is smaller than expected " + minSize);
        }
    }

    protected Slot addSlot(Slot slotIn) {
        slotIn.slotNumber = this.inventorySlots.size();
        this.inventorySlots.add(slotIn);
        this.inventoryItemStacks.add(ItemStack.EMPTY);
        return slotIn;
    }

    protected IntReferenceHolder trackInt(IntReferenceHolder intIn) {
        this.trackedIntReferences.add(intIn);
        return intIn;
    }

    protected void trackIntArray(IIntArray arrayIn) {
        for (int i = 0; i < arrayIn.size(); ++i) {
            this.trackInt(IntReferenceHolder.create(arrayIn, i));
        }
    }

    public void addListener(IContainerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.sendAllContents(this, this.getInventory());
            this.detectAndSendChanges();
        }
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public NonNullList<ItemStack> getInventory() {
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            nonnulllist.add(this.inventorySlots.get(i).getStack());
        }
        return nonnulllist;
    }

    public void detectAndSendChanges() {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack itemstack = this.inventorySlots.get(i).getStack();
            ItemStack itemstack1 = this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual(itemstack1, itemstack)) continue;
            ItemStack itemstack2 = itemstack.copy();
            this.inventoryItemStacks.set(i, itemstack2);
            for (IContainerListener icontainerlistener : this.listeners) {
                icontainerlistener.sendSlotContents(this, i, itemstack2);
            }
        }
        for (int j = 0; j < this.trackedIntReferences.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.trackedIntReferences.get(j);
            if (!intreferenceholder.isDirty()) continue;
            for (IContainerListener icontainerlistener1 : this.listeners) {
                icontainerlistener1.sendWindowProperty(this, j, intreferenceholder.get());
            }
        }
    }

    public boolean enchantItem(PlayerEntity playerIn, int id) {
        return false;
    }

    public Slot getSlot(int slotId) {
        return this.inventorySlots.get(slotId);
    }

    public ItemStack transferStackInSlot(PlayerEntity playerIn, int index) {
        Slot slot = this.inventorySlots.get(index);
        return slot != null ? slot.getStack() : ItemStack.EMPTY;
    }

    public ItemStack slotClick(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        try {
            return this.func_241440_b_(slotId, dragType, clickTypeIn, player);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.makeCrashReport(exception, "Container click");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Click info");
            crashreportcategory.addDetail("Menu Type", () -> this.containerType != null ? Registry.MENU.getKey(this.containerType).toString() : "<no type>");
            crashreportcategory.addDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.addDetail("Slot Count", this.inventorySlots.size());
            crashreportcategory.addDetail("Slot", slotId);
            crashreportcategory.addDetail("Button", dragType);
            crashreportcategory.addDetail("Type", (Object)clickTypeIn);
            throw new ReportedException(crashreport);
        }
    }

    private ItemStack func_241440_b_(int p_241440_1_, int p_241440_2_, ClickType p_241440_3_, PlayerEntity p_241440_4_) {
        ItemStack itemstack = ItemStack.EMPTY;
        PlayerInventory playerinventory = p_241440_4_.inventory;
        if (p_241440_3_ == ClickType.QUICK_CRAFT) {
            int i1 = this.dragEvent;
            this.dragEvent = Container.getDragEvent(p_241440_2_);
            if ((i1 != 1 || this.dragEvent != 2) && i1 != this.dragEvent) {
                this.resetDrag();
            } else if (playerinventory.getItemStack().isEmpty()) {
                this.resetDrag();
            } else if (this.dragEvent == 0) {
                this.dragMode = Container.extractDragMode(p_241440_2_);
                if (Container.isValidDragMode(this.dragMode, p_241440_4_)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.resetDrag();
                }
            } else if (this.dragEvent == 1) {
                Slot slot7 = this.inventorySlots.get(p_241440_1_);
                ItemStack itemstack12 = playerinventory.getItemStack();
                if (slot7 != null && Container.canAddItemToSlot(slot7, itemstack12, true) && slot7.isItemValid(itemstack12) && (this.dragMode == 2 || itemstack12.getCount() > this.dragSlots.size()) && this.canDragIntoSlot(slot7)) {
                    this.dragSlots.add(slot7);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack itemstack10 = playerinventory.getItemStack().copy();
                    int k1 = playerinventory.getItemStack().getCount();
                    for (Slot slot8 : this.dragSlots) {
                        ItemStack itemstack13 = playerinventory.getItemStack();
                        if (slot8 == null || !Container.canAddItemToSlot(slot8, itemstack13, true) || !slot8.isItemValid(itemstack13) || this.dragMode != 2 && itemstack13.getCount() < this.dragSlots.size() || !this.canDragIntoSlot(slot8)) continue;
                        ItemStack itemstack14 = itemstack10.copy();
                        int j3 = slot8.getHasStack() ? slot8.getStack().getCount() : 0;
                        Container.computeStackSize(this.dragSlots, this.dragMode, itemstack14, j3);
                        int k3 = Math.min(itemstack14.getMaxStackSize(), slot8.getItemStackLimit(itemstack14));
                        if (itemstack14.getCount() > k3) {
                            itemstack14.setCount(k3);
                        }
                        k1 -= itemstack14.getCount() - j3;
                        slot8.putStack(itemstack14);
                    }
                    itemstack10.setCount(k1);
                    playerinventory.setItemStack(itemstack10);
                }
                this.resetDrag();
            } else {
                this.resetDrag();
            }
        } else if (this.dragEvent != 0) {
            this.resetDrag();
        } else if (!(p_241440_3_ != ClickType.PICKUP && p_241440_3_ != ClickType.QUICK_MOVE || p_241440_2_ != 0 && p_241440_2_ != 1)) {
            if (p_241440_1_ == -999) {
                if (!playerinventory.getItemStack().isEmpty()) {
                    if (p_241440_2_ == 0) {
                        p_241440_4_.dropItem(playerinventory.getItemStack(), true);
                        playerinventory.setItemStack(ItemStack.EMPTY);
                    }
                    if (p_241440_2_ == 1) {
                        p_241440_4_.dropItem(playerinventory.getItemStack().split(1), true);
                    }
                }
            } else if (p_241440_3_ == ClickType.QUICK_MOVE) {
                if (p_241440_1_ < 0) {
                    return ItemStack.EMPTY;
                }
                Slot slot5 = this.inventorySlots.get(p_241440_1_);
                if (slot5 == null || !slot5.canTakeStack(p_241440_4_)) {
                    return ItemStack.EMPTY;
                }
                ItemStack itemstack8 = this.transferStackInSlot(p_241440_4_, p_241440_1_);
                while (!itemstack8.isEmpty() && ItemStack.areItemsEqual(slot5.getStack(), itemstack8)) {
                    itemstack = itemstack8.copy();
                    itemstack8 = this.transferStackInSlot(p_241440_4_, p_241440_1_);
                }
            } else {
                if (p_241440_1_ < 0) {
                    return ItemStack.EMPTY;
                }
                Slot slot6 = this.inventorySlots.get(p_241440_1_);
                if (slot6 != null) {
                    ItemStack itemstack9 = slot6.getStack();
                    ItemStack itemstack11 = playerinventory.getItemStack();
                    if (!itemstack9.isEmpty()) {
                        itemstack = itemstack9.copy();
                    }
                    if (itemstack9.isEmpty()) {
                        if (!itemstack11.isEmpty() && slot6.isItemValid(itemstack11)) {
                            int j2;
                            int n = j2 = p_241440_2_ == 0 ? itemstack11.getCount() : 1;
                            if (j2 > slot6.getItemStackLimit(itemstack11)) {
                                j2 = slot6.getItemStackLimit(itemstack11);
                            }
                            slot6.putStack(itemstack11.split(j2));
                        }
                    } else if (slot6.canTakeStack(p_241440_4_)) {
                        int i3;
                        if (itemstack11.isEmpty()) {
                            if (itemstack9.isEmpty()) {
                                slot6.putStack(ItemStack.EMPTY);
                                playerinventory.setItemStack(ItemStack.EMPTY);
                            } else {
                                int k2 = p_241440_2_ == 0 ? itemstack9.getCount() : (itemstack9.getCount() + 1) / 2;
                                playerinventory.setItemStack(slot6.decrStackSize(k2));
                                if (itemstack9.isEmpty()) {
                                    slot6.putStack(ItemStack.EMPTY);
                                }
                                slot6.onTake(p_241440_4_, playerinventory.getItemStack());
                            }
                        } else if (slot6.isItemValid(itemstack11)) {
                            if (Container.areItemsAndTagsEqual(itemstack9, itemstack11)) {
                                int l2;
                                int n = l2 = p_241440_2_ == 0 ? itemstack11.getCount() : 1;
                                if (l2 > slot6.getItemStackLimit(itemstack11) - itemstack9.getCount()) {
                                    l2 = slot6.getItemStackLimit(itemstack11) - itemstack9.getCount();
                                }
                                if (l2 > itemstack11.getMaxStackSize() - itemstack9.getCount()) {
                                    l2 = itemstack11.getMaxStackSize() - itemstack9.getCount();
                                }
                                itemstack11.shrink(l2);
                                itemstack9.grow(l2);
                            } else if (itemstack11.getCount() <= slot6.getItemStackLimit(itemstack11)) {
                                slot6.putStack(itemstack11);
                                playerinventory.setItemStack(itemstack9);
                            }
                        } else if (itemstack11.getMaxStackSize() > 1 && Container.areItemsAndTagsEqual(itemstack9, itemstack11) && !itemstack9.isEmpty() && (i3 = itemstack9.getCount()) + itemstack11.getCount() <= itemstack11.getMaxStackSize()) {
                            itemstack11.grow(i3);
                            itemstack9 = slot6.decrStackSize(i3);
                            if (itemstack9.isEmpty()) {
                                slot6.putStack(ItemStack.EMPTY);
                            }
                            slot6.onTake(p_241440_4_, playerinventory.getItemStack());
                        }
                    }
                    slot6.onSlotChanged();
                }
            }
        } else if (p_241440_3_ == ClickType.SWAP) {
            Slot slot = this.inventorySlots.get(p_241440_1_);
            ItemStack itemstack1 = playerinventory.getStackInSlot(p_241440_2_);
            ItemStack itemstack2 = slot.getStack();
            if (!itemstack1.isEmpty() || !itemstack2.isEmpty()) {
                if (itemstack1.isEmpty()) {
                    if (slot.canTakeStack(p_241440_4_)) {
                        playerinventory.setInventorySlotContents(p_241440_2_, itemstack2);
                        slot.onSwapCraft(itemstack2.getCount());
                        slot.putStack(ItemStack.EMPTY);
                        slot.onTake(p_241440_4_, itemstack2);
                    }
                } else if (itemstack2.isEmpty()) {
                    if (slot.isItemValid(itemstack1)) {
                        int i = slot.getItemStackLimit(itemstack1);
                        if (itemstack1.getCount() > i) {
                            slot.putStack(itemstack1.split(i));
                        } else {
                            slot.putStack(itemstack1);
                            playerinventory.setInventorySlotContents(p_241440_2_, ItemStack.EMPTY);
                        }
                    }
                } else if (slot.canTakeStack(p_241440_4_) && slot.isItemValid(itemstack1)) {
                    int l1 = slot.getItemStackLimit(itemstack1);
                    if (itemstack1.getCount() > l1) {
                        slot.putStack(itemstack1.split(l1));
                        slot.onTake(p_241440_4_, itemstack2);
                        if (!playerinventory.addItemStackToInventory(itemstack2)) {
                            p_241440_4_.dropItem(itemstack2, true);
                        }
                    } else {
                        slot.putStack(itemstack1);
                        playerinventory.setInventorySlotContents(p_241440_2_, itemstack2);
                        slot.onTake(p_241440_4_, itemstack2);
                    }
                }
            }
        } else if (p_241440_3_ == ClickType.CLONE && p_241440_4_.abilities.isCreativeMode && playerinventory.getItemStack().isEmpty() && p_241440_1_ >= 0) {
            Slot slot4 = this.inventorySlots.get(p_241440_1_);
            if (slot4 != null && slot4.getHasStack()) {
                ItemStack itemstack7 = slot4.getStack().copy();
                itemstack7.setCount(itemstack7.getMaxStackSize());
                playerinventory.setItemStack(itemstack7);
            }
        } else if (p_241440_3_ == ClickType.THROW && playerinventory.getItemStack().isEmpty() && p_241440_1_ >= 0) {
            Slot slot3 = this.inventorySlots.get(p_241440_1_);
            if (slot3 != null && slot3.getHasStack() && slot3.canTakeStack(p_241440_4_)) {
                ItemStack itemstack6 = slot3.decrStackSize(p_241440_2_ == 0 ? 1 : slot3.getStack().getCount());
                slot3.onTake(p_241440_4_, itemstack6);
                p_241440_4_.dropItem(itemstack6, true);
            }
        } else if (p_241440_3_ == ClickType.PICKUP_ALL && p_241440_1_ >= 0) {
            Slot slot2 = this.inventorySlots.get(p_241440_1_);
            ItemStack itemstack5 = playerinventory.getItemStack();
            if (!(itemstack5.isEmpty() || slot2 != null && slot2.getHasStack() && slot2.canTakeStack(p_241440_4_))) {
                int j1 = p_241440_2_ == 0 ? 0 : this.inventorySlots.size() - 1;
                int i2 = p_241440_2_ == 0 ? 1 : -1;
                for (int j = 0; j < 2; ++j) {
                    for (int k = j1; k >= 0 && k < this.inventorySlots.size() && itemstack5.getCount() < itemstack5.getMaxStackSize(); k += i2) {
                        Slot slot1 = this.inventorySlots.get(k);
                        if (!slot1.getHasStack() || !Container.canAddItemToSlot(slot1, itemstack5, true) || !slot1.canTakeStack(p_241440_4_) || !this.canMergeSlot(itemstack5, slot1)) continue;
                        ItemStack itemstack3 = slot1.getStack();
                        if (j == 0 && itemstack3.getCount() == itemstack3.getMaxStackSize()) continue;
                        int l = Math.min(itemstack5.getMaxStackSize() - itemstack5.getCount(), itemstack3.getCount());
                        ItemStack itemstack4 = slot1.decrStackSize(l);
                        itemstack5.grow(l);
                        if (itemstack4.isEmpty()) {
                            slot1.putStack(ItemStack.EMPTY);
                        }
                        slot1.onTake(p_241440_4_, itemstack4);
                    }
                }
            }
            this.detectAndSendChanges();
        }
        return itemstack;
    }

    public static boolean areItemsAndTagsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && ItemStack.areItemStackTagsEqual(stack1, stack2);
    }

    public boolean canMergeSlot(ItemStack stack, Slot slotIn) {
        return true;
    }

    public void onContainerClosed(PlayerEntity playerIn) {
        PlayerInventory playerinventory = playerIn.inventory;
        if (!playerinventory.getItemStack().isEmpty()) {
            playerIn.dropItem(playerinventory.getItemStack(), false);
            playerinventory.setItemStack(ItemStack.EMPTY);
        }
    }

    protected void clearContainer(PlayerEntity playerIn, World worldIn, IInventory inventoryIn) {
        if (!playerIn.isAlive() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).hasDisconnected()) {
            for (int j = 0; j < inventoryIn.getSizeInventory(); ++j) {
                playerIn.dropItem(inventoryIn.removeStackFromSlot(j), false);
            }
        } else {
            for (int i = 0; i < inventoryIn.getSizeInventory(); ++i) {
                playerIn.inventory.placeItemBackInInventory(worldIn, inventoryIn.removeStackFromSlot(i));
            }
        }
    }

    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.detectAndSendChanges();
    }

    public void putStackInSlot(int slotID, ItemStack stack) {
        this.getSlot(slotID).putStack(stack);
    }

    public void setAll(List<ItemStack> p_190896_1_) {
        for (int i = 0; i < p_190896_1_.size(); ++i) {
            this.getSlot(i).putStack(p_190896_1_.get(i));
        }
    }

    public void updateProgressBar(int id, int data) {
        this.trackedIntReferences.get(id).set(data);
    }

    public short getNextTransactionID(PlayerInventory invPlayer) {
        this.transactionID = (short)(this.transactionID + 1);
        return this.transactionID;
    }

    public boolean getCanCraft(PlayerEntity player) {
        return !this.playerList.contains(player);
    }

    public void setCanCraft(PlayerEntity player, boolean canCraft) {
        if (canCraft) {
            this.playerList.remove(player);
        } else {
            this.playerList.add(player);
        }
    }

    public abstract boolean canInteractWith(PlayerEntity var1);

    protected boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = this.inventorySlots.get(i);
                ItemStack itemstack = slot.getStack();
                if (!itemstack.isEmpty() && Container.areItemsAndTagsEqual(stack, itemstack)) {
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.onSlotChanged();
                        flag = true;
                    } else if (itemstack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemstack.getCount());
                        itemstack.setCount(stack.getMaxStackSize());
                        slot.onSlotChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = this.inventorySlots.get(i);
                ItemStack itemstack1 = slot1.getStack();
                if (itemstack1.isEmpty() && slot1.isItemValid(stack)) {
                    if (stack.getCount() > slot1.getSlotStackLimit()) {
                        slot1.putStack(stack.split(slot1.getSlotStackLimit()));
                    } else {
                        slot1.putStack(stack.split(stack.getCount()));
                    }
                    slot1.onSlotChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int extractDragMode(int eventButton) {
        return eventButton >> 2 & 3;
    }

    public static int getDragEvent(int clickedButton) {
        return clickedButton & 3;
    }

    public static int getQuickcraftMask(int p_94534_0_, int p_94534_1_) {
        return p_94534_0_ & 3 | (p_94534_1_ & 3) << 2;
    }

    public static boolean isValidDragMode(int dragModeIn, PlayerEntity player) {
        if (dragModeIn == 0) {
            return true;
        }
        if (dragModeIn == 1) {
            return true;
        }
        return dragModeIn == 2 && player.abilities.isCreativeMode;
    }

    protected void resetDrag() {
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    public static boolean canAddItemToSlot(@Nullable Slot slotIn, ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slotIn == null || !slotIn.getHasStack();
        if (!flag && stack.isItemEqual(slotIn.getStack()) && ItemStack.areItemStackTagsEqual(slotIn.getStack(), stack)) {
            return slotIn.getStack().getCount() + (stackSizeMatters ? 0 : stack.getCount()) <= stack.getMaxStackSize();
        }
        return flag;
    }

    public static void computeStackSize(Set<Slot> dragSlotsIn, int dragModeIn, ItemStack stack, int slotStackSize) {
        switch (dragModeIn) {
            case 0: {
                stack.setCount(MathHelper.floor((float)stack.getCount() / (float)dragSlotsIn.size()));
                break;
            }
            case 1: {
                stack.setCount(1);
                break;
            }
            case 2: {
                stack.setCount(stack.getItem().getMaxStackSize());
            }
        }
        stack.grow(slotStackSize);
    }

    public boolean canDragIntoSlot(Slot slotIn) {
        return true;
    }

    public static int calcRedstone(@Nullable TileEntity te) {
        return te instanceof IInventory ? Container.calcRedstoneFromInventory((IInventory)((Object)te)) : 0;
    }

    public static int calcRedstoneFromInventory(@Nullable IInventory inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSizeInventory(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(inv.getInventoryStackLimit(), itemstack.getMaxStackSize());
            ++i;
        }
        return MathHelper.floor((f /= (float)inv.getSizeInventory()) * 14.0f) + (i > 0 ? 1 : 0);
    }
}

