/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class AttackStrafingTask<E extends MobEntity>
extends Task<E> {
    private final int distance;
    private final float speed;

    public AttackStrafingTask(int distance, float speed) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT), MemoryModuleType.VISIBLE_MOBS, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)));
        this.distance = distance;
        this.speed = speed;
    }

    @Override
    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        return this.hasSeen(owner) && this.isTargetWithinDistance(owner);
    }

    @Override
    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        ((LivingEntity)entityIn).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityPosWrapper(this.getAttackTarget(entityIn), true));
        ((MobEntity)entityIn).getMoveHelper().strafe(-this.speed, 0.0f);
        ((MobEntity)entityIn).rotationYaw = MathHelper.func_219800_b(((MobEntity)entityIn).rotationYaw, ((MobEntity)entityIn).rotationYawHead, 0.0f);
    }

    private boolean hasSeen(E mob) {
        return ((LivingEntity)mob).getBrain().getMemory(MemoryModuleType.VISIBLE_MOBS).get().contains(this.getAttackTarget(mob));
    }

    private boolean isTargetWithinDistance(E mob) {
        return this.getAttackTarget(mob).isEntityInRange((Entity)mob, this.distance);
    }

    private LivingEntity getAttackTarget(E mob) {
        return ((LivingEntity)mob).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

