/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.schedule;

import net.minecraft.util.registry.Registry;

public class Activity {
    public static final Activity CORE = Activity.register("core");
    public static final Activity IDLE = Activity.register("idle");
    public static final Activity WORK = Activity.register("work");
    public static final Activity PLAY = Activity.register("play");
    public static final Activity REST = Activity.register("rest");
    public static final Activity MEET = Activity.register("meet");
    public static final Activity PANIC = Activity.register("panic");
    public static final Activity RAID = Activity.register("raid");
    public static final Activity PRE_RAID = Activity.register("pre_raid");
    public static final Activity HIDE = Activity.register("hide");
    public static final Activity FIGHT = Activity.register("fight");
    public static final Activity CELEBRATE = Activity.register("celebrate");
    public static final Activity ADMIRE_ITEM = Activity.register("admire_item");
    public static final Activity AVOID = Activity.register("avoid");
    public static final Activity RIDE = Activity.register("ride");
    private final String id;
    private final int hash;

    private Activity(String key) {
        this.id = key;
        this.hash = key.hashCode();
    }

    public String getKey() {
        return this.id;
    }

    private static Activity register(String key) {
        return Registry.register(Registry.ACTIVITY, key, new Activity(key));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            Activity activity = (Activity)p_equals_1_;
            return this.id.equals(activity.id);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getKey();
    }
}

