/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalEntityTypeAttributes {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<EntityType<? extends LivingEntity>, AttributeModifierMap> VANILLA_ATTRIBUTES = ImmutableMap.builder().put(EntityType.ARMOR_STAND, (Object)LivingEntity.registerAttributes().create()).put(EntityType.BAT, (Object)BatEntity.func_234175_m_().create()).put(EntityType.BEE, (Object)BeeEntity.func_234182_eX_().create()).put(EntityType.BLAZE, (Object)BlazeEntity.registerAttributes().create()).put(EntityType.CAT, (Object)CatEntity.func_234184_eY_().create()).put(EntityType.CAVE_SPIDER, (Object)CaveSpiderEntity.registerAttributes().create()).put(EntityType.CHICKEN, (Object)ChickenEntity.func_234187_eI_().create()).put(EntityType.COD, (Object)AbstractFishEntity.func_234176_m_().create()).put(EntityType.COW, (Object)CowEntity.func_234188_eI_().create()).put(EntityType.CREEPER, (Object)CreeperEntity.registerAttributes().create()).put(EntityType.DOLPHIN, (Object)DolphinEntity.func_234190_eK_().create()).put(EntityType.DONKEY, (Object)AbstractChestedHorseEntity.func_234234_eJ_().create()).put(EntityType.DROWNED, (Object)ZombieEntity.func_234342_eQ_().create()).put(EntityType.ELDER_GUARDIAN, (Object)ElderGuardianEntity.func_234283_m_().create()).put(EntityType.ENDERMAN, (Object)EndermanEntity.func_234287_m_().create()).put(EntityType.ENDERMITE, (Object)EndermiteEntity.func_234288_m_().create()).put(EntityType.ENDER_DRAGON, (Object)EnderDragonEntity.registerAttributes().create()).put(EntityType.EVOKER, (Object)EvokerEntity.func_234289_eI_().create()).put(EntityType.FOX, (Object)FoxEntity.func_234192_eI_().create()).put(EntityType.GHAST, (Object)GhastEntity.func_234290_eH_().create()).put(EntityType.GIANT, (Object)GiantEntity.func_234291_m_().create()).put(EntityType.GUARDIAN, (Object)GuardianEntity.func_234292_eK_().create()).put(EntityType.HOGLIN, (Object)HoglinEntity.func_234362_eI_().create()).put(EntityType.HORSE, (Object)AbstractHorseEntity.func_234237_fg_().create()).put(EntityType.HUSK, (Object)ZombieEntity.func_234342_eQ_().create()).put(EntityType.ILLUSIONER, (Object)IllusionerEntity.func_234293_eI_().create()).put(EntityType.IRON_GOLEM, (Object)IronGolemEntity.func_234200_m_().create()).put(EntityType.LLAMA, (Object)LlamaEntity.func_234244_fu_().create()).put(EntityType.MAGMA_CUBE, (Object)MagmaCubeEntity.func_234294_m_().create()).put(EntityType.MOOSHROOM, (Object)CowEntity.func_234188_eI_().create()).put(EntityType.MULE, (Object)AbstractChestedHorseEntity.func_234234_eJ_().create()).put(EntityType.OCELOT, (Object)OcelotEntity.func_234201_eI_().create()).put(EntityType.PANDA, (Object)PandaEntity.func_234204_eW_().create()).put(EntityType.PARROT, (Object)ParrotEntity.func_234213_eS_().create()).put(EntityType.PHANTOM, (Object)MonsterEntity.func_234295_eP_().create()).put(EntityType.PIG, (Object)PigEntity.func_234215_eI_().create()).put(EntityType.PIGLIN, (Object)PiglinEntity.func_234420_eI_().create()).put(EntityType.field_242287_aj, (Object)PiglinBruteEntity.func_242344_eS().create()).put(EntityType.PILLAGER, (Object)PillagerEntity.func_234296_eI_().create()).put(EntityType.PLAYER, (Object)PlayerEntity.func_234570_el_().create()).put(EntityType.POLAR_BEAR, (Object)PolarBearEntity.func_234219_eI_().create()).put(EntityType.PUFFERFISH, (Object)AbstractFishEntity.func_234176_m_().create()).put(EntityType.RABBIT, (Object)RabbitEntity.func_234224_eJ_().create()).put(EntityType.RAVAGER, (Object)RavagerEntity.func_234297_m_().create()).put(EntityType.SALMON, (Object)AbstractFishEntity.func_234176_m_().create()).put(EntityType.SHEEP, (Object)SheepEntity.func_234225_eI_().create()).put(EntityType.SHULKER, (Object)ShulkerEntity.func_234300_m_().create()).put(EntityType.SILVERFISH, (Object)SilverfishEntity.func_234301_m_().create()).put(EntityType.SKELETON, (Object)AbstractSkeletonEntity.registerAttributes().create()).put(EntityType.SKELETON_HORSE, (Object)SkeletonHorseEntity.func_234250_eJ_().create()).put(EntityType.SLIME, (Object)MonsterEntity.func_234295_eP_().create()).put(EntityType.SNOW_GOLEM, (Object)SnowGolemEntity.func_234226_m_().create()).put(EntityType.SPIDER, (Object)SpiderEntity.func_234305_eI_().create()).put(EntityType.SQUID, (Object)SquidEntity.func_234227_m_().create()).put(EntityType.STRAY, (Object)AbstractSkeletonEntity.registerAttributes().create()).put(EntityType.STRIDER, (Object)StriderEntity.func_234317_eK_().create()).put(EntityType.TRADER_LLAMA, (Object)LlamaEntity.func_234244_fu_().create()).put(EntityType.TROPICAL_FISH, (Object)AbstractFishEntity.func_234176_m_().create()).put(EntityType.TURTLE, (Object)TurtleEntity.func_234228_eK_().create()).put(EntityType.VEX, (Object)VexEntity.func_234321_m_().create()).put(EntityType.VILLAGER, (Object)VillagerEntity.registerAttributes().create()).put(EntityType.VINDICATOR, (Object)VindicatorEntity.func_234322_eI_().create()).put(EntityType.WANDERING_TRADER, (Object)MobEntity.func_233666_p_().create()).put(EntityType.WITCH, (Object)WitchEntity.func_234323_eI_().create()).put(EntityType.WITHER, (Object)WitherEntity.registerAttributes().create()).put(EntityType.WITHER_SKELETON, (Object)AbstractSkeletonEntity.registerAttributes().create()).put(EntityType.WOLF, (Object)WolfEntity.func_234233_eS_().create()).put(EntityType.ZOGLIN, (Object)ZoglinEntity.func_234339_m_().create()).put(EntityType.ZOMBIE, (Object)ZombieEntity.func_234342_eQ_().create()).put(EntityType.ZOMBIE_HORSE, (Object)ZombieHorseEntity.func_234256_eJ_().create()).put(EntityType.ZOMBIE_VILLAGER, (Object)ZombieEntity.func_234342_eQ_().create()).put(EntityType.ZOMBIFIED_PIGLIN, (Object)ZombifiedPiglinEntity.func_234352_eU_().create()).build();

    public static AttributeModifierMap getAttributesForEntity(EntityType<? extends LivingEntity> livingEntity) {
        return VANILLA_ATTRIBUTES.get(livingEntity);
    }

    public static boolean doesEntityHaveAttributes(EntityType<?> entityType) {
        return VANILLA_ATTRIBUTES.containsKey(entityType);
    }

    public static void validateEntityAttributes() {
        Registry.ENTITY_TYPE.stream().filter(entityType -> entityType.getClassification() != EntityClassification.MISC).filter(entityType -> !GlobalEntityTypeAttributes.doesEntityHaveAttributes(entityType)).map(Registry.ENTITY_TYPE::getKey).forEach(entityId -> {
            if (SharedConstants.developmentMode) {
                throw new IllegalStateException("Entity " + String.valueOf(entityId) + " has no attributes");
            }
            LOGGER.error("Entity {} has no attributes", entityId);
        });
    }
}

