/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.registry.Registry;

public class AttributeModifierMap {
    private final Map<Attribute, ModifiableAttributeInstance> attributeMap;

    public AttributeModifierMap(Map<Attribute, ModifiableAttributeInstance> attributeMap) {
        this.attributeMap = ImmutableMap.copyOf(attributeMap);
    }

    private ModifiableAttributeInstance getModifier(Attribute attribute) {
        ModifiableAttributeInstance modifiableattributeinstance = this.attributeMap.get(attribute);
        if (modifiableattributeinstance == null) {
            throw new IllegalArgumentException("Can't find attribute " + String.valueOf(Registry.ATTRIBUTE.getKey(attribute)));
        }
        return modifiableattributeinstance;
    }

    public double getAttributeValue(Attribute attribute) {
        return this.getModifier(attribute).getValue();
    }

    public double getAttributeBaseValue(Attribute attribute) {
        return this.getModifier(attribute).getBaseValue();
    }

    public double getAttributeModifierValue(Attribute attribute, UUID id) {
        AttributeModifier attributemodifier = this.getModifier(attribute).getModifier(id);
        if (attributemodifier == null) {
            throw new IllegalArgumentException("Can't find modifier " + String.valueOf(id) + " on attribute " + String.valueOf(Registry.ATTRIBUTE.getKey(attribute)));
        }
        return attributemodifier.getAmount();
    }

    @Nullable
    public ModifiableAttributeInstance createImmutableAttributeInstance(Consumer<ModifiableAttributeInstance> onChangedCallback, Attribute attribute) {
        ModifiableAttributeInstance modifiableattributeinstance = this.attributeMap.get(attribute);
        if (modifiableattributeinstance == null) {
            return null;
        }
        ModifiableAttributeInstance modifiableattributeinstance1 = new ModifiableAttributeInstance(attribute, onChangedCallback);
        modifiableattributeinstance1.copyValuesFromInstance(modifiableattributeinstance);
        return modifiableattributeinstance1;
    }

    public static MutableAttribute createMutableAttribute() {
        return new MutableAttribute();
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributeMap.containsKey(attribute);
    }

    public boolean hasModifier(Attribute attribute, UUID id) {
        ModifiableAttributeInstance modifiableattributeinstance = this.attributeMap.get(attribute);
        return modifiableattributeinstance != null && modifiableattributeinstance.getModifier(id) != null;
    }

    public static class MutableAttribute {
        private final Map<Attribute, ModifiableAttributeInstance> attributeMap = Maps.newHashMap();
        private boolean edited;

        private ModifiableAttributeInstance createAttributeInstance(Attribute attribute) {
            ModifiableAttributeInstance modifiableattributeinstance = new ModifiableAttributeInstance(attribute, modifiableInstance -> {
                if (this.edited) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + String.valueOf(Registry.ATTRIBUTE.getKey(attribute)));
                }
            });
            this.attributeMap.put(attribute, modifiableattributeinstance);
            return modifiableattributeinstance;
        }

        public MutableAttribute createMutableAttribute(Attribute attribute) {
            this.createAttributeInstance(attribute);
            return this;
        }

        public MutableAttribute createMutableAttribute(Attribute attribute, double value) {
            ModifiableAttributeInstance modifiableattributeinstance = this.createAttributeInstance(attribute);
            modifiableattributeinstance.setBaseValue(value);
            return this;
        }

        public AttributeModifierMap create() {
            this.edited = true;
            return new AttributeModifierMap(this.attributeMap);
        }
    }
}

