/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;

public class ProtectionEnchantment
extends Enchantment {
    public final Type protectionType;

    public ProtectionEnchantment(Enchantment.Rarity rarityIn, Type protectionTypeIn, EquipmentSlotType ... slots) {
        super(rarityIn, protectionTypeIn == Type.FALL ? EnchantmentType.ARMOR_FEET : EnchantmentType.ARMOR, slots);
        this.protectionType = protectionTypeIn;
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return this.protectionType.getMinimalEnchantability() + (enchantmentLevel - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + this.protectionType.getEnchantIncreasePerLevel();
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int calcModifierDamage(int level, DamageSource source) {
        if (source.canHarmInCreative()) {
            return 0;
        }
        if (this.protectionType == Type.ALL) {
            return level;
        }
        if (this.protectionType == Type.FIRE && source.isFireDamage()) {
            return level * 2;
        }
        if (this.protectionType == Type.FALL && source == DamageSource.FALL) {
            return level * 3;
        }
        if (this.protectionType == Type.EXPLOSION && source.isExplosion()) {
            return level * 2;
        }
        return this.protectionType == Type.PROJECTILE && source.isProjectile() ? level * 2 : 0;
    }

    @Override
    public boolean canApplyTogether(Enchantment ench) {
        if (ench instanceof ProtectionEnchantment) {
            ProtectionEnchantment protectionenchantment = (ProtectionEnchantment)ench;
            if (this.protectionType == protectionenchantment.protectionType) {
                return false;
            }
            return this.protectionType == Type.FALL || protectionenchantment.protectionType == Type.FALL;
        }
        return super.canApplyTogether(ench);
    }

    public static int getFireTimeForEntity(LivingEntity livingEntity, int level) {
        int i = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.FIRE_PROTECTION, livingEntity);
        if (i > 0) {
            level -= MathHelper.floor((float)level * (float)i * 0.15f);
        }
        return level;
    }

    public static double getBlastDamageReduction(LivingEntity entityLivingBaseIn, double damage) {
        int i = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.BLAST_PROTECTION, entityLivingBaseIn);
        if (i > 0) {
            damage -= (double)MathHelper.floor(damage * (double)((float)i * 0.15f));
        }
        return damage;
    }

    public static enum Type {
        ALL("all", 1, 11),
        FIRE("fire", 10, 8),
        FALL("fall", 5, 6),
        EXPLOSION("explosion", 5, 8),
        PROJECTILE("projectile", 3, 6);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;

        private Type(String typeName, int minEnchantability, int levelCost) {
            this.typeName = typeName;
            this.minEnchantability = minEnchantability;
            this.levelCost = levelCost;
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }
    }
}

