/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl.data;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.command.impl.data.IDataAccessor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockDataAccessor
implements IDataAccessor {
    private static final SimpleCommandExceptionType DATA_BLOCK_INVALID_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.data.block.invalid"));
    public static final Function<String, DataCommand.IDataProvider> DATA_PROVIDER = p_218923_0_ -> new DataCommand.IDataProvider((String)p_218923_0_){
        final /* synthetic */ String val$p_218923_0_;
        {
            this.val$p_218923_0_ = string;
        }

        @Override
        public IDataAccessor createAccessor(CommandContext<CommandSource> context) throws CommandSyntaxException {
            BlockPos blockpos = BlockPosArgument.getLoadedBlockPos(context, this.val$p_218923_0_ + "Pos");
            TileEntity tileentity = ((CommandSource)context.getSource()).getWorld().getTileEntity(blockpos);
            if (tileentity == null) {
                throw DATA_BLOCK_INVALID_EXCEPTION.create();
            }
            return new BlockDataAccessor(tileentity, blockpos);
        }

        @Override
        public ArgumentBuilder<CommandSource, ?> createArgument(ArgumentBuilder<CommandSource, ?> builder, Function<ArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> action) {
            return builder.then(Commands.literal("block").then(action.apply((ArgumentBuilder<CommandSource, ?>)Commands.argument(this.val$p_218923_0_ + "Pos", BlockPosArgument.blockPos()))));
        }
    };
    private final TileEntity tileEntity;
    private final BlockPos pos;

    public BlockDataAccessor(TileEntity tileEntityIn, BlockPos posIn) {
        this.tileEntity = tileEntityIn;
        this.pos = posIn;
    }

    @Override
    public void mergeData(CompoundNBT other) {
        other.putInt("x", this.pos.getX());
        other.putInt("y", this.pos.getY());
        other.putInt("z", this.pos.getZ());
        BlockState blockstate = this.tileEntity.getWorld().getBlockState(this.pos);
        this.tileEntity.read(blockstate, other);
        this.tileEntity.markDirty();
        this.tileEntity.getWorld().notifyBlockUpdate(this.pos, blockstate, blockstate, 3);
    }

    @Override
    public CompoundNBT getData() {
        return this.tileEntity.write(new CompoundNBT());
    }

    @Override
    public ITextComponent getModifiedMessage() {
        return new TranslationTextComponent("commands.data.block.modified", this.pos.getX(), this.pos.getY(), this.pos.getZ());
    }

    @Override
    public ITextComponent getQueryMessage(INBT nbt) {
        return new TranslationTextComponent("commands.data.block.query", this.pos.getX(), this.pos.getY(), this.pos.getZ(), nbt.toFormattedComponent());
    }

    @Override
    public ITextComponent getGetMessage(NBTPathArgument.NBTPath pathIn, double scale, int value) {
        return new TranslationTextComponent("commands.data.block.get", pathIn, this.pos.getX(), this.pos.getY(), this.pos.getZ(), String.format(Locale.ROOT, "%.2f", scale), value);
    }
}

