/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SaveOnCommand {
    private static final SimpleCommandExceptionType SAVE_ALREADY_ON_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.save.alreadyOn"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("save-on").requires(p_198623_0_ -> p_198623_0_.hasPermissionLevel(4))).executes(p_198622_0_ -> {
            CommandSource commandsource = (CommandSource)p_198622_0_.getSource();
            boolean flag = false;
            for (ServerWorld serverworld : commandsource.getServer().getWorlds()) {
                if (serverworld == null || !serverworld.disableLevelSaving) continue;
                serverworld.disableLevelSaving = false;
                flag = true;
            }
            if (!flag) {
                throw SAVE_ALREADY_ON_EXCEPTION.create();
            }
            commandsource.sendFeedback(new TranslationTextComponent("commands.save.enabled"), true);
            return 1;
        }));
    }
}

