/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.SlotArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;

public class ReplaceItemCommand {
    public static final SimpleCommandExceptionType BLOCK_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.replaceitem.block.failed"));
    public static final DynamicCommandExceptionType INAPPLICABLE_SLOT_EXCEPTION = new DynamicCommandExceptionType(p_211409_0_ -> new TranslationTextComponent("commands.replaceitem.slot.inapplicable", p_211409_0_));
    public static final Dynamic2CommandExceptionType ENTITY_FAILED_EXCEPTION = new Dynamic2CommandExceptionType((p_211411_0_, p_211411_1_) -> new TranslationTextComponent("commands.replaceitem.entity.failed", p_211411_0_, p_211411_1_));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("replaceitem").requires(p_198607_0_ -> p_198607_0_.hasPermissionLevel(2))).then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(Commands.argument("slot", SlotArgument.slot()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item()).executes(p_198601_0_ -> ReplaceItemCommand.replaceItemBlock((CommandSource)p_198601_0_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSource>)p_198601_0_, "pos"), SlotArgument.getSlot((CommandContext<CommandSource>)p_198601_0_, "slot"), ItemArgument.getItem(p_198601_0_, "item").createStack(1, false)))).then(Commands.argument("count", IntegerArgumentType.integer((int)1, (int)64)).executes(p_198605_0_ -> ReplaceItemCommand.replaceItemBlock((CommandSource)p_198605_0_.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSource>)p_198605_0_, "pos"), SlotArgument.getSlot((CommandContext<CommandSource>)p_198605_0_, "slot"), ItemArgument.getItem(p_198605_0_, "item").createStack(IntegerArgumentType.getInteger((CommandContext)p_198605_0_, (String)"count"), true))))))))).then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("slot", SlotArgument.slot()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item()).executes(p_198600_0_ -> ReplaceItemCommand.replaceItemEntities((CommandSource)p_198600_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198600_0_, "targets"), SlotArgument.getSlot((CommandContext<CommandSource>)p_198600_0_, "slot"), ItemArgument.getItem(p_198600_0_, "item").createStack(1, false)))).then(Commands.argument("count", IntegerArgumentType.integer((int)1, (int)64)).executes(p_198606_0_ -> ReplaceItemCommand.replaceItemEntities((CommandSource)p_198606_0_.getSource(), EntityArgument.getEntities((CommandContext<CommandSource>)p_198606_0_, "targets"), SlotArgument.getSlot((CommandContext<CommandSource>)p_198606_0_, "slot"), ItemArgument.getItem(p_198606_0_, "item").createStack(IntegerArgumentType.getInteger((CommandContext)p_198606_0_, (String)"count"), true)))))))));
    }

    private static int replaceItemBlock(CommandSource source, BlockPos pos, int slotIn, ItemStack newStack) throws CommandSyntaxException {
        TileEntity tileentity = source.getWorld().getTileEntity(pos);
        if (!(tileentity instanceof IInventory)) {
            throw BLOCK_FAILED_EXCEPTION.create();
        }
        IInventory iinventory = (IInventory)((Object)tileentity);
        if (slotIn >= 0 && slotIn < iinventory.getSizeInventory()) {
            iinventory.setInventorySlotContents(slotIn, newStack);
            source.sendFeedback(new TranslationTextComponent("commands.replaceitem.block.success", pos.getX(), pos.getY(), pos.getZ(), newStack.getTextComponent()), true);
            return 1;
        }
        throw INAPPLICABLE_SLOT_EXCEPTION.create((Object)slotIn);
    }

    private static int replaceItemEntities(CommandSource source, Collection<? extends Entity> targets, int slotIn, ItemStack newStack) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)targets.size());
        for (Entity entity : targets) {
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).container.detectAndSendChanges();
            }
            if (!entity.replaceItemInInventory(slotIn, newStack.copy())) continue;
            list.add(entity);
            if (!(entity instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)entity).container.detectAndSendChanges();
        }
        if (list.isEmpty()) {
            throw ENTITY_FAILED_EXCEPTION.create((Object)newStack.getTextComponent(), (Object)slotIn);
        }
        if (list.size() == 1) {
            source.sendFeedback(new TranslationTextComponent("commands.replaceitem.entity.success.single", ((Entity)list.iterator().next()).getDisplayName(), newStack.getTextComponent()), true);
        } else {
            source.sendFeedback(new TranslationTextComponent("commands.replaceitem.entity.success.multiple", list.size(), newStack.getTextComponent()), true);
        }
        return list.size();
    }
}

