/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BedTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.CampfireTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndGatewayTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.LecternTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.MobSpawnerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.PistonTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ShulkerBoxTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.optifine.EmissiveTextures;

public class TileEntityRendererDispatcher {
    public final Map<TileEntityType<?>, TileEntityRenderer<?>> renderers = Maps.newHashMap();
    public static final TileEntityRendererDispatcher instance = new TileEntityRendererDispatcher();
    private final BufferBuilder fixedRenderBuffer = new BufferBuilder(256);
    private FontRenderer fontRenderer;
    public TextureManager textureManager;
    public World world;
    public ActiveRenderInfo renderInfo;
    public RayTraceResult cameraHitResult;
    public TileEntity tileEntityRendered;

    private TileEntityRendererDispatcher() {
        this.register(TileEntityType.SIGN, new SignTileEntityRenderer(this));
        this.register(TileEntityType.MOB_SPAWNER, new MobSpawnerTileEntityRenderer(this));
        this.register(TileEntityType.PISTON, new PistonTileEntityRenderer(this));
        this.register(TileEntityType.CHEST, new ChestTileEntityRenderer(this));
        this.register(TileEntityType.ENDER_CHEST, new ChestTileEntityRenderer(this));
        this.register(TileEntityType.TRAPPED_CHEST, new ChestTileEntityRenderer(this));
        this.register(TileEntityType.ENCHANTING_TABLE, new EnchantmentTableTileEntityRenderer(this));
        this.register(TileEntityType.LECTERN, new LecternTileEntityRenderer(this));
        this.register(TileEntityType.END_PORTAL, new EndPortalTileEntityRenderer(this));
        this.register(TileEntityType.END_GATEWAY, new EndGatewayTileEntityRenderer(this));
        this.register(TileEntityType.BEACON, new BeaconTileEntityRenderer(this));
        this.register(TileEntityType.SKULL, new SkullTileEntityRenderer(this));
        this.register(TileEntityType.BANNER, new BannerTileEntityRenderer(this));
        this.register(TileEntityType.STRUCTURE_BLOCK, new StructureTileEntityRenderer(this));
        this.register(TileEntityType.SHULKER_BOX, new ShulkerBoxTileEntityRenderer(new ShulkerModel(), this));
        this.register(TileEntityType.BED, new BedTileEntityRenderer(this));
        this.register(TileEntityType.CONDUIT, new ConduitTileEntityRenderer(this));
        this.register(TileEntityType.BELL, new BellTileEntityRenderer(this));
        this.register(TileEntityType.CAMPFIRE, new CampfireTileEntityRenderer(this));
    }

    private <E extends TileEntity> void register(TileEntityType<E> typeIn, TileEntityRenderer<E> rendererIn) {
        this.renderers.put(typeIn, rendererIn);
    }

    @Nullable
    public <E extends TileEntity> TileEntityRenderer<E> getRenderer(E tileEntityIn) {
        return this.renderers.get(tileEntityIn.getType());
    }

    public void prepare(World worldIn, TextureManager textureManagerIn, FontRenderer fontRendererIn, ActiveRenderInfo activeRenderInfoIn, RayTraceResult rayTraceResultIn) {
        if (this.world != worldIn) {
            this.setWorld(worldIn);
        }
        this.textureManager = textureManagerIn;
        this.renderInfo = activeRenderInfoIn;
        this.fontRenderer = fontRendererIn;
        this.cameraHitResult = rayTraceResultIn;
    }

    public <E extends TileEntity> void renderTileEntity(E tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        TileEntityRenderer tileentityrenderer;
        if (Vector3d.copyCentered(tileEntityIn.getPos()).isWithinDistanceOf(this.renderInfo.getProjectedView(), tileEntityIn.getMaxRenderDistanceSquared()) && (tileentityrenderer = this.getRenderer(tileEntityIn)) != null && tileEntityIn.hasWorld() && tileEntityIn.getType().isValidBlock(tileEntityIn.getBlockState().getBlock())) {
            TileEntityRendererDispatcher.runCrashReportable(tileEntityIn, () -> TileEntityRendererDispatcher.render(tileentityrenderer, tileEntityIn, partialTicks, matrixStackIn, bufferIn));
        }
    }

    private static <T extends TileEntity> void render(TileEntityRenderer<T> rendererIn, T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        World world = tileEntityIn.getWorld();
        int i = world != null ? WorldRenderer.getCombinedLight(world, tileEntityIn.getPos()) : 0xF000F0;
        if (EmissiveTextures.isActive()) {
            EmissiveTextures.beginRender();
        }
        rendererIn.render(tileEntityIn, partialTicks, matrixStackIn, bufferIn, i, OverlayTexture.NO_OVERLAY);
        if (EmissiveTextures.isActive()) {
            if (EmissiveTextures.hasEmissive()) {
                EmissiveTextures.beginRenderEmissive();
                rendererIn.render(tileEntityIn, partialTicks, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS, OverlayTexture.NO_OVERLAY);
                EmissiveTextures.endRenderEmissive();
            }
            EmissiveTextures.endRender();
        }
    }

    public <E extends TileEntity> boolean renderItem(E tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TileEntityRenderer tileentityrenderer = this.getRenderer(tileEntityIn);
        if (tileentityrenderer == null) {
            return true;
        }
        TileEntityRendererDispatcher.runCrashReportable(tileEntityIn, () -> {
            this.tileEntityRendered = tileEntityIn;
            if (EmissiveTextures.isActive()) {
                EmissiveTextures.beginRender();
            }
            tileentityrenderer.render(tileEntityIn, 0.0f, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            if (EmissiveTextures.isActive()) {
                if (EmissiveTextures.hasEmissive()) {
                    EmissiveTextures.beginRenderEmissive();
                    tileentityrenderer.render(tileEntityIn, 0.0f, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn);
                    EmissiveTextures.endRenderEmissive();
                }
                EmissiveTextures.endRender();
            }
            this.tileEntityRendered = null;
        });
        return false;
    }

    private static void runCrashReportable(TileEntity tileEntityIn, Runnable runnableIn) {
        try {
            runnableIn.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Rendering Block Entity");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block Entity Details");
            tileEntityIn.addInfoToCrashReport(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void setWorld(@Nullable World worldIn) {
        this.world = worldIn;
        if (worldIn == null) {
            this.renderInfo = null;
        }
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public TileEntityRenderer getRenderer(TileEntityType p_getRenderer_1_) {
        return this.renderers.get(p_getRenderer_1_);
    }

    public synchronized <T extends TileEntity> void setSpecialRendererInternal(TileEntityType<T> p_setSpecialRendererInternal_1_, TileEntityRenderer<? super T> p_setSpecialRendererInternal_2_) {
        this.renderers.put(p_setSpecialRendererInternal_1_, p_setSpecialRendererInternal_2_);
    }
}

