/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class BedTileEntityRenderer
extends TileEntityRenderer<BedTileEntity> {
    private final ModelRenderer field_228843_a_;
    private final ModelRenderer field_228844_c_;
    private final ModelRenderer[] field_228845_d_ = new ModelRenderer[4];

    public BedTileEntityRenderer(TileEntityRendererDispatcher p_i226004_1_) {
        super(p_i226004_1_);
        this.field_228843_a_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228843_a_.addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f, 0.0f);
        this.field_228844_c_ = new ModelRenderer(64, 64, 0, 22);
        this.field_228844_c_.addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f, 0.0f);
        this.field_228845_d_[0] = new ModelRenderer(64, 64, 50, 0);
        this.field_228845_d_[1] = new ModelRenderer(64, 64, 50, 6);
        this.field_228845_d_[2] = new ModelRenderer(64, 64, 50, 12);
        this.field_228845_d_[3] = new ModelRenderer(64, 64, 50, 18);
        this.field_228845_d_[0].addBox(0.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f);
        this.field_228845_d_[1].addBox(0.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f);
        this.field_228845_d_[2].addBox(-16.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f);
        this.field_228845_d_[3].addBox(-16.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f);
        this.field_228845_d_[0].rotateAngleX = 1.5707964f;
        this.field_228845_d_[1].rotateAngleX = 1.5707964f;
        this.field_228845_d_[2].rotateAngleX = 1.5707964f;
        this.field_228845_d_[3].rotateAngleX = 1.5707964f;
        this.field_228845_d_[0].rotateAngleZ = 0.0f;
        this.field_228845_d_[1].rotateAngleZ = 1.5707964f;
        this.field_228845_d_[2].rotateAngleZ = 4.712389f;
        this.field_228845_d_[3].rotateAngleZ = (float)Math.PI;
    }

    @Override
    public void render(BedTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        RenderMaterial rendermaterial = Atlases.BED_TEXTURES[tileEntityIn.getColor().getId()];
        World world = tileEntityIn.getWorld();
        if (world != null) {
            BlockState blockstate = tileEntityIn.getBlockState();
            TileEntityMerger.ICallbackWrapper<BedTileEntity> icallbackwrapper = TileEntityMerger.func_226924_a_(TileEntityType.BED, BedBlock::getMergeType, BedBlock::getFootDirection, ChestBlock.FACING, blockstate, world, tileEntityIn.getPos(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.apply(new DualBrightnessCallback())).get(combinedLightIn);
            this.func_228847_a_(matrixStackIn, bufferIn, blockstate.get(BedBlock.PART) == BedPart.HEAD, blockstate.get(BedBlock.HORIZONTAL_FACING), rendermaterial, i, combinedOverlayIn, false);
        } else {
            this.func_228847_a_(matrixStackIn, bufferIn, true, Direction.SOUTH, rendermaterial, combinedLightIn, combinedOverlayIn, false);
            this.func_228847_a_(matrixStackIn, bufferIn, false, Direction.SOUTH, rendermaterial, combinedLightIn, combinedOverlayIn, true);
        }
    }

    private void func_228847_a_(MatrixStack p_228847_1_, IRenderTypeBuffer p_228847_2_, boolean p_228847_3_, Direction p_228847_4_, RenderMaterial p_228847_5_, int p_228847_6_, int p_228847_7_, boolean p_228847_8_) {
        this.field_228843_a_.showModel = p_228847_3_;
        this.field_228844_c_.showModel = !p_228847_3_;
        this.field_228845_d_[0].showModel = !p_228847_3_;
        this.field_228845_d_[1].showModel = p_228847_3_;
        this.field_228845_d_[2].showModel = !p_228847_3_;
        this.field_228845_d_[3].showModel = p_228847_3_;
        p_228847_1_.push();
        p_228847_1_.translate(0.0, 0.5625, p_228847_8_ ? -1.0 : 0.0);
        p_228847_1_.rotate(Vector3f.XP.rotationDegrees(90.0f));
        p_228847_1_.translate(0.5, 0.5, 0.5);
        p_228847_1_.rotate(Vector3f.ZP.rotationDegrees(180.0f + p_228847_4_.getHorizontalAngle()));
        p_228847_1_.translate(-0.5, -0.5, -0.5);
        IVertexBuilder ivertexbuilder = p_228847_5_.getBuffer(p_228847_2_, RenderType::getEntitySolid);
        this.field_228843_a_.render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        this.field_228844_c_.render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        this.field_228845_d_[0].render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        this.field_228845_d_[1].render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        this.field_228845_d_[2].render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        this.field_228845_d_[3].render(p_228847_1_, ivertexbuilder, p_228847_6_, p_228847_7_);
        p_228847_1_.pop();
    }
}

