/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class NeighborsUpdateDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;
    private final Map<Long, Map<BlockPos, Integer>> lastUpdate = Maps.newTreeMap((Comparator)Ordering.natural().reverse());

    NeighborsUpdateDebugRenderer(Minecraft minecraftIn) {
        this.minecraft = minecraftIn;
    }

    public void addUpdate(long worldTime, BlockPos pos) {
        Map map = this.lastUpdate.computeIfAbsent(worldTime, p_241730_0_ -> Maps.newHashMap());
        int i = map.getOrDefault(pos, 0);
        map.put(pos, i + 1);
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, double camX, double camY, double camZ) {
        long i = this.minecraft.world.getGameTime();
        int j = 200;
        double d0 = 0.0025;
        HashSet set = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.getLines());
        Iterator<Map.Entry<Long, Map<BlockPos, Integer>>> iterator = this.lastUpdate.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<BlockPos, Integer>> entry = iterator.next();
            Long olong = entry.getKey();
            Map<BlockPos, Integer> map1 = entry.getValue();
            long k = i - olong;
            if (k > 200L) {
                iterator.remove();
                continue;
            }
            for (Map.Entry<BlockPos, Integer> entry1 : map1.entrySet()) {
                BlockPos blockpos = entry1.getKey();
                Integer integer = entry1.getValue();
                if (!set.add(blockpos)) continue;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(BlockPos.ZERO).grow(0.002).shrink(0.0025 * (double)k).offset(blockpos.getX(), blockpos.getY(), blockpos.getZ()).offset(-camX, -camY, -camZ);
                WorldRenderer.drawBoundingBox(matrixStackIn, ivertexbuilder, axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ, 1.0f, 1.0f, 1.0f, 1.0f);
                map.put(blockpos, integer);
            }
        }
        for (Map.Entry entry2 : map.entrySet()) {
            BlockPos blockpos1 = (BlockPos)entry2.getKey();
            Integer integer1 = (Integer)entry2.getValue();
            DebugRenderer.renderText(String.valueOf(integer1), blockpos1.getX(), blockpos1.getY(), blockpos1.getZ(), -1);
        }
    }
}

