/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.optifine.Config;
import net.optifine.shaders.SVertexBuilder;
import org.lwjgl.system.MemoryUtil;

public class WorldVertexBufferUploader {
    public static void draw(BufferBuilder bufferBuilderIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                Pair<BufferBuilder.DrawState, ByteBuffer> pair1 = bufferBuilderIn.getNextBuffer();
                BufferBuilder.DrawState bufferbuilder$drawstate1 = (BufferBuilder.DrawState)pair1.getFirst();
                WorldVertexBufferUploader.draw((ByteBuffer)pair1.getSecond(), bufferbuilder$drawstate1.getDrawMode(), bufferbuilder$drawstate1.getFormat(), bufferbuilder$drawstate1.getVertexCount());
            });
        } else {
            Pair<BufferBuilder.DrawState, ByteBuffer> pair = bufferBuilderIn.getNextBuffer();
            BufferBuilder.DrawState bufferbuilder$drawstate = (BufferBuilder.DrawState)pair.getFirst();
            WorldVertexBufferUploader.draw((ByteBuffer)pair.getSecond(), bufferbuilder$drawstate.getDrawMode(), bufferbuilder$drawstate.getFormat(), bufferbuilder$drawstate.getVertexCount());
        }
    }

    private static void draw(ByteBuffer bufferIn, int modeIn, VertexFormat vertexFormatIn, int countIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ((Buffer)bufferIn).clear();
        if (countIn > 0) {
            vertexFormatIn.setupBufferState(MemoryUtil.memAddress((ByteBuffer)bufferIn));
            if (Config.isShaders()) {
                SVertexBuilder.drawArrays(modeIn, 0, countIn, vertexFormatIn, bufferIn);
            } else {
                GlStateManager.drawArrays(modeIn, 0, countIn);
            }
            vertexFormatIn.clearBufferState();
        }
    }
}

