/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.Empty3i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.util.UndeclaredException;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Session;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Bootstrap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] p_main_0_) {
        Thread thread1;
        Minecraft minecraft;
        OptionParser optionparser = new OptionParser();
        optionparser.allowsUnrecognizedOptions();
        optionparser.accepts("fullscreen");
        optionparser.accepts("checkGlErrors");
        ArgumentAcceptingOptionSpec optionspec = optionparser.accepts("server").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec1 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)25565, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec2 = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec4 = optionparser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec5 = optionparser.accepts("dataPackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec6 = optionparser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.milliTime() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec13 = optionparser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec15 = optionparser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec16 = optionparser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec17 = optionparser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec18 = optionparser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec19 = optionparser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec20 = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec21 = optionparser.accepts("userType").withRequiredArg().defaultsTo((Object)"legacy", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec22 = optionparser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec optionspec23 = optionparser.nonOptions();
        OptionSet optionset = optionparser.parse(p_main_0_);
        List list = optionset.valuesOf((OptionSpec)optionspec23);
        if (!list.isEmpty()) {
            System.out.println("Completely ignored arguments: " + String.valueOf(list));
        }
        String s = (String)Main.getValue(optionset, optionspec6);
        Proxy proxy = Proxy.NO_PROXY;
        if (s != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(s, (int)((Integer)Main.getValue(optionset, optionspec7))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String s1 = (String)Main.getValue(optionset, optionspec8);
        final String s2 = (String)Main.getValue(optionset, optionspec9);
        if (!proxy.equals(Proxy.NO_PROXY) && Main.isNotEmpty(s1) && Main.isNotEmpty(s2)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(s1, s2.toCharArray());
                }
            });
        }
        int i = (Integer)Main.getValue(optionset, optionspec14);
        int j = (Integer)Main.getValue(optionset, optionspec15);
        OptionalInt optionalint = Main.toOptionalInt((Integer)Main.getValue(optionset, optionspec16));
        OptionalInt optionalint1 = Main.toOptionalInt((Integer)Main.getValue(optionset, optionspec17));
        boolean flag = optionset.has("fullscreen");
        String s3 = (String)Main.getValue(optionset, optionspec13);
        Gson gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap propertymap = JSONUtils.fromJson(gson, (String)Main.getValue(optionset, optionspec18), PropertyMap.class);
        PropertyMap propertymap1 = JSONUtils.fromJson(gson, (String)Main.getValue(optionset, optionspec19), PropertyMap.class);
        String s4 = (String)Main.getValue(optionset, optionspec22);
        File file1 = (File)Main.getValue(optionset, optionspec2);
        File file2 = optionset.has((OptionSpec)optionspec3) ? (File)Main.getValue(optionset, optionspec3) : new File(file1, "assets/");
        File file3 = optionset.has((OptionSpec)optionspec4) ? (File)Main.getValue(optionset, optionspec4) : new File(file1, "resourcepacks/");
        String s5 = optionset.has((OptionSpec)optionspec11) ? (String)optionspec11.value(optionset) : PlayerEntity.getOfflineUUID((String)optionspec10.value(optionset)).toString();
        String s6 = optionset.has((OptionSpec)optionspec20) ? (String)optionspec20.value(optionset) : null;
        String s7 = (String)Main.getValue(optionset, optionspec);
        Integer integer = (Integer)Main.getValue(optionset, optionspec1);
        CrashReport.crash();
        Bootstrap.register();
        Bootstrap.checkTranslations();
        Util.func_240994_l_();
        Session session = new Session((String)optionspec10.value(optionset), s5, (String)optionspec12.value(optionset), (String)optionspec21.value(optionset));
        GameConfiguration gameconfiguration = new GameConfiguration(new GameConfiguration.UserInformation(session, propertymap, propertymap1, proxy), new ScreenSize(i, j, optionalint, optionalint1, flag), new GameConfiguration.FolderInformation(file1, file3, file2, s6), new GameConfiguration.GameInformation(s3, s4), new GameConfiguration.ServerInformation(s7, integer));
        Thread thread = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                IntegratedServer integratedserver;
                Minecraft minecraft1 = Minecraft.getInstance();
                if (minecraft1 != null && (integratedserver = minecraft1.getIntegratedServer()) != null) {
                    integratedserver.initiateShutdown(true);
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        Runtime.getRuntime().addShutdownHook(thread);
        new Empty3i();
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(gameconfiguration);
            RenderSystem.finishInitialization();
        }
        catch (UndeclaredException undeclaredexception) {
            LOGGER.warn("Failed to create window: ", (Throwable)undeclaredexception);
            return;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable1, "Initializing game");
            crashreport.makeCategory("Initialization");
            Minecraft.fillCrashReport(null, gameconfiguration.gameInfo.version, null, crashreport);
            Minecraft.displayCrashReport(crashreport);
            return;
        }
        if (minecraft.isRenderOnThread()) {
            thread1 = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        minecraft.run();
                    }
                    catch (Throwable throwable2) {
                        LOGGER.error("Exception in client thread", throwable2);
                    }
                }
            };
            thread1.start();
            while (minecraft.isRunning()) {
            }
        } else {
            thread1 = null;
            try {
                RenderSystem.initGameThread(false);
                minecraft.run();
            }
            catch (Throwable throwable) {
                LOGGER.error("Unhandled game exception", throwable);
            }
        }
        try {
            minecraft.shutdown();
            if (thread1 != null) {
                thread1.join();
            }
        }
        catch (InterruptedException interruptedexception) {
            LOGGER.error("Exception during client thread shutdown", (Throwable)interruptedexception);
        }
        finally {
            minecraft.shutdownMinecraftApplet();
        }
    }

    private static OptionalInt toOptionalInt(@Nullable Integer value) {
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T getValue(OptionSet set, OptionSpec<T> option) {
        try {
            return (T)set.valueOf(option);
        }
        catch (Throwable throwable) {
            ArgumentAcceptingOptionSpec argumentacceptingoptionspec;
            List list;
            if (option instanceof ArgumentAcceptingOptionSpec && !(list = (argumentacceptingoptionspec = (ArgumentAcceptingOptionSpec)option).defaultValues()).isEmpty()) {
                return (T)list.get(0);
            }
            throw throwable;
        }
    }

    private static boolean isNotEmpty(@Nullable String str) {
        return str != null && !str.isEmpty();
    }
}

