/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.AbstractRepairContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class AbstractRepairScreen<T extends AbstractRepairContainer>
extends ContainerScreen<T>
implements IContainerListener {
    private ResourceLocation guiTexture;

    public AbstractRepairScreen(T container, PlayerInventory playerInventory, ITextComponent title, ResourceLocation guiTexture) {
        super(container, playerInventory, title);
        this.guiTexture = guiTexture;
    }

    protected void initFields() {
    }

    @Override
    protected void init() {
        super.init();
        this.initFields();
        ((AbstractRepairContainer)this.container).addListener(this);
    }

    @Override
    public void onClose() {
        super.onClose();
        ((AbstractRepairContainer)this.container).removeListener(this);
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.renderNameField(matrices, mouseX, mouseY, delta);
        this.renderHoveredTooltip(matrices, mouseX, mouseY);
    }

    protected void renderNameField(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.minecraft.getTextureManager().bindTexture(this.guiTexture);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        this.blit(matrixStack, i, j, 0, 0, this.xSize, this.ySize);
        this.blit(matrixStack, i + 59, j + 20, 0, this.ySize + (((AbstractRepairContainer)this.container).getSlot(0).getHasStack() ? 0 : 16), 110, 16);
        if ((((AbstractRepairContainer)this.container).getSlot(0).getHasStack() || ((AbstractRepairContainer)this.container).getSlot(1).getHasStack()) && !((AbstractRepairContainer)this.container).getSlot(2).getHasStack()) {
            this.blit(matrixStack, i + 99, j + 45, this.xSize, 0, 28, 21);
        }
    }

    @Override
    public void sendAllContents(Container containerToSend, NonNullList<ItemStack> itemsList) {
        this.sendSlotContents(containerToSend, 0, containerToSend.getSlot(0).getStack());
    }

    @Override
    public void sendWindowProperty(Container containerIn, int varToUpdate, int newValue) {
    }

    @Override
    public void sendSlotContents(Container containerToSend, int slotInd, ItemStack stack) {
    }
}

