/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.OptimizeWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditWorldScreen
extends Screen {
    private static final Logger field_239014_a_ = LogManager.getLogger();
    private static final Gson field_239015_b_ = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private static final ITextComponent field_243441_c = new TranslationTextComponent("selectWorld.enterName");
    private Button saveButton;
    private final BooleanConsumer field_214311_b;
    private TextFieldWidget nameEdit;
    private final SaveFormat.LevelSave field_239016_r_;

    public EditWorldScreen(BooleanConsumer p_i232318_1_, SaveFormat.LevelSave p_i232318_2_) {
        super(new TranslationTextComponent("selectWorld.edit.title"));
        this.field_214311_b = p_i232318_1_;
        this.field_239016_r_ = p_i232318_2_;
    }

    @Override
    public void tick() {
        this.nameEdit.tick();
    }

    @Override
    protected void init() {
        this.minecraft.keyboardListener.enableRepeatEvents(true);
        Button button = this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 0 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.resetIcon"), p_214309_1_ -> {
            FileUtils.deleteQuietly((File)this.field_239016_r_.getIconFile());
            p_214309_1_.active = false;
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 24 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.openFolder"), p_214303_1_ -> Util.getOSType().openFile(this.field_239016_r_.resolveFilePath(FolderName.DOT).toFile())));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 48 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.backup"), p_214304_1_ -> {
            boolean flag = EditWorldScreen.func_239019_a_(this.field_239016_r_);
            this.field_214311_b.accept(!flag);
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 72 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.backupFolder"), p_214302_1_ -> {
            SaveFormat saveformat = this.minecraft.getSaveLoader();
            Path path = saveformat.getBackupsFolder();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Util.getOSType().openFile(path.toFile());
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 96 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.optimize"), p_214310_1_ -> this.minecraft.displayGuiScreen(new ConfirmBackupScreen(this, (p_214305_1_, p_214305_2_) -> {
            if (p_214305_1_) {
                EditWorldScreen.func_239019_a_(this.field_239016_r_);
            }
            this.minecraft.displayGuiScreen(OptimizeWorldScreen.func_239025_a_(this.minecraft, this.field_214311_b, this.minecraft.getDataFixer(), this.field_239016_r_, p_214305_2_));
        }, new TranslationTextComponent("optimizeWorld.confirm.title"), new TranslationTextComponent("optimizeWorld.confirm.description"), true))));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 120 + 5, 200, 20, new TranslationTextComponent("selectWorld.edit.export_worldgen_settings"), p_239023_1_ -> {
            DataResult dataresult;
            DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
            try (Minecraft.PackManager minecraft$packmanager = this.minecraft.reloadDatapacks(dynamicregistries$impl, Minecraft::loadDataPackCodec, (Function4<SaveFormat.LevelSave, DynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::loadWorld), false, this.field_239016_r_);){
                WorldGenSettingsExport dynamicops = WorldGenSettingsExport.create(JsonOps.INSTANCE, dynamicregistries$impl);
                DataResult dataresult1 = DimensionGeneratorSettings.field_236201_a_.encodeStart(dynamicops, (Object)minecraft$packmanager.getServerConfiguration().getDimensionGeneratorSettings());
                dataresult = dataresult1.flatMap(p_239017_1_ -> {
                    Path path = this.field_239016_r_.resolveFilePath(FolderName.DOT).resolve("worldgen_settings_export.json");
                    try (JsonWriter jsonwriter = field_239015_b_.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
                        field_239015_b_.toJson(p_239017_1_, jsonwriter);
                    }
                    catch (JsonIOException | IOException ioexception) {
                        return DataResult.error((String)("Error writing file: " + ioexception.getMessage()));
                    }
                    return DataResult.success((Object)path.toString());
                });
            }
            catch (InterruptedException | ExecutionException interruptedexception) {
                dataresult = DataResult.error((String)"Could not parse level data!");
            }
            StringTextComponent itextcomponent = new StringTextComponent((String)dataresult.get().map(Function.identity(), DataResult.PartialResult::message));
            TranslationTextComponent itextcomponent1 = new TranslationTextComponent(dataresult.result().isPresent() ? "selectWorld.edit.export_worldgen_settings.success" : "selectWorld.edit.export_worldgen_settings.failure");
            dataresult.error().ifPresent(p_239018_0_ -> field_239014_a_.error("Error exporting world settings: {}", p_239018_0_));
            this.minecraft.getToastGui().add(SystemToast.func_238534_a_(this.minecraft, SystemToast.Type.WORLD_GEN_SETTINGS_TRANSFER, itextcomponent1, itextcomponent));
        }));
        this.saveButton = this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 144 + 5, 98, 20, new TranslationTextComponent("selectWorld.edit.save"), p_214308_1_ -> this.saveChanges()));
        this.addButton(new Button(this.width / 2 + 2, this.height / 4 + 144 + 5, 98, 20, DialogTexts.GUI_CANCEL, p_214306_1_ -> this.field_214311_b.accept(false)));
        button.active = this.field_239016_r_.getIconFile().isFile();
        WorldSummary worldsummary = this.field_239016_r_.readWorldSummary();
        String s = worldsummary == null ? "" : worldsummary.getDisplayName();
        this.nameEdit = new TextFieldWidget(this.font, this.width / 2 - 100, 38, 200, 20, new TranslationTextComponent("selectWorld.enterName"));
        this.nameEdit.setText(s);
        this.nameEdit.setResponder(p_214301_1_ -> {
            this.saveButton.active = !p_214301_1_.trim().isEmpty();
        });
        this.children.add(this.nameEdit);
        this.setFocusedDefault(this.nameEdit);
    }

    @Override
    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.nameEdit.getText();
        this.init(minecraft, width, height);
        this.nameEdit.setText(s);
    }

    @Override
    public void closeScreen() {
        this.field_214311_b.accept(false);
    }

    @Override
    public void onClose() {
        this.minecraft.keyboardListener.enableRepeatEvents(false);
    }

    private void saveChanges() {
        try {
            this.field_239016_r_.updateSaveName(this.nameEdit.getText().trim());
            this.field_214311_b.accept(true);
        }
        catch (IOException ioexception) {
            field_239014_a_.error("Failed to access world '{}'", (Object)this.field_239016_r_.getSaveName(), (Object)ioexception);
            SystemToast.func_238535_a_(this.minecraft, this.field_239016_r_.getSaveName());
            this.field_214311_b.accept(true);
        }
    }

    public static void func_241651_a_(SaveFormat p_241651_0_, String p_241651_1_) {
        boolean flag = false;
        try (SaveFormat.LevelSave saveformat$levelsave = p_241651_0_.getLevelSave(p_241651_1_);){
            flag = true;
            EditWorldScreen.func_239019_a_(saveformat$levelsave);
        }
        catch (IOException ioexception) {
            if (!flag) {
                SystemToast.func_238535_a_(Minecraft.getInstance(), p_241651_1_);
            }
            field_239014_a_.warn("Failed to create backup of level {}", (Object)p_241651_1_, (Object)ioexception);
        }
    }

    public static boolean func_239019_a_(SaveFormat.LevelSave p_239019_0_) {
        long i = 0L;
        IOException ioexception = null;
        try {
            i = p_239019_0_.createBackup();
        }
        catch (IOException ioexception1) {
            ioexception = ioexception1;
        }
        if (ioexception != null) {
            TranslationTextComponent itextcomponent2 = new TranslationTextComponent("selectWorld.edit.backupFailed");
            StringTextComponent itextcomponent3 = new StringTextComponent(ioexception.getMessage());
            Minecraft.getInstance().getToastGui().add(new SystemToast(SystemToast.Type.WORLD_BACKUP, itextcomponent2, itextcomponent3));
            return false;
        }
        TranslationTextComponent itextcomponent = new TranslationTextComponent("selectWorld.edit.backupCreated", p_239019_0_.getSaveName());
        TranslationTextComponent itextcomponent1 = new TranslationTextComponent("selectWorld.edit.backupSize", MathHelper.ceil((double)i / 1048576.0));
        Minecraft.getInstance().getToastGui().add(new SystemToast(SystemToast.Type.WORLD_BACKUP, itextcomponent, itextcomponent1));
        return true;
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        EditWorldScreen.drawCenteredString(matrices, this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        EditWorldScreen.drawString(matrices, this.font, field_243441_c, this.width / 2 - 100, 24, 0xA0A0A0);
        this.nameEdit.render(matrices, mouseX, mouseY, delta);
        super.render(matrices, mouseX, mouseY, delta);
    }
}

