/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;

public class EditGamerulesScreen
extends Screen {
    private final Consumer<Optional<GameRules>> field_238965_a_;
    private GamerulesList field_238966_b_;
    private final Set<Gamerule> field_238967_c_ = Sets.newHashSet();
    private Button field_238968_p_;
    @Nullable
    private List<IReorderingProcessor> field_238969_q_;
    private final GameRules field_238970_r_;

    public EditGamerulesScreen(GameRules p_i232310_1_, Consumer<Optional<GameRules>> p_i232310_2_) {
        super(new TranslationTextComponent("editGamerule.title"));
        this.field_238970_r_ = p_i232310_1_;
        this.field_238965_a_ = p_i232310_2_;
    }

    @Override
    protected void init() {
        this.minecraft.keyboardListener.enableRepeatEvents(true);
        super.init();
        this.field_238966_b_ = new GamerulesList(this.field_238970_r_);
        this.children.add(this.field_238966_b_);
        this.addButton(new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, DialogTexts.GUI_CANCEL, p_238976_1_ -> this.field_238965_a_.accept(Optional.empty())));
        this.field_238968_p_ = this.addButton(new Button(this.width / 2 - 155, this.height - 29, 150, 20, DialogTexts.GUI_DONE, p_238971_1_ -> this.field_238965_a_.accept(Optional.of(this.field_238970_r_))));
    }

    @Override
    public void onClose() {
        this.minecraft.keyboardListener.enableRepeatEvents(false);
    }

    @Override
    public void closeScreen() {
        this.field_238965_a_.accept(Optional.empty());
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.field_238969_q_ = null;
        this.field_238966_b_.render(matrices, mouseX, mouseY, delta);
        EditGamerulesScreen.drawCenteredString(matrices, this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(matrices, mouseX, mouseY, delta);
        if (this.field_238969_q_ != null) {
            this.renderTooltip(matrices, this.field_238969_q_, mouseX, mouseY);
        }
    }

    private void func_238980_b_(@Nullable List<IReorderingProcessor> p_238980_1_) {
        this.field_238969_q_ = p_238980_1_;
    }

    private void func_238984_g_() {
        this.field_238968_p_.active = this.field_238967_c_.isEmpty();
    }

    private void func_238972_a_(Gamerule p_238972_1_) {
        this.field_238967_c_.add(p_238972_1_);
        this.func_238984_g_();
    }

    private void func_238977_b_(Gamerule p_238977_1_) {
        this.field_238967_c_.remove(p_238977_1_);
        this.func_238984_g_();
    }

    public class GamerulesList
    extends AbstractOptionList<Gamerule> {
        public GamerulesList(final GameRules p_i232316_2_) {
            super(EditGamerulesScreen.this.minecraft, EditGamerulesScreen.this.width, EditGamerulesScreen.this.height, 43, EditGamerulesScreen.this.height - 32, 24);
            final HashMap map = Maps.newHashMap();
            GameRules.visitAll(new GameRules.IRuleEntryVisitor(){

                @Override
                public void changeBoolean(GameRules.RuleKey<GameRules.BooleanValue> value1, GameRules.RuleType<GameRules.BooleanValue> value2) {
                    this.func_239011_a_(value1, (p_239012_1_, p_239012_2_, p_239012_3_, p_239012_4_) -> {
                        EditGamerulesScreen editGamerulesScreen = EditGamerulesScreen.this;
                        Objects.requireNonNull(editGamerulesScreen);
                        return editGamerulesScreen.new BooleanEntry(p_239012_1_, p_239012_2_, p_239012_3_, (GameRules.BooleanValue)p_239012_4_);
                    });
                }

                @Override
                public void changeInteger(GameRules.RuleKey<GameRules.IntegerValue> value1, GameRules.RuleType<GameRules.IntegerValue> value2) {
                    this.func_239011_a_(value1, (p_239013_1_, p_239013_2_, p_239013_3_, p_239013_4_) -> {
                        EditGamerulesScreen editGamerulesScreen = EditGamerulesScreen.this;
                        Objects.requireNonNull(editGamerulesScreen);
                        return editGamerulesScreen.new IntegerEntry(p_239013_1_, p_239013_2_, p_239013_3_, (GameRules.IntegerValue)p_239013_4_);
                    });
                }

                private <T extends GameRules.RuleValue<T>> void func_239011_a_(GameRules.RuleKey<T> p_239011_1_, IRuleEntry<T> p_239011_2_) {
                    Object s2;
                    ImmutableList list;
                    TranslationTextComponent itextcomponent = new TranslationTextComponent(p_239011_1_.getLocaleString());
                    IFormattableTextComponent itextcomponent1 = new StringTextComponent(p_239011_1_.getName()).mergeStyle(TextFormatting.YELLOW);
                    T t = p_i232316_2_.get(p_239011_1_);
                    String s = ((GameRules.RuleValue)t).stringValue();
                    IFormattableTextComponent itextcomponent2 = new TranslationTextComponent("editGamerule.default", new StringTextComponent(s)).mergeStyle(TextFormatting.GRAY);
                    String s1 = p_239011_1_.getLocaleString() + ".description";
                    if (I18n.hasKey(s1)) {
                        ImmutableList.Builder builder = ImmutableList.builder().add((Object)itextcomponent1.func_241878_f());
                        TranslationTextComponent itextcomponent3 = new TranslationTextComponent(s1);
                        EditGamerulesScreen.this.font.trimStringToWidth(itextcomponent3, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                        list = builder.add((Object)itextcomponent2.func_241878_f()).build();
                        s2 = itextcomponent3.getString() + "\n" + itextcomponent2.getString();
                    } else {
                        list = ImmutableList.of((Object)itextcomponent1.func_241878_f(), (Object)itextcomponent2.func_241878_f());
                        s2 = itextcomponent2.getString();
                    }
                    map.computeIfAbsent(p_239011_1_.getCategory(), p_239010_0_ -> Maps.newHashMap()).put(p_239011_1_, p_239011_2_.create(itextcomponent, (List<IReorderingProcessor>)list, (String)s2, t));
                }
            });
            map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_239004_1_ -> {
                EditGamerulesScreen editGamerulesScreen = EditGamerulesScreen.this;
                Objects.requireNonNull(editGamerulesScreen);
                this.addEntry(editGamerulesScreen.new NameEntry(new TranslationTextComponent(((GameRules.Category)((Object)((Object)p_239004_1_.getKey()))).getLocaleString()).mergeStyle(TextFormatting.BOLD, TextFormatting.YELLOW)));
                ((Map)p_239004_1_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(GameRules.RuleKey::getName))).forEach(p_239005_1_ -> this.addEntry((Gamerule)p_239005_1_.getValue()));
            });
        }

        @Override
        public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            Gamerule editgamerulesscreen$gamerule;
            super.render(matrices, mouseX, mouseY, delta);
            if (this.isMouseOver(mouseX, mouseY) && (editgamerulesscreen$gamerule = (Gamerule)this.getEntryAtPosition(mouseX, mouseY)) != null) {
                EditGamerulesScreen.this.func_238980_b_(editgamerulesscreen$gamerule.field_239000_a_);
            }
        }
    }

    public abstract class ValueEntry
    extends Gamerule {
        private final List<IReorderingProcessor> field_241646_a_;
        protected final List<IGuiEventListener> field_241647_b_;

        public ValueEntry(List<IReorderingProcessor> p_i241256_2_, ITextComponent p_i241256_3_) {
            super(p_i241256_2_);
            this.field_241647_b_ = Lists.newArrayList();
            this.field_241646_a_ = EditGamerulesScreen.this.minecraft.fontRenderer.trimStringToWidth(p_i241256_3_, 175);
        }

        @Override
        public List<? extends IGuiEventListener> getEventListeners() {
            return this.field_241647_b_;
        }

        protected void func_241649_a_(MatrixStack p_241649_1_, int p_241649_2_, int p_241649_3_) {
            if (this.field_241646_a_.size() == 1) {
                EditGamerulesScreen.this.minecraft.fontRenderer.func_238422_b_(p_241649_1_, this.field_241646_a_.get(0), p_241649_3_, p_241649_2_ + 5, 0xFFFFFF);
            } else if (this.field_241646_a_.size() >= 2) {
                EditGamerulesScreen.this.minecraft.fontRenderer.func_238422_b_(p_241649_1_, this.field_241646_a_.get(0), p_241649_3_, p_241649_2_, 0xFFFFFF);
                EditGamerulesScreen.this.minecraft.fontRenderer.func_238422_b_(p_241649_1_, this.field_241646_a_.get(1), p_241649_3_, p_241649_2_ + 10, 0xFFFFFF);
            }
        }
    }

    public class NameEntry
    extends Gamerule {
        private final ITextComponent field_238994_c_;

        public NameEntry(ITextComponent p_i232313_2_) {
            super(null);
            this.field_238994_c_ = p_i232313_2_;
        }

        @Override
        public void render(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            AbstractGui.drawCenteredString(p_230432_1_, EditGamerulesScreen.this.minecraft.fontRenderer, this.field_238994_c_, p_230432_4_ + p_230432_5_ / 2, p_230432_3_ + 5, 0xFFFFFF);
        }

        @Override
        public List<? extends IGuiEventListener> getEventListeners() {
            return ImmutableList.of();
        }
    }

    public class IntegerEntry
    extends ValueEntry {
        private final TextFieldWidget field_238997_d_;

        public IntegerEntry(ITextComponent p_i232314_2_, List<IReorderingProcessor> p_i232314_3_, String p_i232314_4_, GameRules.IntegerValue p_i232314_5_) {
            super(p_i232314_3_, p_i232314_2_);
            this.field_238997_d_ = new TextFieldWidget(EditGamerulesScreen.this.minecraft.fontRenderer, 10, 5, 42, 20, p_i232314_2_.deepCopy().appendString("\n").appendString(p_i232314_4_).appendString("\n"));
            this.field_238997_d_.setText(Integer.toString(p_i232314_5_.get()));
            this.field_238997_d_.setResponder(p_238999_2_ -> {
                if (p_i232314_5_.parseIntValue((String)p_238999_2_)) {
                    this.field_238997_d_.setTextColor(0xE0E0E0);
                    EditGamerulesScreen.this.func_238977_b_(this);
                } else {
                    this.field_238997_d_.setTextColor(0xFF0000);
                    EditGamerulesScreen.this.func_238972_a_(this);
                }
            });
            this.field_241647_b_.add(this.field_238997_d_);
        }

        @Override
        public void render(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.func_241649_a_(p_230432_1_, p_230432_3_, p_230432_4_);
            this.field_238997_d_.x = p_230432_4_ + p_230432_5_ - 44;
            this.field_238997_d_.y = p_230432_3_;
            this.field_238997_d_.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }
    }

    @FunctionalInterface
    static interface IRuleEntry<T extends GameRules.RuleValue<T>> {
        public Gamerule create(ITextComponent var1, List<IReorderingProcessor> var2, String var3, T var4);
    }

    public abstract class Gamerule
    extends AbstractOptionList.Entry<Gamerule> {
        @Nullable
        private final List<IReorderingProcessor> field_239000_a_;

        public Gamerule(List<IReorderingProcessor> p_i232315_2_) {
            this.field_239000_a_ = p_i232315_2_;
        }
    }

    public class BooleanEntry
    extends ValueEntry {
        private final Button field_238986_c_;

        public BooleanEntry(final ITextComponent p_i232311_2_, List<IReorderingProcessor> p_i232311_3_, final String p_i232311_4_, final GameRules.BooleanValue p_i232311_5_) {
            super(p_i232311_3_, p_i232311_2_);
            this.field_238986_c_ = new Button(10, 5, 44, 20, DialogTexts.optionsEnabled(p_i232311_5_.get()), p_238988_1_ -> {
                boolean flag = !p_i232311_5_.get();
                p_i232311_5_.set(flag, null);
                p_238988_1_.setMessage(DialogTexts.optionsEnabled(p_i232311_5_.get()));
            }){

                @Override
                protected IFormattableTextComponent getNarrationMessage() {
                    return DialogTexts.getComposedOptionMessage(p_i232311_2_, p_i232311_5_.get()).appendString("\n").appendString(p_i232311_4_);
                }
            };
            this.field_241647_b_.add(this.field_238986_c_);
        }

        @Override
        public void render(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.func_241649_a_(p_230432_1_, p_230432_3_, p_230432_4_);
            this.field_238986_c_.x = p_230432_4_ + p_230432_5_ - 45;
            this.field_238986_c_.y = p_230432_3_;
            this.field_238986_c_.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }
    }
}

