/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.MainMenuHolder;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class DeathScreen
extends Screen {
    private int enableButtonsTimer;
    private final ITextComponent causeOfDeath;
    private final boolean isHardcoreMode;
    private ITextComponent field_243285_p;

    public DeathScreen(@Nullable ITextComponent textComponent, boolean isHardcoreMode) {
        super(new TranslationTextComponent(isHardcoreMode ? "deathScreen.title.hardcore" : "deathScreen.title"));
        this.causeOfDeath = textComponent;
        this.isHardcoreMode = isHardcoreMode;
    }

    @Override
    protected void init() {
        this.enableButtonsTimer = 0;
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 72, 200, 20, this.isHardcoreMode ? new TranslationTextComponent("deathScreen.spectate") : new TranslationTextComponent("deathScreen.respawn"), p_213021_1_ -> {
            this.minecraft.player.respawnPlayer();
            this.minecraft.displayGuiScreen(null);
        }));
        Button button = this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 96, 200, 20, new TranslationTextComponent("deathScreen.titleScreen"), p_213020_1_ -> {
            if (this.isHardcoreMode) {
                this.func_228177_a_();
            } else {
                ConfirmScreen confirmscreen = new ConfirmScreen(this::confirmCallback, new TranslationTextComponent("deathScreen.quit.confirm"), StringTextComponent.EMPTY, new TranslationTextComponent("deathScreen.titleScreen"), new TranslationTextComponent("deathScreen.respawn"));
                this.minecraft.displayGuiScreen(confirmscreen);
                confirmscreen.setButtonDelay(20);
            }
        }));
        if (!this.isHardcoreMode && this.minecraft.getSession() == null) {
            button.active = false;
        }
        for (Widget widget : this.buttons) {
            widget.active = false;
        }
        this.field_243285_p = new TranslationTextComponent("deathScreen.score").appendString(": ").append(new StringTextComponent(Integer.toString(this.minecraft.player.getScore())).mergeStyle(TextFormatting.YELLOW));
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    private void confirmCallback(boolean p_213022_1_) {
        if (p_213022_1_) {
            this.func_228177_a_();
        } else {
            this.minecraft.player.respawnPlayer();
            this.minecraft.displayGuiScreen(null);
        }
    }

    private void func_228177_a_() {
        if (this.minecraft.world != null) {
            this.minecraft.world.sendQuittingDisconnectingPacket();
        }
        this.minecraft.unloadWorld(new DirtMessageScreen(new TranslationTextComponent("menu.savingLevel")));
        this.minecraft.displayGuiScreen(new MainMenuHolder());
    }

    @Override
    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.fillGradient(matrices, 0, 0, this.width, this.height, 0x60500000, -1602211792);
        RenderSystem.pushMatrix();
        RenderSystem.scalef(2.0f, 2.0f, 2.0f);
        DeathScreen.drawCenteredString(matrices, this.font, this.title, this.width / 2 / 2, 30, 0xFFFFFF);
        RenderSystem.popMatrix();
        if (this.causeOfDeath != null) {
            DeathScreen.drawCenteredString(matrices, this.font, this.causeOfDeath, this.width / 2, 85, 0xFFFFFF);
        }
        DeathScreen.drawCenteredString(matrices, this.font, this.field_243285_p, this.width / 2, 100, 0xFFFFFF);
        if (this.causeOfDeath != null && mouseY > 85 && mouseY < 94) {
            Style style = this.func_238623_a_(mouseX);
            this.renderComponentHoverEffect(matrices, style, mouseX, mouseY);
        }
        super.render(matrices, mouseX, mouseY, delta);
    }

    @Nullable
    private Style func_238623_a_(int p_238623_1_) {
        if (this.causeOfDeath == null) {
            return null;
        }
        int i = this.minecraft.fontRenderer.getStringPropertyWidth(this.causeOfDeath);
        int j = this.width / 2 - i / 2;
        int k = this.width / 2 + i / 2;
        return p_238623_1_ >= j && p_238623_1_ <= k ? this.minecraft.fontRenderer.getCharacterManager().func_238357_a_(this.causeOfDeath, p_238623_1_ - j) : null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style style;
        if (this.causeOfDeath != null && mouseY > 85.0 && mouseY < 94.0 && (style = this.func_238623_a_((int)mouseX)) != null && style.getClickEvent() != null && style.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL) {
            this.handleComponentClicked(style);
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.enableButtonsTimer;
        if (this.enableButtonsTimer == 20) {
            for (Widget widget : this.buttons) {
                widget.active = true;
            }
        }
    }
}

