/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;

public abstract class SpreadableSnowyDirtBlock
extends SnowyDirtBlock {
    protected SpreadableSnowyDirtBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    private static boolean isSnowyConditions(BlockState state, IWorldReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.up();
        BlockState blockstate = worldReader.getBlockState(blockpos);
        if (blockstate.isIn(Blocks.SNOW) && blockstate.get(SnowBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getLevel() == 8) {
            return false;
        }
        int i = LightEngine.func_215613_a(worldReader, state, pos, blockstate, blockpos, Direction.UP, blockstate.getOpacity(worldReader, blockpos));
        return i < worldReader.getMaxLightLevel();
    }

    private static boolean isSnowyAndNotUnderwater(BlockState state, IWorldReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.up();
        return SpreadableSnowyDirtBlock.isSnowyConditions(state, worldReader, pos) && !worldReader.getFluidState(blockpos).isTagged(FluidTags.WATER);
    }

    @Override
    public void randomTick(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!SpreadableSnowyDirtBlock.isSnowyConditions(state, worldIn, pos)) {
            worldIn.setBlockState(pos, Blocks.DIRT.getDefaultState());
        } else if (worldIn.getLight(pos.up()) >= 9) {
            BlockState blockstate = this.getDefaultState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.add(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!worldIn.getBlockState(blockpos).isIn(Blocks.DIRT) || !SpreadableSnowyDirtBlock.isSnowyAndNotUnderwater(blockstate, worldIn, blockpos)) continue;
                worldIn.setBlockState(blockpos, (BlockState)blockstate.with(SNOWY, worldIn.getBlockState(blockpos.up()).isIn(Blocks.SNOW)));
            }
        }
    }
}

