/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BeehiveBlock
extends ContainerBlock {
    private static final Direction[] GENERATE_DIRECTIONS = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH};
    public static final DirectionProperty FACING = HorizontalBlock.HORIZONTAL_FACING;
    public static final IntegerProperty HONEY_LEVEL = BlockStateProperties.HONEY_LEVEL;

    public BeehiveBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.setDefaultState((BlockState)((BlockState)((BlockState)this.stateContainer.getBaseState()).with(HONEY_LEVEL, 0)).with(FACING, Direction.NORTH));
    }

    @Override
    public boolean hasComparatorInputOverride(BlockState state) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(BlockState blockState, World worldIn, BlockPos pos) {
        return blockState.get(HONEY_LEVEL);
    }

    @Override
    public void harvestBlock(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.harvestBlock(worldIn, player, pos, state, te, stack);
        if (!worldIn.isRemote && te instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)te;
            if (EnchantmentHelper.getEnchantmentLevel(Enchantments.SILK_TOUCH, stack) == 0) {
                beehivetileentity.angerBees(player, state, BeehiveTileEntity.State.EMERGENCY);
                worldIn.updateComparatorOutputLevel(pos, this);
                this.angerNearbyBees(worldIn, pos);
            }
            CriteriaTriggers.BEE_NEST_DESTROYED.test((ServerPlayerEntity)player, state.getBlock(), stack, beehivetileentity.getBeeCount());
        }
    }

    private void angerNearbyBees(World world, BlockPos pos) {
        List<BeeEntity> list = world.getEntitiesWithinAABB(BeeEntity.class, new AxisAlignedBB(pos).grow(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            List<PlayerEntity> list1 = world.getEntitiesWithinAABB(PlayerEntity.class, new AxisAlignedBB(pos).grow(8.0, 6.0, 8.0));
            int i = list1.size();
            for (BeeEntity beeentity : list) {
                if (beeentity.getAttackTarget() != null) continue;
                beeentity.setAttackTarget(list1.get(world.rand.nextInt(i)));
            }
        }
    }

    public static void dropHoneyComb(World world, BlockPos pos) {
        BeehiveBlock.spawnAsEntity(world, pos, new ItemStack(Items.HONEYCOMB, 3));
    }

    @Override
    public ActionResultType onBlockActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.getHeldItem(handIn);
        int i = state.get(HONEY_LEVEL);
        boolean flag = false;
        if (i >= 5) {
            if (itemstack.getItem() == Items.SHEARS) {
                worldIn.playSound(player, player.getPosX(), player.getPosY(), player.getPosZ(), SoundEvents.BLOCK_BEEHIVE_SHEAR, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.dropHoneyComb(worldIn, pos);
                itemstack.damageItem(1, player, playerEntity -> playerEntity.sendBreakAnimation(handIn));
                flag = true;
            } else if (itemstack.getItem() == Items.GLASS_BOTTLE) {
                itemstack.shrink(1);
                worldIn.playSound(player, player.getPosX(), player.getPosY(), player.getPosZ(), SoundEvents.ITEM_BOTTLE_FILL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (itemstack.isEmpty()) {
                    player.setHeldItem(handIn, new ItemStack(Items.HONEY_BOTTLE));
                } else if (!player.inventory.addItemStackToInventory(new ItemStack(Items.HONEY_BOTTLE))) {
                    player.dropItem(new ItemStack(Items.HONEY_BOTTLE), false);
                }
                flag = true;
            }
        }
        if (flag) {
            if (!CampfireBlock.isSmokingBlockAt(worldIn, pos)) {
                if (this.hasBees(worldIn, pos)) {
                    this.angerNearbyBees(worldIn, pos);
                }
                this.takeHoney(worldIn, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
            } else {
                this.takeHoney(worldIn, state, pos);
            }
            return ActionResultType.func_233537_a_(worldIn.isRemote);
        }
        return super.onBlockActivated(state, worldIn, pos, player, handIn, hit);
    }

    private boolean hasBees(World world, BlockPos pos) {
        TileEntity tileentity = world.getTileEntity(pos);
        if (tileentity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            return !beehivetileentity.hasNoBees();
        }
        return false;
    }

    public void takeHoney(World world, BlockState state, BlockPos pos, @Nullable PlayerEntity player, BeehiveTileEntity.State tileState) {
        this.takeHoney(world, state, pos);
        TileEntity tileentity = world.getTileEntity(pos);
        if (tileentity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.angerBees(player, state, tileState);
        }
    }

    public void takeHoney(World world, BlockState state, BlockPos pos) {
        world.setBlockState(pos, (BlockState)state.with(HONEY_LEVEL, 0), 3);
    }

    @Override
    public void animateTick(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.get(HONEY_LEVEL) >= 5) {
            for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                this.addHoneyParticle(worldIn, pos, stateIn);
            }
        }
    }

    private void addHoneyParticle(World world, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.getFluidState().isEmpty() && !(world.rand.nextFloat() < 0.3f) && (d0 = (voxelshape = state.getCollisionShape(world, pos)).getEnd(Direction.Axis.Y)) >= 1.0 && !state.isIn(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.getStart(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.addHoneyParticle(world, pos, voxelshape, (double)pos.getY() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.down();
                BlockState blockstate = world.getBlockState(blockpos);
                VoxelShape voxelshape1 = blockstate.getCollisionShape(world, blockpos);
                double d2 = voxelshape1.getEnd(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.hasOpaqueCollisionShape(world, blockpos)) && blockstate.getFluidState().isEmpty()) {
                    this.addHoneyParticle(world, pos, voxelshape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(World world, BlockPos pos, VoxelShape shape, double y) {
        this.addHoneyParticle(world, (double)pos.getX() + shape.getStart(Direction.Axis.X), (double)pos.getX() + shape.getEnd(Direction.Axis.X), (double)pos.getZ() + shape.getStart(Direction.Axis.Z), (double)pos.getZ() + shape.getEnd(Direction.Axis.Z), y);
    }

    private void addHoneyParticle(World particleData, double x1, double x2, double z1, double z2, double y) {
        particleData.addParticle(ParticleTypes.DRIPPING_HONEY, MathHelper.lerp(particleData.rand.nextDouble(), x1, x2), y, MathHelper.lerp(particleData.rand.nextDouble(), z1, z2), 0.0, 0.0, 0.0);
    }

    @Override
    public BlockState getStateForPlacement(BlockItemUseContext context) {
        return (BlockState)this.getDefaultState().with(FACING, context.getPlacementHorizontalFacing().getOpposite());
    }

    @Override
    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder) {
        builder.add(HONEY_LEVEL, FACING);
    }

    @Override
    public BlockRenderType getRenderType(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    @Nullable
    public TileEntity createNewTileEntity(IBlockReader worldIn) {
        return new BeehiveTileEntity();
    }

    @Override
    public void onBlockHarvested(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity;
        if (!worldIn.isRemote && player.isCreative() && worldIn.getGameRules().getBoolean(GameRules.DO_TILE_DROPS) && (tileentity = worldIn.getTileEntity(pos)) instanceof BeehiveTileEntity) {
            boolean flag;
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            ItemStack itemstack = new ItemStack(this);
            int i = state.get(HONEY_LEVEL);
            boolean bl = flag = !beehivetileentity.hasNoBees();
            if (!flag && i == 0) {
                return;
            }
            if (flag) {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.put("Bees", beehivetileentity.getBees());
                itemstack.setTagInfo("BlockEntityTag", compoundnbt);
            }
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.putInt("honey_level", i);
            itemstack.setTagInfo("BlockStateTag", compoundnbt1);
            ItemEntity itementity = new ItemEntity(worldIn, pos.getX(), pos.getY(), pos.getZ(), itemstack);
            itementity.setDefaultPickupDelay();
            worldIn.addEntity(itementity);
        }
        super.onBlockHarvested(worldIn, pos, state, player);
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity;
        Entity entity = builder.get(LootParameters.THIS_ENTITY);
        if ((entity instanceof TNTEntity || entity instanceof CreeperEntity || entity instanceof WitherSkullEntity || entity instanceof WitherEntity || entity instanceof TNTMinecartEntity) && (tileentity = builder.get(LootParameters.BLOCK_ENTITY)) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.angerBees(null, state, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.getDrops(state, builder);
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileentity;
        if (worldIn.getBlockState(facingPos).getBlock() instanceof FireBlock && (tileentity = worldIn.getTileEntity(currentPos)) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
            beehivetileentity.angerBees(null, stateIn, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.updatePostPlacement(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Direction getGenerationDirection(Random rand) {
        return Util.getRandomObject(GENERATE_DIRECTIONS, rand);
    }
}

