/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class RightClickBlockWithItemTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("item_used_on_block");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        LocationPredicate locationpredicate = LocationPredicate.deserialize(json.get("location"));
        ItemPredicate itempredicate = ItemPredicate.deserialize(json.get("item"));
        return new Instance(entityPredicate, locationpredicate, itempredicate);
    }

    public void test(ServerPlayerEntity player, BlockPos pos, ItemStack stack) {
        BlockState blockstate = player.getServerWorld().getBlockState(pos);
        this.triggerListeners(player, instance -> instance.test(blockstate, player.getServerWorld(), pos, stack));
    }

    public static class Instance
    extends CriterionInstance {
        private final LocationPredicate location;
        private final ItemPredicate stack;

        public Instance(EntityPredicate.AndPredicate player, LocationPredicate location, ItemPredicate stack) {
            super(ID, player);
            this.location = location;
            this.stack = stack;
        }

        public static Instance create(LocationPredicate.Builder locationBuilder, ItemPredicate.Builder stackBuilder) {
            return new Instance(EntityPredicate.AndPredicate.ANY_AND, locationBuilder.build(), stackBuilder.build());
        }

        public boolean test(BlockState state, ServerWorld world, BlockPos pos, ItemStack stack) {
            return !this.location.test(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) ? false : this.stack.test(stack);
        }

        @Override
        public JsonObject serialize(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.serialize(conditions);
            jsonobject.add("location", this.location.serialize());
            jsonobject.add("item", this.stack.serialize());
            return jsonobject;
        }
    }
}

