/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.system.sound;

import com.mentalfrostbyte.jello.util.system.sound.MusicStream;
import java.io.InputStream;

public final class AudioStreamer
implements Runnable {
    private final InputStream inputStream;
    public final MusicStream musicStream;

    public AudioStreamer(MusicStream musicStream, InputStream inputStream) {
        this.musicStream = musicStream;
        this.inputStream = inputStream;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[16384];
        try {
            int bytesRead;
            while ((bytesRead = this.inputStream.read(buffer)) != -1 && !Thread.interrupted()) {
                if (bytesRead <= 0) continue;
                this.musicStream.getByteStream().write(buffer, 0, bytesRead);
                this.musicStream.setBufferEnd(this.musicStream.getBufferEnd() + bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!Thread.interrupted()) {
            this.musicStream.setEndOfStream(true);
            if (this.musicStream.getAudioProcessor() != null && this.musicStream.getByteStream() != null) {
                this.musicStream.getAudioProcessor().processBuffer(this.musicStream.getByteStream().getBuffer(), 0, this.musicStream.getBufferEnd());
            }
        }
    }
}

