/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.system.network;

import com.mentalfrostbyte.Client;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.util.Util;

public class NetworkUtil {
    public static int getPlayerResponseTime() {
        for (NetworkPlayerInfo networkPlayer : Minecraft.getInstance().getConnection().getPlayerInfoMap()) {
            if (!networkPlayer.getGameProfile().getId().equals(Minecraft.getInstance().player.getUniqueID()) || Minecraft.getInstance().isIntegratedServerRunning()) continue;
            return networkPlayer.getResponseTime();
        }
        return 0;
    }

    public static boolean download(boolean finished) {
        if (!finished) {
            Util.OS osType = Util.getOSType();
            if (osType == Util.OS.WINDOWS || osType == Util.OS.OSX || osType == Util.OS.LINUX) {
                File musicDir = new File(String.valueOf(Client.getInstance().file) + "/music/");
                if (!musicDir.exists() && !musicDir.mkdirs()) {
                    System.out.println("Failed to create music directory.");
                    return false;
                }
                String fileName = osType == Util.OS.WINDOWS ? "yt-dlp.exe" : (osType == Util.OS.LINUX ? "yt-dlp_linux" : "yt-dlp_macos");
                File targetFile = new File(musicDir, fileName);
                try {
                    String urlString = "https://github.com/yt-dlp/yt-dlp/releases/latest/download/" + fileName;
                    System.out.println("Downloading yt-dlp from: " + urlString);
                    try (BufferedInputStream in = new BufferedInputStream(new URL(urlString).openStream());
                         FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
                        int bytesRead;
                        byte[] dataBuffer = new byte[1024];
                        while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                            fileOutputStream.write(dataBuffer, 0, bytesRead);
                        }
                    }
                    finished = true;
                    System.out.println("Finished downloading yt-dlp to " + targetFile.getAbsolutePath());
                }
                catch (IOException e) {
                    System.err.println("Error downloading yt-dlp: " + e.getMessage());
                    finished = false;
                }
            } else {
                System.out.println("Failed to extract yt-dlp, because your OS is unsupported.");
                finished = false;
            }
        }
        return finished;
    }
}

