/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.render;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import java.awt.Color;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class RenderUtil2
implements MinecraftUtil {
    public static final ResourceLocation BLUR_SHADER = new ResourceLocation("shaders/post/blur.json");

    public static int applyAlpha(int color, float alpha) {
        return (int)(alpha * 255.0f) << 24 | color & 0xFFFFFF;
    }

    public static int shiftTowardsBlack(int color, float shift) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int shiftedR = (int)((float)r * (1.0f - shift));
        int shiftedG = (int)((float)g * (1.0f - shift));
        int shiftedB = (int)((float)b * (1.0f - shift));
        return a << 24 | (shiftedR & 0xFF) << 16 | (shiftedG & 0xFF) << 8 | shiftedB & 0xFF;
    }

    public static int shiftTowardsOther(int color, int color2, float shift) {
        int a1 = color >> 24 & 0xFF;
        int r1 = color >> 16 & 0xFF;
        int g1 = color >> 8 & 0xFF;
        int b1 = color & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        float factor = 1.0f - shift;
        float shiftedA = (float)a1 * shift + (float)a2 * factor;
        float shiftedR = (float)r1 * shift + (float)r2 * factor;
        float shiftedG = (float)g1 * shift + (float)g2 * factor;
        float shiftedB = (float)b1 * shift + (float)b2 * factor;
        return (int)shiftedA << 24 | ((int)shiftedR & 0xFF) << 16 | ((int)shiftedG & 0xFF) << 8 | (int)shiftedB & 0xFF;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static float[] calculateAspectRatioFit(float sourceWidth, float sourceHeight, float targetWidth, float targetHeight) {
        float fittedHeight;
        float fittedWidth;
        float targetAspect = targetWidth / targetHeight;
        float sourceAspect = sourceWidth / sourceHeight;
        if (targetAspect > sourceAspect) {
            fittedWidth = targetWidth;
            fittedHeight = sourceHeight * targetWidth / sourceWidth;
        } else {
            fittedWidth = sourceWidth * targetHeight / sourceHeight;
            fittedHeight = targetHeight;
        }
        float offsetX = (targetWidth - fittedWidth) / 2.0f;
        float offsetY = (targetHeight - fittedHeight) / 2.0f;
        return new float[]{offsetX, offsetY, fittedWidth, fittedHeight};
    }

    public static void blur() {
        if (mc.getRenderViewEntity() instanceof PlayerEntity && Client.getInstance().guiManager.getGuiBlur()) {
            if (RenderUtil2.mc.gameRenderer.shaderGroup != null) {
                RenderUtil2.mc.gameRenderer.shaderGroup.close();
            }
            RenderUtil2.mc.gameRenderer.loadShader(BLUR_SHADER);
        }
        RenderUtil2.setShaderParams(20);
    }

    public static void setShaderParams(int radius) {
        if (RenderUtil2.mc.gameRenderer.shaderGroup != null) {
            RenderUtil2.mc.gameRenderer.shaderGroup.listShaders.get(0).getShaderManager().getShaderUniform("Radius").set(radius);
            RenderUtil2.mc.gameRenderer.shaderGroup.listShaders.get(1).getShaderManager().getShaderUniform("Radius").set(radius);
        }
    }

    public static void resetShaders() {
        if (RenderUtil2.mc.gameRenderer.shaderIndex == GameRenderer.SHADER_COUNT) {
            RenderUtil2.mc.gameRenderer.shaderGroup = null;
        } else {
            RenderUtil2.mc.gameRenderer.loadShader(GameRenderer.SHADERS_TEXTURES[RenderUtil2.mc.gameRenderer.shaderIndex]);
        }
    }

    public static float[] intColorToFloatArrayColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public static int adjustColorTowardsWhite(int original, float shift) {
        int a = original >> 24 & 0xFF;
        int r = original >> 16 & 0xFF;
        int g = original >> 8 & 0xFF;
        int b = original & 0xFF;
        int var8 = (int)((float)r + (float)(255 - r) * shift);
        int var9 = (int)((float)g + (float)(255 - g) * shift);
        int var10 = (int)((float)b + (float)(255 - b) * shift);
        return a << 24 | (var8 & 0xFF) << 16 | (var9 & 0xFF) << 8 | var10 & 0xFF;
    }

    public static Color calculateAverageColor(Color ... colors) {
        if (colors == null || colors.length == 0) {
            return Color.WHITE;
        }
        float weight = 1.0f / (float)colors.length;
        float totalRed = 0.0f;
        float totalGreen = 0.0f;
        float totalBlue = 0.0f;
        float totalAlpha = 0.0f;
        for (Color color : colors) {
            if (color == null) {
                color = Color.BLACK;
            }
            totalRed += (float)color.getRed() * weight;
            totalGreen += (float)color.getGreen() * weight;
            totalBlue += (float)color.getBlue() * weight;
            totalAlpha += (float)color.getAlpha() * weight;
        }
        return new Color(totalRed / 255.0f, totalGreen / 255.0f, totalBlue / 255.0f, totalAlpha / 255.0f);
    }

    public static Color blendColor(Color first, Color second, float factor) {
        float newFactor = 1.0f - factor;
        float blendedR = (float)first.getRed() * factor + (float)second.getRed() * newFactor;
        float blendedG = (float)first.getGreen() * factor + (float)second.getGreen() * newFactor;
        float blendedB = (float)first.getBlue() * factor + (float)second.getBlue() * newFactor;
        return new Color(blendedR / 255.0f, blendedG / 255.0f, blendedB / 255.0f);
    }

    public static void setShaderParamsRounded(float radius) {
        RenderUtil2.setShaderParams(Math.round(radius * 20.0f));
    }
}

