/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.render;

import com.mentalfrostbyte.jello.gui.combined.CustomGuiScreen;
import com.mentalfrostbyte.jello.gui.impl.jello.ingame.buttons.keybind.Keys;
import com.mentalfrostbyte.jello.managers.GuiManager;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.render.jello.esp.util.Class2329;
import com.mentalfrostbyte.jello.util.client.render.FontSizeAdjust;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import com.mentalfrostbyte.jello.util.game.player.PlayerUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.game.world.BoundingBox;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class RenderUtil
implements MinecraftUtil {
    public static boolean stencilOpInProgress = false;
    private static final Stack<IntBuffer> buffer = new Stack();
    public static boolean field18461 = false;

    public static void restoreScissor() {
        if (buffer.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            IntBuffer var2 = buffer.pop();
            GL11.glScissor((int)var2.get(0), (int)var2.get(1), (int)var2.get(2), (int)var2.get(3));
        }
    }

    public static void drawBlurredBackground(int var0, int var1, int var2, int var3) {
        RenderUtil.startScissor(var0, var1, var2, var3, false);
    }

    public static void method11436(float var0, float var1, float var2, int var3) {
        RenderUtil.method11445(var0, var1, 0.0f, 360.0f, var2 - 1.0f, var3);
    }

    public static void method11445(float var0, float var1, float var2, float var3, float var4, int var5) {
        RenderUtil.method11446(var0, var1, var2, var3, var4, var4, var5);
    }

    public static float getGuiScaleFactor() {
        return (float)RenderUtil.mc.mainWindow.getGuiScaleFactor();
    }

    public static void drawRect(double var0, double var2, double var4, double var6, int var8) {
        RenderUtil.drawRect((float)var0, (float)var2, (float)var4, (float)var6, var8);
    }

    public static void drawRect2(float var0, float var1, float var2, float var3, int var4) {
        RenderUtil.drawRect(var0, var1, var0 + var2, var1 + var3, var4);
    }

    public static void drawImage2(float var0, float var1, float var2, float var3, Texture var4, int var5, boolean var6) {
        RenderUtil.drawImage(var0, var1, var2, var3, var4, var5, 0.0f, 0.0f, var4.getImageWidth(), var4.getImageHeight(), var6);
    }

    public static void renderWireframeBox(BoundingBox boxIn, int color) {
        RenderUtil.renderWireframeBox(boxIn, 2.8f, color);
    }

    public static void renderWireframeBox(BoundingBox boxIn, float width, int color) {
        if (boxIn != null) {
            float var5 = (float)(color >> 24 & 0xFF) / 255.0f;
            float var6 = (float)(color >> 16 & 0xFF) / 255.0f;
            float var7 = (float)(color >> 8 & 0xFF) / 255.0f;
            float var8 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var5);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glLineWidth((float)width);
            GL11.glEnable((int)2848);
            GL11.glEnable((int)3042);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)1);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)2848);
            GL11.glDisable((int)3042);
        }
    }

    public static void method11476() {
        GL11.glPushMatrix();
        RenderUtil.resetDepthBuffer();
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)1);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)1);
        GL11.glClear((int)1024);
        field18461 = true;
    }

    public static void method11477(Class2329 var0) {
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)(var0 != Class2329.field15940 ? 517 : 514), (int)1, (int)1);
    }

    public static void method11478() {
        GL11.glStencilMask((int)-1);
        GL11.glDisable((int)2960);
        GL11.glPopMatrix();
        field18461 = false;
    }

    public static void method11446(float var0, float var1, float var2, float var3, float var4, float var5, int var6) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float var9 = 0.0f;
        if (var2 > var3) {
            var9 = var3;
            var3 = var2;
            var2 = var9;
        }
    }

    public static void drawItem(ItemStack itemStack, int posX, int posY, int width, int height) {
        if (itemStack != null) {
            mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)posX, (float)posY, (float)0.0f);
            GL11.glScalef((float)((float)width / 16.0f), (float)((float)height / 16.0f), (float)0.0f);
            ItemRenderer itemRenderer = mc.getItemRenderer();
            if (itemStack.count == 0) {
                itemStack = new ItemStack(itemStack.getItem());
            }
            RenderHelper.setupGuiFlatDiffuseLighting();
            GL11.glLightModelfv((int)2899, (float[])new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            RenderSystem.enableColorMaterial();
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthFunc((int)519);
            itemRenderer.renderItemIntoGUI(itemStack, 0, 0);
            GL11.glDepthFunc((int)515);
            RenderSystem.popMatrix();
            GL11.glAlphaFunc((int)519, (float)0.0f);
            RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
            RenderSystem.disableDepthTest();
            TextureImpl.unbind();
            mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
            RenderHelper.setupGui3DDiffuseLighting();
        }
    }

    public static void render3DColoredBox(BoundingBox boxIn, int color) {
        if (boxIn != null) {
            float var4 = (float)(color >> 24 & 0xFF) / 255.0f;
            float var5 = (float)(color >> 16 & 0xFF) / 255.0f;
            float var6 = (float)(color >> 8 & 0xFF) / 255.0f;
            float var7 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)var5, (float)var6, (float)var7, (float)var4);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glLineWidth((float)(1.8f * GuiManager.scaleFactor));
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2848);
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.maxY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.minZ);
            GL11.glVertex3d((double)boxIn.minX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glVertex3d((double)boxIn.maxX, (double)boxIn.minY, (double)boxIn.maxZ);
            GL11.glEnd();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)2848);
            GL11.glDisable((int)3042);
        }
    }

    public static float[] screenCoordinatesToOpenGLCoordinates(int x, int y) {
        FloatBuffer var4 = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)var4);
        float var5 = var4.get(0) * (float)x + var4.get(4) * (float)y + var4.get(8) * 0.0f + var4.get(12);
        float var6 = var4.get(1) * (float)x + var4.get(5) * (float)y + var4.get(9) * 0.0f + var4.get(13);
        float var7 = var4.get(3) * (float)x + var4.get(7) * (float)y + var4.get(11) * 0.0f + var4.get(15);
        return new float[]{Math.round((var5 /= var7) * RenderUtil.getGuiScaleFactor()), Math.round((var6 /= var7) * RenderUtil.getGuiScaleFactor())};
    }

    public static void method11430(double var0, double var2, double var4, double var6, double var8, int var10, int var11) {
        RenderUtil.drawRect(var0 + var8, var2 + var8, var4 - var8, var6 - var8, var10);
        RenderUtil.drawRect(var0 + var8, var2, var4 - var8, var2 + var8, var11);
        RenderUtil.drawRect(var0, var2, var0 + var8, var6, var11);
        RenderUtil.drawRect(var4 - var8, var2, var4, var6, var11);
        RenderUtil.drawRect(var0 + var8, var6 - var8, var4 - var8, var6, var11);
    }

    public static void startScissor(int x, int y, int width, int height, boolean scale) {
        if (!scale) {
            x = (int)((float)x * GuiManager.scaleFactor);
            y = (int)((float)y * GuiManager.scaleFactor);
            width = (int)((float)width * GuiManager.scaleFactor);
            height = (int)((float)height * GuiManager.scaleFactor);
        } else {
            float[] var7 = RenderUtil.screenCoordinatesToOpenGLCoordinates(x, y);
            x = (int)var7[0];
            y = (int)var7[1];
            float[] var8 = RenderUtil.screenCoordinatesToOpenGLCoordinates(width, height);
            width = (int)var8[0];
            height = (int)var8[1];
        }
        if (GL11.glIsEnabled((int)3089)) {
            IntBuffer var17 = BufferUtils.createIntBuffer((int)16);
            GL11.glGetIntegerv((int)3088, (IntBuffer)var17);
            buffer.push(var17);
            int var18 = var17.get(0);
            int var9 = mc.getMainWindow().getFramebufferHeight() - var17.get(1) - var17.get(3);
            int var10 = var18 + var17.get(2);
            int var11 = var9 + var17.get(3);
            if (x < var18) {
                x = var18;
            }
            if (y < var9) {
                y = var9;
            }
            if (width > var10) {
                width = var10;
            }
            if (height > var11) {
                height = var11;
            }
            if (y > height) {
                height = y;
            }
            if (x > width) {
                width = x;
            }
        }
        int adjustedY = mc.getMainWindow().getFramebufferHeight() - height;
        int width2 = width - x;
        int height2 = height - y;
        GL11.glEnable((int)3089);
        if (width2 >= 0 && height2 >= 0) {
            GL11.glScissor((int)x, (int)adjustedY, (int)width2, (int)height2);
        }
    }

    public static void drawRect(float var0, float var1, float var2, float var3, int var4) {
        if (var0 < var2) {
            int var7 = (int)var0;
            var0 = var2;
            var2 = var7;
        }
        if (var1 < var3) {
            int var13 = (int)var1;
            var1 = var3;
            var3 = var13;
        }
        float var14 = (float)(var4 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(var4 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(var4 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(var4 & 0xFF) / 255.0f;
        Tessellator var11 = Tessellator.getInstance();
        BufferBuilder var12 = var11.getBuffer();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f(var8, var9, var10, var14);
        var12.begin(7, DefaultVertexFormats.POSITION);
        var12.pos(var0, var3, 0.0).endVertex();
        var12.pos(var2, var3, 0.0).endVertex();
        var12.pos(var2, var1, 0.0).endVertex();
        var12.pos(var0, var1, 0.0).endVertex();
        var11.draw();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawImage(float x, float y, float width, float height, Texture tex, float alphaValue) {
        RenderUtil.drawImage(x, y, width, height, tex, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), alphaValue));
    }

    public static void drawImage(float x, float y, float width, float height, Texture texture) {
        RenderUtil.drawImage(x, y, width, height, texture, -1);
    }

    public static void drawImage(float x, float y, float width, float height, Texture texture, int color) {
        RenderUtil.drawImage(x, y, width, height, texture, color, 0.0f, 0.0f, texture.getImageWidth(), texture.getImageHeight(), true);
    }

    public static void drawImage(float x, float y, float width, float height, Texture texture, int color, boolean linearFiltering) {
        RenderUtil.drawImage(x, y, width, height, texture, color, 0.0f, 0.0f, texture.getImageWidth(), texture.getImageHeight(), linearFiltering);
    }

    public static void drawImage(float x, float y, float width, float height, Texture texture, int color, float tlX, float tlY, float siW, float siH) {
        RenderUtil.drawImage(x, y, width, height, texture, color, tlX, tlY, siW, siH, true);
    }

    public static void drawImage(float x, float y, float width, float height, Texture texture, int color, float tlX, float tlY, float siW, float siH, boolean linearFiltering) {
        if (texture != null) {
            RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            x = Math.round(x);
            width = Math.round(width);
            y = Math.round(y);
            height = Math.round(height);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.blendFuncSeparate(770, 771, 1, 0);
            RenderSystem.color4f(r, g, b, a);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            texture.bind();
            float var17 = width / (float)texture.getTextureWidth() / (width / (float)texture.getImageWidth());
            float var18 = height / (float)texture.getTextureHeight() / (height / (float)texture.getImageHeight());
            float var19 = siW / (float)texture.getImageWidth() * var17;
            float var20 = siH / (float)texture.getImageHeight() * var18;
            float var21 = tlX / (float)texture.getImageWidth() * var17;
            float var22 = tlY / (float)texture.getImageHeight() * var18;
            if (!linearFiltering) {
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            } else {
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)var21, (float)var22);
            GL11.glVertex2f((float)x, (float)y);
            GL11.glTexCoord2f((float)var21, (float)(var22 + var20));
            GL11.glVertex2f((float)x, (float)(y + height));
            GL11.glTexCoord2f((float)(var21 + var19), (float)(var22 + var20));
            GL11.glVertex2f((float)(x + width), (float)(y + height));
            GL11.glTexCoord2f((float)(var21 + var19), (float)var22);
            GL11.glVertex2f((float)(x + width), (float)y);
            GL11.glEnd();
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    public static void drawCircle(boolean isFadingOut, float circleHeight, float radius, float glowStrength, float glowOpacity) {
        double z;
        double x;
        int effectiveAngle;
        int angle;
        RenderSystem.shadeModel(7425);
        GL11.glDisable((int)32823);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)8);
        int angleStep = (int)(360.0f / (40.0f * radius));
        Module moduleInstance = new Module(ModuleCategory.PLAYER, "ESP COLOR", "");
        java.awt.Color espColor = new java.awt.Color(moduleInstance.parseSettingValueToIntBySettingName("ESP Color"));
        float red = (float)espColor.getRed() / 255.0f;
        float green = (float)espColor.getGreen() / 255.0f;
        float blue = (float)espColor.getBlue() / 255.0f;
        for (angle = 0; angle <= 360 + angleStep; angle += angleStep) {
            effectiveAngle = angle > 360 ? 0 : angle;
            x = Math.sin(Math.toRadians(effectiveAngle)) * (double)radius;
            z = Math.cos(Math.toRadians(effectiveAngle)) * (double)radius;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)(isFadingOut ? 0.0f : glowStrength * glowOpacity));
            GL11.glVertex3d((double)x, (double)0.0, (double)z);
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)(isFadingOut ? glowStrength * glowOpacity : 0.0f));
            GL11.glVertex3d((double)x, (double)circleHeight, (double)z);
        }
        GL11.glEnd();
        GL11.glLineWidth((float)2.2f);
        GL11.glBegin((int)2);
        for (angle = 0; angle <= 360 + angleStep; angle += angleStep) {
            effectiveAngle = angle > 360 ? 0 : angle;
            x = Math.sin(Math.toRadians(effectiveAngle)) * (double)radius;
            z = Math.cos(Math.toRadians(effectiveAngle)) * (double)radius;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)((0.5f + 0.5f * glowStrength) * glowOpacity));
            GL11.glVertex3d((double)x, (double)(isFadingOut ? 0.0 : (double)circleHeight), (double)z);
        }
        GL11.glEnd();
        GL11.glEnable((int)2929);
        RenderSystem.shadeModel(7424);
    }

    public static void drawRoundedRect2(float x, float y, float width, float height, int color) {
        RenderUtil.drawRoundedRect(x, y, x + width, y + height, color);
    }

    public static void drawRoundedRect(float x, float y, float width, float height, float size, int color) {
        RenderUtil.drawRoundedRect(x, y + size, x + width, y + height - size, color);
        RenderUtil.drawRoundedRect(x + size, y, x + width - size, y + size, color);
        RenderUtil.drawRoundedRect(x + size, y + height - size, x + width - size, y + height, color);
        RenderUtil.drawBlurredBackground(x, y, x + size, y + size);
        RenderUtil.drawCircle(x + size, y + size, size * 2.0f, color);
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(x + width - size, y, x + width, y + size);
        RenderUtil.drawCircle(x - size + width, y + size, size * 2.0f, color);
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(x, y + height - size, x + size, y + height);
        RenderUtil.drawCircle(x + size, y - size + height, size * 2.0f, color);
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(x + width - size, y + height - size, x + width, y + height);
        RenderUtil.drawCircle(x - size + width, y - size + height, size * 2.0f, color);
        RenderUtil.restoreScissor();
    }

    public static void drawBlurredBackground(float x, float y, float width, float height) {
        RenderUtil.startScissor((int)x, (int)y, (int)width, (int)height, true);
    }

    public static void drawCircle(float centerX, float centerY, float size, int color) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator var10 = Tessellator.getInstance();
        BufferBuilder var11 = var10.getBuffer();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        RenderSystem.color4f(r, g, b, a);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glPointSize((float)(size * GuiManager.scaleFactor));
        GL11.glBegin((int)0);
        GL11.glVertex2f((float)centerX, (float)centerY);
        GL11.glEnd();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRect(float x, float y, float sizedX, float sizedY, int color) {
        if (x < sizedX) {
            int var7 = (int)x;
            x = sizedX;
            sizedX = var7;
        }
        if (y < sizedY) {
            int var13 = (int)y;
            y = sizedY;
            sizedY = var13;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator var11 = Tessellator.getInstance();
        BufferBuilder var12 = var11.getBuffer();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f(r, g, b, a);
        var12.begin(7, DefaultVertexFormats.POSITION);
        var12.pos(x, sizedY, 0.0).endVertex();
        var12.pos(sizedX, sizedY, 0.0).endVertex();
        var12.pos(sizedX, y, 0.0).endVertex();
        var12.pos(x, y, 0.0).endVertex();
        var11.draw();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawString(TrueTypeFont res, float var1, float var2, String string, int var4, FontSizeAdjust var5, FontSizeAdjust var6) {
        RenderUtil.drawString(res, var1, var2, string, var4, var5, var6, false);
    }

    public static void drawString(TrueTypeFont font, float x, float y, String text, int color, FontSizeAdjust widthAdjust, FontSizeAdjust heightAdjust, boolean var7) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        int adjustedWidth = 0;
        int adjustedHeight = 0;
        adjustedWidth = switch (widthAdjust) {
            case FontSizeAdjust.NEGATE_AND_DIVIDE_BY_2 -> -font.getWidth(text) / 2;
            case FontSizeAdjust.WIDTH_NEGATE -> -font.getWidth(text);
            default -> adjustedWidth;
        };
        adjustedHeight = switch (heightAdjust) {
            case FontSizeAdjust.NEGATE_AND_DIVIDE_BY_2 -> -font.getHeight(text) / 2;
            case FontSizeAdjust.HEIGHT_NEGATE -> -font.getHeight(text);
            default -> adjustedHeight;
        };
        float var12 = (float)(color >> 24 & 0xFF) / 255.0f;
        float var13 = (float)(color >> 16 & 0xFF) / 255.0f;
        float var14 = (float)(color >> 8 & 0xFF) / 255.0f;
        float var15 = (float)(color & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        boolean var16 = false;
        if ((double)GuiManager.scaleFactor == 2.0) {
            if (font == ResourceRegistry.JelloLightFont20) {
                font = ResourceRegistry.JelloLightFont40;
            } else if (font == ResourceRegistry.JelloLightFont25) {
                font = ResourceRegistry.JelloLightFont50;
            } else if (font == ResourceRegistry.JelloLightFont12) {
                font = ResourceRegistry.JelloLightFont24;
            } else if (font == ResourceRegistry.JelloLightFont14) {
                font = ResourceRegistry.JelloLightFont28;
            } else if (font == ResourceRegistry.JelloLightFont18) {
                font = ResourceRegistry.JelloLightFont36;
            } else if (font == ResourceRegistry.RegularFont20) {
                font = ResourceRegistry.RegularFont40;
            } else if (font == ResourceRegistry.JelloMediumFont20) {
                font = ResourceRegistry.JelloMediumFont40;
            } else if (font == ResourceRegistry.JelloMediumFont25) {
                font = ResourceRegistry.JelloMediumFont50;
            } else {
                var16 = true;
            }
            if (!var16) {
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glScalef((float)(1.0f / GuiManager.scaleFactor), (float)(1.0f / GuiManager.scaleFactor), (float)(1.0f / GuiManager.scaleFactor));
                GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
                adjustedWidth = (int)((float)adjustedWidth * GuiManager.scaleFactor);
                adjustedHeight = (int)((float)adjustedHeight * GuiManager.scaleFactor);
            }
        }
        RenderSystem.enableBlend();
        GL11.glBlendFunc((int)770, (int)771);
        if (var7) {
            font.drawString(Math.round(x + (float)adjustedWidth), Math.round(y + (float)adjustedHeight) + 2, text, new Color(0.0f, 0.0f, 0.0f, 0.35f));
        }
        if (text != null) {
            font.drawString(Math.round(x + (float)adjustedWidth), Math.round(y + (float)adjustedHeight), text, new Color(var13, var14, var15, var12));
        }
        RenderSystem.disableBlend();
        GL11.glPopMatrix();
    }

    public static void method11415(CustomGuiScreen var0) {
        RenderUtil.startScissor(var0.getXA(), var0.getYA(), var0.getWidthA() + var0.getXA(), var0.getHeightA() + var0.getYA(), true);
    }

    public static void drawRoundedButton(float var0, float var1, float var2, float var3, float var4, int color) {
        RenderUtil.drawRoundedRect(var0, var1 + var4, var0 + var2, var1 + var3 - var4, color);
        RenderUtil.drawRoundedRect(var0 + var4, var1, var0 + var2 - var4, var1 + var3, color);
        FloatBuffer var8 = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)var8);
        float var9 = 1.0f;
        RenderUtil.drawCircle(var0 + var4, var1 + var4, var4 * 2.0f * var9, color);
        RenderUtil.drawCircle(var0 - var4 + var2, var1 + var4, var4 * 2.0f * var9, color);
        RenderUtil.drawCircle(var0 + var4, var1 - var4 + var3, var4 * 2.0f * var9, color);
        RenderUtil.drawCircle(var0 - var4 + var2, var1 - var4 + var3, var4 * 2.0f * var9, color);
    }

    public static void drawString(TrueTypeFont font, float x, float y, String text, int color) {
        RenderUtil.drawString(font, x, y, text, color, FontSizeAdjust.field14488, FontSizeAdjust.field14489, false);
    }

    public static void drawRoundedRect(float var0, float var1, float var2, float var3, float var4, float var5) {
        GL11.glAlphaFunc((int)519, (float)0.0f);
        int var8 = RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), var5);
        RenderUtil.drawImage(var0 - var4, var1 - var4, var4, var4, Resources.shadowCorner1PNG, var8);
        RenderUtil.drawImage(var0 + var2, var1 - var4, var4, var4, Resources.shadowCorner2PNG, var8);
        RenderUtil.drawImage(var0 - var4, var1 + var3, var4, var4, Resources.shadowCorner3PNG, var8);
        RenderUtil.drawImage(var0 + var2, var1 + var3, var4, var4, Resources.shadowCorner4PNG, var8);
        RenderUtil.drawImage(var0 - var4, var1, var4, var3, Resources.shadowLeftPNG, var8, false);
        RenderUtil.drawImage(var0 + var2, var1, var4, var3, Resources.shadowRightPNG, var8, false);
        RenderUtil.drawImage(var0, var1 - var4, var2, var4, Resources.shadowTopPNG, var8, false);
        RenderUtil.drawImage(var0, var1 + var3, var2, var4, Resources.shadowBottomPNG, var8, false);
    }

    public static void startScissor(float var0, float var1, float var2, float var3) {
        RenderUtil.startScissor((int)var0, (int)var1, (int)var0 + (int)var2, (int)var1 + (int)var3, true);
    }

    public static void method11465(int var0, int var1, int var2, int var3, int var4) {
        RenderUtil.method11466(var0, var1, var2, var3, var4, var0, var1);
    }

    public static void method11466(int var0, int var1, int var2, int var3, int var4, int var5, int var6) {
        int var9 = 36;
        int var10 = 10;
        int var11 = var9 - var10;
        RenderUtil.drawRoundedRect(var0 + var10, var1 + var10, var0 + var2 - var10, var1 + var3 - var10, var4);
        RenderUtil.drawImage((float)(var0 - var11), (float)(var1 - var11), (float)var9, (float)var9, Resources.floatingCornerPNG, var4);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 + var2 - var9 / 2), (float)(var1 + var9 / 2), (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var2 - var9 / 2), (float)(-var1 - var9 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var2 - var11), (float)(var1 - var11), (float)var9, (float)var9, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 + var2 - var9 / 2), (float)(var1 + var3 + var9 / 2), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var2 - var9 / 2), (float)(-var1 - var3 - var9 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var2 - var11), (float)(var1 + var10 + var3), (float)var9, (float)var9, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 - var9 / 2), (float)(var1 + var3 + var9 / 2), (float)0.0f);
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var9 / 2), (float)(-var1 - var3 - var9 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var10), (float)(var1 + var10 + var3), (float)var9, (float)var9, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        RenderUtil.drawBlurredBackground(var5 - var9, var6 + var10, var5 - var11 + var9, var6 - var10 + var3);
        for (int var12 = 0; var12 < var3; var12 += var9) {
            RenderUtil.drawImage((float)(var0 - var11), (float)(var1 + var10 + var12), (float)var9, (float)var9, Resources.floatingBorderPNG, var4);
        }
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(var5, var6 - var11, var5 + var2 - var10, var6 + var10);
        for (int var13 = 0; var13 < var2; var13 += var9) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var9 / 2), (float)(var1 + var9 / 2), (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var9 / 2), (float)(-var1 - var9 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var11), (float)(var1 - var10 - var13), (float)var9, (float)var9, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(var5 + var2 - var10, var6 - var11, var0 + var2 + var11, var6 + var3 - var10);
        for (int var14 = 0; var14 < var3; var14 += var9) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var9 / 2), (float)(var1 + var9 / 2), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var9 / 2), (float)(-var1 - var9 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var2 + var10), (float)(var1 - var10 - var14), (float)var9, (float)var9, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
        RenderUtil.drawBlurredBackground(var5 - var10, var6 - var11 + var3 - var9, var5 + var2 - var10, var6 + var3 + var10 * 2);
        for (int var15 = 0; var15 < var2; var15 += var9) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var9 / 2), (float)(var1 + var9 / 2), (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var9 / 2), (float)(-var1 - var9 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var3 + var10), (float)(var1 + var10 + var15), (float)var9, (float)var9, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
    }

    public static void drawTexture(float x, float y, float width, float height, Texture texture, int color) {
        if (texture == null) {
            return;
        }
        RenderUtil.drawImage(x, y, width, height, texture, color, 0.0f, 0.0f, texture.getImageWidth(), texture.getImageHeight(), true);
        RenderUtil.drawImage(x, y, width, height, texture, color, 0.0f, 0.0f, texture.getImageWidth(), texture.getImageHeight(), false);
    }

    public static Rectangle method11413(Rectangle var0, float var1, float var2) {
        float var5 = var0.x;
        float var6 = var0.y;
        float var7 = var0.width;
        float var8 = var0.height;
        int var9 = Math.round(var7 * var1);
        int var10 = Math.round(var8 * var2);
        float var11 = var7 - (float)var9;
        float var12 = var8 - (float)var10;
        int var13 = Math.round(var5 + var11 / 4.0f);
        int var14 = Math.round(var6 + var12 / 6.0f);
        return new Rectangle(var13, var14, var9, var10);
    }

    public static Rectangle method11414(CustomGuiScreen var0) {
        return new Rectangle(var0.getXA(), var0.getYA(), var0.getWidthA(), var0.getHeightA());
    }

    public static void method11457(float var0, float var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        var0 = Math.round(var0);
        var2 = Math.round(var2);
        var1 = Math.round(var1);
        var3 = Math.round(var3);
        float var11 = (float)(var4 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(var4 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(var4 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(var4 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        RenderSystem.color4f(var12, var13, var14, var11);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        float var16 = 1.0f;
        float var17 = 1.0f;
        float var18 = var5 / var7;
        float var19 = var6 / var8;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)var18, (float)var19);
        GL11.glVertex2f((float)var0, (float)var1);
        GL11.glTexCoord2f((float)var18, (float)(var19 + var17));
        GL11.glVertex2f((float)var0, (float)(var1 + var3));
        GL11.glTexCoord2f((float)(var18 + var16), (float)(var19 + var17));
        GL11.glVertex2f((float)(var0 + var2), (float)(var1 + var3));
        GL11.glTexCoord2f((float)(var18 + var16), (float)var19);
        GL11.glVertex2f((float)(var0 + var2), (float)var1);
        GL11.glEnd();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void method11464(float var0, float var1, float var2, float var3, float var4, float var5) {
        int var8 = RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), var5);
        RenderUtil.drawImage(var0, var1, var4, var3, Resources.shadowRightPNG, var8, false);
        RenderUtil.drawImage(var0 + var2 - var4, var1, var4, var3, Resources.shadowLeftPNG, var8, false);
        RenderUtil.drawImage(var0, var1, var2, var4, Resources.shadowBottomPNG, var8, false);
        RenderUtil.drawImage(var0, var1 + var3 - var4, var2, var4, Resources.shadowTopPNG, var8, false);
    }

    public static void method11467(int var0, int var1, int var2, int var3, int var4) {
        int var7 = 36;
        int var8 = 10;
        int var9 = var7 - var8;
        RenderUtil.drawRoundedRect(var0 + var8, var1 + var8, var0 + var2 - var8, var1 + var3 - var8, var4);
        RenderUtil.drawImage((float)(var0 - var9), (float)(var1 - var9), (float)var7, (float)var7, Resources.floatingCornerPNG, var4);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 + var2 - var7 / 2), (float)(var1 + var7 / 2), (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var2 - var7 / 2), (float)(-var1 - var7 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var2 - var9), (float)(var1 - var9), (float)var7, (float)var7, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 + var2 - var7 / 2), (float)(var1 + var3 + var7 / 2), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var2 - var7 / 2), (float)(-var1 - var3 - var7 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var2 - var9), (float)(var1 + var8 + var3), (float)var7, (float)var7, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(var0 - var7 / 2), (float)(var1 + var3 + var7 / 2), (float)0.0f);
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-var0 - var7 / 2), (float)(-var1 - var3 - var7 / 2), (float)0.0f);
        RenderUtil.drawImage((float)(var0 + var8), (float)(var1 + var8 + var3), (float)var7, (float)var7, Resources.floatingCornerPNG, var4);
        GL11.glPopMatrix();
        RenderUtil.startScissor(var0 - var7, var1 + var8, var0 - var9 + var7, var1 - var8 + var3, true);
        for (int var10 = 0; var10 < var3; var10 += var7) {
            RenderUtil.drawImage((float)(var0 - var9), (float)(var1 + var8 + var10) - 0.4f, (float)var7, (float)var7 + 0.4f, Resources.floatingBorderPNG, var4);
        }
        RenderUtil.restoreScissor();
        RenderUtil.startScissor(var0, var1 - var9, var0 + var2 - var8, var1 + var8, true);
        for (int var11 = 0; var11 < var2; var11 += var7) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var7 / 2), (float)(var1 + var7 / 2), (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var7 / 2), (float)(-var1 - var7 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var9), (float)(var1 - var8 - var11) - 0.4f, (float)var7, (float)var7 + 0.4f, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
        RenderUtil.startScissor(var0 + var2 - var8, var1 - var9, var0 + var2 + var9, var1 + var3 - var8, true);
        for (int var12 = 0; var12 < var3; var12 += var7) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var7 / 2), (float)(var1 + var7 / 2), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var7 / 2), (float)(-var1 - var7 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var2 + var8), (float)(var1 - var8 - var12) - 0.4f, (float)var7, (float)var7 + 0.4f, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
        RenderUtil.startScissor(var0 - var8, var1 - var9 + var3 - var7, var0 + var2 - var8, var1 + var3 + var8 * 2, true);
        for (int var13 = 0; var13 < var2; var13 += var7) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var0 + var7 / 2), (float)(var1 + var7 / 2), (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-var0 - var7 / 2), (float)(-var1 - var7 / 2), (float)0.0f);
            RenderUtil.drawImage((float)(var0 - var3 + var8), (float)(var1 + var8 + var13) - 0.4f, (float)var7, (float)var7 + 0.4f, Resources.floatingBorderPNG, var4);
            GL11.glPopMatrix();
        }
        RenderUtil.restoreScissor();
    }

    public static void drawFilledArc(float var0, float var1, float var2, int var3) {
        RenderUtil.drawFilledArc(var0, var1, 0.0f, 360.0f, var2 - 1.0f, var3);
    }

    public static void drawFilledArc(float var0, float var1, float var2, float var3, float var4, int var5) {
        RenderUtil.drawFilledArc(var0, var1, var2, var3, var4, var4, var5);
    }

    public static void drawFilledArc(float x, float y, float startAngle, float endAngle, float hRadius, float vRadius, int color) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float var9 = 0.0f;
        if (startAngle > endAngle) {
            var9 = endAngle;
            endAngle = startAngle;
            startAngle = var9;
        }
        float var10 = (float)(color >> 24 & 0xFF) / 255.0f;
        float var11 = (float)(color >> 16 & 0xFF) / 255.0f;
        float var12 = (float)(color >> 8 & 0xFF) / 255.0f;
        float var13 = (float)(color & 0xFF) / 255.0f;
        Tessellator var14 = Tessellator.getInstance();
        BufferBuilder var15 = var14.getBuffer();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        RenderSystem.color4f(var11, var12, var13, var10);
        if (var10 > 0.5f) {
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            for (float var16 = endAngle; var16 >= startAngle; var16 -= 4.0f) {
                float var17 = (float)Math.cos((double)var16 * Math.PI / 180.0) * hRadius * 1.001f;
                float var18 = (float)Math.sin((double)var16 * Math.PI / 180.0) * vRadius * 1.001f;
                GL11.glVertex2f((float)(x + var17), (float)(y + var18));
            }
            GL11.glEnd();
            GL11.glDisable((int)2848);
        }
        GL11.glBegin((int)6);
        for (float var20 = endAngle; var20 >= startAngle; var20 -= 4.0f) {
            float var21 = (float)Math.cos((double)var20 * Math.PI / 180.0) * hRadius;
            float var22 = (float)Math.sin((double)var20 * Math.PI / 180.0) * vRadius;
            GL11.glVertex2f((float)(x + var21), (float)(y + var22));
        }
        GL11.glEnd();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static String getKeyName(int var0) {
        for (Keys var6 : Keys.values()) {
            if (var6.row != var0) continue;
            return var6.name;
        }
        InputMappings.Input var7 = InputMappings.getInputByCode(var0, 0);
        String[] var8 = var7.getTranslationKey().split("\\.");
        if (var8.length != 0) {
            String var9 = var8[var8.length - 1];
            if (!var9.isEmpty()) {
                String var10 = "";
                if (var0 <= 4) {
                    var10 = "Mouse ";
                }
                return var10 + var9.substring(0, 1).toUpperCase() + var9.substring(1);
            }
            return "Unknown";
        }
        return "Unknown";
    }

    public static void method11429(float var0, float var1, float var2, float var3, int var4, int var5) {
        RenderUtil.drawRoundedRect(var0, var3 - (float)var4, var2 - (float)var4, var3, var5);
        RenderUtil.drawRoundedRect(var0, var1, var2 - (float)var4, var1 + (float)var4, var5);
        RenderUtil.drawRoundedRect(var0, var1 + (float)var4, var0 + (float)var4, var3 - (float)var4, var5);
        RenderUtil.drawRoundedRect(var2 - (float)var4, var1, var2, var3, var5);
    }

    public static void method11434(float var0, float var1, float var2, float var3, float var4, float var5, int var6) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float var9 = (float)(var6 >> 24 & 0xFF) / 255.0f;
        float var10 = (float)(var6 >> 16 & 0xFF) / 255.0f;
        float var11 = (float)(var6 >> 8 & 0xFF) / 255.0f;
        float var12 = (float)(var6 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        RenderSystem.color4f(var10, var11, var12, var9);
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)var0, (float)var1);
        GL11.glVertex2f((float)var4, (float)var5);
        GL11.glVertex2f((float)var2, (float)var3);
        GL11.glVertex2f((float)var0, (float)var1);
        GL11.glEnd();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void method11428(float var0, float var1, float var2, float var3, int var4) {
        RenderUtil.method11429(var0, var1, var2, var3, 1, var4);
    }

    public static void method11431(int var0, int var1, int var2, int var3, int var4, int var5) {
        float var8 = (float)(var4 >> 24 & 0xFF) / 255.0f;
        float var9 = (float)(var4 >> 16 & 0xFF) / 255.0f;
        float var10 = (float)(var4 >> 8 & 0xFF) / 255.0f;
        float var11 = (float)(var4 & 0xFF) / 255.0f;
        float var12 = (float)(var5 >> 24 & 0xFF) / 255.0f;
        float var13 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var14 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var15 = (float)(var5 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel(7425);
        Tessellator var16 = Tessellator.getInstance();
        BufferBuilder var17 = var16.getBuffer();
        var17.begin(7, DefaultVertexFormats.POSITION_COLOR);
        var17.pos(var2, var1, 0.0).color(var9, var10, var11, var8).endVertex();
        var17.pos(var0, var1, 0.0).color(var9, var10, var11, var8).endVertex();
        var17.pos(var0, var3, 0.0).color(var13, var14, var15, var12).endVertex();
        var17.pos(var2, var3, 0.0).color(var13, var14, var15, var12).endVertex();
        var16.draw();
        RenderSystem.shadeModel(7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawQuad(int x1, int y1, int x2, int y2, int color, int color2, int color3, int color4) {
        float a1 = (float)(color >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        float a3 = (float)(color3 >> 24 & 0xFF) / 255.0f;
        float r3 = (float)(color3 >> 16 & 0xFF) / 255.0f;
        float g3 = (float)(color3 >> 8 & 0xFF) / 255.0f;
        float b3 = (float)(color3 & 0xFF) / 255.0f;
        float a4 = (float)(color4 >> 24 & 0xFF) / 255.0f;
        float r4 = (float)(color4 >> 16 & 0xFF) / 255.0f;
        float g4 = (float)(color4 >> 8 & 0xFF) / 255.0f;
        float b4 = (float)(color4 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel(7425);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder var27 = tessellator.getBuffer();
        var27.begin(7, DefaultVertexFormats.POSITION_COLOR);
        var27.pos(x2, y1, 0.0).color(r2, g2, b2, a2).endVertex();
        var27.pos(x1, y1, 0.0).color(r1, g1, b1, a1).endVertex();
        var27.pos(x1, y2, 0.0).color(r4, g4, b4, a4).endVertex();
        var27.pos(x2, y2, 0.0).color(r3, g3, b3, a3).endVertex();
        tessellator.draw();
        RenderSystem.shadeModel(7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void renderCategoryBox(float x, float y, float size, int color, int outlineColor) {
        RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        GL11.glColor4fv((float[])RenderUtil2.intColorToFloatArrayColor(color));
        GL11.glEnable((int)2881);
        GL11.glBegin((int)4);
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y + size / 2.0f));
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y - size / 2.0f));
        GL11.glVertex2f((float)(x - size / 2.0f), (float)y);
        GL11.glEnd();
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4fv((float[])RenderUtil2.intColorToFloatArrayColor(outlineColor));
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y + size / 2.0f));
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y - size / 2.0f));
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x - size / 2.0f), (float)y);
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y - size / 2.0f));
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x + size / 2.0f), (float)(y + size / 2.0f));
        GL11.glVertex2f((float)(x - size / 2.0f), (float)y);
        GL11.glEnd();
        GL11.glDisable((int)2881);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void recreateDepthBuffer(Framebuffer frameBuffer) {
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)frameBuffer.depthBuffer);
        int newDepthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)newDepthBuffer);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)34041, (int)Minecraft.getInstance().getMainWindow().getFramebufferWidth(), (int)Minecraft.getInstance().getMainWindow().getFramebufferHeight());
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36128, (int)36161, (int)newDepthBuffer);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)newDepthBuffer);
    }

    public static void resetDepthBuffer() {
        Framebuffer currentFramebuffer = Minecraft.getInstance().getFramebuffer();
        if (currentFramebuffer != null && currentFramebuffer.depthBuffer > -1) {
            RenderUtil.recreateDepthBuffer(currentFramebuffer);
            currentFramebuffer.depthBuffer = -1;
        }
    }

    public static void initStencilBuffer() {
        GL11.glPushMatrix();
        RenderUtil.resetDepthBuffer();
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)1);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)1);
        GL11.glClear((int)1024);
        stencilOpInProgress = true;
    }

    public static void restorePreviousStencilBuffer() {
        GL11.glStencilMask((int)-1);
        GL11.glDisable((int)2960);
        GL11.glPopMatrix();
        stencilOpInProgress = false;
    }

    public static void configureStencilTest() {
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
    }

    public static void method11453(float var0, float var1, float var2, float var3, ByteBuffer var4, int color, float var6, float var7, float var8, float var9, boolean var10, boolean var11) {
        if (var4 != null) {
            RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            var0 = Math.round(var0);
            var2 = Math.round(var2);
            var1 = Math.round(var1);
            var3 = Math.round(var3);
            float b = (float)(color >> 24 & 0xFF) / 255.0f;
            float a = (float)(color >> 16 & 0xFF) / 255.0f;
            float r = (float)(color >> 8 & 0xFF) / 255.0f;
            float g = (float)(color & 0xFF) / 255.0f;
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.blendFuncSeparate(770, 771, 1, 0);
            RenderSystem.color4f(a, r, g, b);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glPixelStorei((int)3312, (int)0);
            GL11.glPixelStorei((int)3313, (int)0);
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3317, (int)4);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)((int)var8), (int)((int)var9), (int)0, (int)6407, (int)5121, (ByteBuffer)var4);
            float var19 = 1.0f;
            float var20 = 1.0f;
            float var21 = var6 / var8;
            float var22 = var7 / var9;
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)(var21 + (!var10 ? 0.0f : var19)), (float)(var22 + (!var11 ? 0.0f : var20)));
            GL11.glVertex2f((float)var0, (float)var1);
            GL11.glTexCoord2f((float)(var21 + (!var10 ? 0.0f : var19)), (float)(var22 + (!var11 ? var20 : 0.0f)));
            GL11.glVertex2f((float)var0, (float)(var1 + var3));
            GL11.glTexCoord2f((float)(var21 + (!var10 ? var19 : 0.0f)), (float)(var22 + (!var11 ? var20 : 0.0f)));
            GL11.glVertex2f((float)(var0 + var2), (float)(var1 + var3));
            GL11.glTexCoord2f((float)(var21 + (!var10 ? var19 : 0.0f)), (float)(var22 + (!var11 ? 0.0f : var20)));
            GL11.glVertex2f((float)(var0 + var2), (float)var1);
            GL11.glEnd();
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    public static void renderItem(ItemStack var0, int var1, int var2, int var3, int var4) {
        if (var0 != null) {
            mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)var1, (float)var2, (float)0.0f);
            GL11.glScalef((float)((float)var3 / 16.0f), (float)((float)var4 / 16.0f), (float)0.0f);
            ItemRenderer var7 = mc.getItemRenderer();
            if (var0.getCount() == 0) {
                var0 = new ItemStack(var0.getItem());
            }
            RenderHelper.setupGuiFlatDiffuseLighting();
            GL11.glLightModelfv((int)2899, (float[])new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            RenderSystem.enableColorMaterial();
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthFunc((int)519);
            var7.renderItemIntoGUI(var0, 0, 0);
            GL11.glDepthFunc((int)515);
            RenderSystem.popMatrix();
            GL11.glAlphaFunc((int)519, (float)0.0f);
            RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
            RenderSystem.disableDepthTest();
            TextureImpl.unbind();
            mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
            RenderHelper.setupGui3DDiffuseLighting();
        }
    }

    public static double[] worldToScreen(double x, double y, double z) {
        double[] dArray;
        FloatBuffer screenCoords = BufferUtils.createFloatBuffer((int)3);
        IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
        FloatBuffer modelViewMatrix = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer projectionMatrix = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)modelViewMatrix);
        GL11.glGetFloatv((int)2983, (FloatBuffer)projectionMatrix);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        boolean isSuccessful = RenderUtil.projectToScreen((float)x, (float)y, (float)z, modelViewMatrix, projectionMatrix, viewport, screenCoords);
        if (!isSuccessful) {
            dArray = null;
        } else {
            double[] dArray2 = new double[3];
            dArray2[0] = screenCoords.get(0) / GuiManager.scaleFactor;
            dArray2[1] = ((float)RenderUtil.mc.getFramebuffer().framebufferHeight - screenCoords.get(1)) / GuiManager.scaleFactor;
            dArray = dArray2;
            dArray2[2] = screenCoords.get(2);
        }
        return dArray;
    }

    public static java.awt.Color getColorFromScreen(int mouseX, int mouseY, java.awt.Color var2) {
        mouseX = (int)((float)mouseX * GuiManager.scaleFactor);
        mouseY = (int)((float)mouseY * GuiManager.scaleFactor);
        ByteBuffer var5 = ByteBuffer.allocateDirect(3);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glReadPixels((int)mouseX, (int)(Minecraft.getInstance().getMainWindow().getFramebufferHeight() - mouseY), (int)1, (int)1, (int)6407, (int)5120, (ByteBuffer)var5);
        return new java.awt.Color(var5.get(0) * 2, var5.get(1) * 2, var5.get(2) * 2, 1);
    }

    public static int applyAlpha(int color, float alpha) {
        return (int)(alpha * 255.0f) << 24 | color & 0xFFFFFF;
    }

    public static boolean projectToScreen(float x, float y, float z, FloatBuffer modelMatrix, FloatBuffer projectionMatrix, IntBuffer viewport, FloatBuffer screenCoords) {
        float[] inVector = PlayerUtil.field24951;
        float[] outVector = PlayerUtil.field24952;
        inVector[0] = x;
        inVector[1] = y;
        inVector[2] = z;
        inVector[3] = 1.0f;
        RenderUtil.transformVector(modelMatrix, inVector, outVector);
        RenderUtil.transformVector(projectionMatrix, outVector, inVector);
        if ((double)inVector[3] != 0.0) {
            inVector[3] = 1.0f / inVector[3] * 0.5f;
            inVector[0] = inVector[0] * inVector[3] + 0.5f;
            inVector[1] = inVector[1] * inVector[3] + 0.5f;
            inVector[2] = inVector[2] * inVector[3] + 0.5f;
            screenCoords.put(0, inVector[0] * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position()));
            screenCoords.put(1, inVector[1] * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1));
            screenCoords.put(2, inVector[2]);
            return true;
        }
        return false;
    }

    public static float[] method17709(int var0) {
        float var3 = (float)(var0 >> 24 & 0xFF) / 255.0f;
        float var4 = (float)(var0 >> 16 & 0xFF) / 255.0f;
        float var5 = (float)(var0 >> 8 & 0xFF) / 255.0f;
        float var6 = (float)(var0 & 0xFF) / 255.0f;
        return new float[]{var4, var5, var6, var3};
    }

    public static int method17691(int var0, float var1) {
        int var4 = var0 >> 24 & 0xFF;
        int var5 = var0 >> 16 & 0xFF;
        int var6 = var0 >> 8 & 0xFF;
        int var7 = var0 & 0xFF;
        int var8 = (int)((float)var5 * (1.0f - var1));
        int var9 = (int)((float)var6 * (1.0f - var1));
        int var10 = (int)((float)var7 * (1.0f - var1));
        return var4 << 24 | (var8 & 0xFF) << 16 | (var9 & 0xFF) << 8 | var10 & 0xFF;
    }

    public static int method17690(int var0, int var1, float var2) {
        int var5 = var0 >> 24 & 0xFF;
        int var6 = var0 >> 16 & 0xFF;
        int var7 = var0 >> 8 & 0xFF;
        int var8 = var0 & 0xFF;
        int var9 = var1 >> 24 & 0xFF;
        int var10 = var1 >> 16 & 0xFF;
        int var11 = var1 >> 8 & 0xFF;
        int var12 = var1 & 0xFF;
        float var13 = 1.0f - var2;
        float var14 = (float)var5 * var2 + (float)var9 * var13;
        float var15 = (float)var6 * var2 + (float)var10 * var13;
        float var16 = (float)var7 * var2 + (float)var11 * var13;
        float var17 = (float)var8 * var2 + (float)var12 * var13;
        return (int)var14 << 24 | ((int)var15 & 0xFF) << 16 | ((int)var16 & 0xFF) << 8 | (int)var17 & 0xFF;
    }

    public static java.awt.Color method17682(java.awt.Color ... var0) {
        if (var0 != null) {
            if (var0.length > 0) {
                float var3 = 1.0f / (float)var0.length;
                float var4 = 0.0f;
                float var5 = 0.0f;
                float var6 = 0.0f;
                float var7 = 0.0f;
                for (java.awt.Color var11 : var0) {
                    if (var11 == null) {
                        var11 = java.awt.Color.BLACK;
                    }
                    var4 += (float)var11.getRed() * var3;
                    var5 += (float)var11.getGreen() * var3;
                    var6 += (float)var11.getBlue() * var3;
                    var7 += (float)var11.getAlpha() * var3;
                }
                return new java.awt.Color(var4 / 255.0f, var5 / 255.0f, var6 / 255.0f, var7 / 255.0f);
            }
            return java.awt.Color.WHITE;
        }
        return java.awt.Color.WHITE;
    }

    public static java.awt.Color method17681(java.awt.Color var0, java.awt.Color var1, float var2) {
        float var5 = 1.0f - var2;
        float var6 = (float)var0.getRed() * var2 + (float)var1.getRed() * var5;
        float var7 = (float)var0.getGreen() * var2 + (float)var1.getGreen() * var5;
        float var8 = (float)var0.getBlue() * var2 + (float)var1.getBlue() * var5;
        return new java.awt.Color(var6 / 255.0f, var7 / 255.0f, var8 / 255.0f);
    }

    public static void transformVector(FloatBuffer matrixBuffer, float[] inputVector, float[] outputVector) {
        for (int i = 0; i < 4; ++i) {
            outputVector[i] = inputVector[0] * matrixBuffer.get(matrixBuffer.position() + i) + inputVector[1] * matrixBuffer.get(matrixBuffer.position() + 4 + i) + inputVector[2] * matrixBuffer.get(matrixBuffer.position() + 8 + i) + inputVector[3] * matrixBuffer.get(matrixBuffer.position() + 12 + i);
        }
    }
}

