/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.player.rotation;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;

public class RotationManager {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final Random random = new Random();
    private float currentYaw;
    private float currentPitch;
    private float targetYaw;
    private float targetPitch;
    private boolean rotating = false;
    private long rotationTime = System.currentTimeMillis();
    private static final float TICK_TIME = 0.05f;
    private float lastYawDiff = 0.0f;
    private float lastPitchDiff = 0.0f;
    private static final float YAW_PROPORTIONAL_GAIN = 12.0f;
    private static final float PITCH_PROPORTIONAL_GAIN = 10.0f;
    private static final float YAW_FEEDFORWARD_GAIN = 0.8f;
    private static final float PITCH_FEEDFORWARD_GAIN = 0.6f;
    private static final float MAX_YAW_SPEED = 720.0f;
    private static final float MAX_PITCH_SPEED = 360.0f;

    public void initialize() {
        this.currentYaw = RotationManager.mc.player != null ? RotationManager.mc.player.rotationYaw : 0.0f;
        this.currentPitch = RotationManager.mc.player != null ? RotationManager.mc.player.rotationPitch : 0.0f;
        this.targetYaw = this.currentYaw;
        this.targetPitch = this.currentPitch;
        this.rotating = false;
        this.lastYawDiff = 0.0f;
        this.lastPitchDiff = 0.0f;
    }

    public void setTargetRotation(float yaw, float pitch) {
        this.targetYaw = MathHelper.wrapDegrees(yaw);
        this.targetPitch = MathHelper.clamp(pitch, -90.0f, 90.0f);
        this.rotating = true;
    }

    public void updateRotations() {
        float timeDelta = 0.05f;
        float yawDiff = MathHelper.wrapDegrees(this.targetYaw - this.currentYaw);
        float pitchDiff = this.targetPitch - this.currentPitch;
        float yawAngularVelocity = (yawDiff - this.lastYawDiff) / timeDelta;
        float pitchAngularVelocity = (pitchDiff - this.lastPitchDiff) / timeDelta;
        this.lastYawDiff = yawDiff;
        this.lastPitchDiff = pitchDiff;
        float yawBaseSpeed = Math.abs(yawDiff) * 12.0f;
        float pitchBaseSpeed = Math.abs(pitchDiff) * 10.0f;
        float yawFeedForward = yawAngularVelocity * 0.8f;
        float pitchFeedForward = pitchAngularVelocity * 0.6f;
        float totalYawSpeed = Math.min(Math.abs(yawBaseSpeed + yawFeedForward), 720.0f);
        float totalPitchSpeed = Math.min(Math.abs(pitchBaseSpeed + pitchFeedForward), 360.0f);
        float yawMove = Math.signum(yawDiff) * totalYawSpeed * timeDelta;
        float pitchMove = Math.signum(pitchDiff) * totalPitchSpeed * timeDelta;
        yawMove = MathHelper.clamp(yawMove, -40.0f, 180.0f);
        pitchMove = MathHelper.clamp(pitchMove, -40.0f, 180.0f);
        this.currentYaw = Math.abs(yawMove) > Math.abs(yawDiff) ? this.targetYaw : MathHelper.wrapDegrees(this.currentYaw + yawMove);
        this.currentPitch = Math.abs(pitchMove) > Math.abs(pitchDiff) ? this.targetPitch : (this.currentPitch += pitchMove);
        this.currentPitch = MathHelper.clamp(this.currentPitch, -90.0f, 90.0f);
        if (Math.abs(yawDiff) < 0.1f && Math.abs(pitchDiff) < 0.1f) {
            this.rotating = false;
        }
    }

    public void smoothResetRotations(float playerYaw, float playerPitch) {
        this.setTargetRotation(playerYaw, playerPitch);
    }

    public float getCurrentYaw() {
        return this.currentYaw;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public boolean isRotating() {
        return this.rotating;
    }
}

